/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ContextThemeWrapper;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class WindowUtil {
    public static double getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public static int getNavigationBarHeight(Context context) {
        if (!WindowUtil.hasNavigationBar(context)) {
            return 0;
        }
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static boolean hasNavigationBar(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display display = WindowUtil.getWindowManager(context).getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.x != size.x || realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context, boolean isIncludeNav) {
        if (isIncludeNav) {
            return context.getResources().getDisplayMetrics().heightPixels + WindowUtil.getNavigationBarHeight(context);
        }
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void hideSystemBar(Context context) {
        ActionBar ab;
        AppCompatActivity appCompatActivity = WindowUtil.getAppCompActivity(context);
        if (appCompatActivity != null && (ab = appCompatActivity.getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        WindowUtil.scanForActivity(context).getWindow().addFlags(1024);
        WindowUtil.hideNavigationBar(context);
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void showSystemBar(Context context) {
        ActionBar ab;
        WindowUtil.scanForActivity(context).getWindow().clearFlags(1024);
        WindowUtil.showNavigationBar(context);
        AppCompatActivity appCompatActivity = WindowUtil.getAppCompActivity(context);
        if (appCompatActivity != null && (ab = appCompatActivity.getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
    }

    public static Activity scanForActivity(Context context) {
        return context == null ? null : (context instanceof Activity ? (Activity)context : (context instanceof ContextWrapper ? WindowUtil.scanForActivity(((ContextWrapper)context).getBaseContext()) : null));
    }

    private static void hideNavigationBar(Context context) {
        View decorView = WindowUtil.scanForActivity(context).getWindow().getDecorView();
        decorView.setSystemUiVisibility(4102);
    }

    private static void showNavigationBar(Context context) {
        View decorView = WindowUtil.scanForActivity(context).getWindow().getDecorView();
        int systemUiVisibility = decorView.getSystemUiVisibility();
        int flags = 4102;
        decorView.setSystemUiVisibility(systemUiVisibility &= ~flags);
    }

    public static AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return WindowUtil.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)2, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static WindowManager getWindowManager(Context context) {
        return (WindowManager)context.getSystemService("window");
    }

    public static boolean isEdge(Context context, MotionEvent e) {
        int edgeSize = WindowUtil.dp2px(context, 50.0f);
        return e.getRawX() < (float)edgeSize || e.getRawX() > (float)(WindowUtil.getScreenWidth(context) - edgeSize) || e.getRawY() < (float)edgeSize || e.getRawY() > (float)(WindowUtil.getScreenHeight(context, true) - edgeSize);
    }
}

