/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.OrientationEventListener;
import android.widget.FrameLayout;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.dueeeke.videoplayer.controller.BaseVideoController;
import com.dueeeke.videoplayer.listener.MediaEngineInterface;
import com.dueeeke.videoplayer.listener.MediaPlayerControl;
import com.dueeeke.videoplayer.listener.VideoListener;
import com.dueeeke.videoplayer.player.AndroidMediaEngine;
import com.dueeeke.videoplayer.player.BaseMediaEngine;
import com.dueeeke.videoplayer.player.IjkMediaEngine;
import com.dueeeke.videoplayer.player.VideoCacheManager;
import com.dueeeke.videoplayer.util.WindowUtil;
import java.io.File;

public abstract class BaseIjkVideoView
extends FrameLayout
implements MediaPlayerControl,
MediaEngineInterface {
    protected BaseMediaEngine mMediaPlayer;
    @Nullable
    protected BaseVideoController mVideoController;
    protected VideoListener listener;
    protected int bufferPercentage;
    protected boolean isMute;
    protected boolean useAndroidMediaPlayer;
    protected String mCurrentUrl;
    protected int mCurrentPosition;
    protected String mCurrentTitle = "";
    public static final int STATE_ERROR = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_PLAYBACK_COMPLETED = 5;
    public static final int STATE_BUFFERING = 6;
    public static final int STATE_BUFFERED = 7;
    protected int mCurrentState = 0;
    public static final int PLAYER_NORMAL = 10;
    public static final int PLAYER_FULL_SCREEN = 11;
    protected AudioManager mAudioManager;
    @NonNull
    protected AudioFocusHelper mAudioFocusHelper = new AudioFocusHelper();
    protected int currentOrientation = 0;
    protected static final int PORTRAIT = 1;
    protected static final int LANDSCAPE = 2;
    protected static final int REVERSE_LANDSCAPE = 3;
    protected boolean mAutoRotate;
    protected boolean isLockFullScreen;
    protected boolean isCache;
    protected boolean addToPlayerManager;
    protected OrientationEventListener orientationEventListener = new OrientationEventListener(this.getContext()){

        public void onOrientationChanged(int orientation) {
            if (BaseIjkVideoView.this.mVideoController == null) {
                return;
            }
            Activity activity = WindowUtil.scanForActivity(BaseIjkVideoView.this.mVideoController.getContext());
            if (activity == null) {
                return;
            }
            if (orientation >= 340) {
                BaseIjkVideoView.this.onOrientationPortrait(activity);
            } else if (orientation >= 260 && orientation <= 280) {
                BaseIjkVideoView.this.onOrientationLandscape(activity);
            } else if (orientation >= 70 && orientation <= 90) {
                BaseIjkVideoView.this.onOrientationReverseLandscape(activity);
            }
        }
    };
    private CacheListener cacheListener = new CacheListener(){

        public void onCacheAvailable(File cacheFile, String url, int percentsAvailable) {
            BaseIjkVideoView.this.bufferPercentage = percentsAvailable;
        }
    };

    protected void onOrientationPortrait(Activity activity) {
        if (this.isLockFullScreen || !this.mAutoRotate || this.currentOrientation == 1) {
            return;
        }
        if (!(this.currentOrientation != 2 && this.currentOrientation != 3 || this.isFullScreen())) {
            this.currentOrientation = 1;
            return;
        }
        this.currentOrientation = 1;
        activity.setRequestedOrientation(1);
        this.stopFullScreen();
    }

    protected void onOrientationLandscape(Activity activity) {
        if (this.currentOrientation == 2) {
            return;
        }
        if (this.currentOrientation == 1 && this.isFullScreen()) {
            this.currentOrientation = 2;
            return;
        }
        this.currentOrientation = 2;
        if (!this.isFullScreen()) {
            this.startFullScreen();
        }
        activity.setRequestedOrientation(0);
    }

    protected void onOrientationReverseLandscape(Activity activity) {
        if (this.currentOrientation == 3) {
            return;
        }
        if (this.currentOrientation == 1 && this.isFullScreen()) {
            this.currentOrientation = 3;
            return;
        }
        this.currentOrientation = 3;
        if (!this.isFullScreen()) {
            this.startFullScreen();
        }
        activity.setRequestedOrientation(8);
    }

    public BaseIjkVideoView(@NonNull Context context) {
        this(context, null);
    }

    public BaseIjkVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseIjkVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mAudioManager = (AudioManager)this.getContext().getApplicationContext().getSystemService("audio");
    }

    protected void initPlayer() {
        if (this.mMediaPlayer == null) {
            if (this.useAndroidMediaPlayer) {
                this.mMediaPlayer = new AndroidMediaEngine();
                ((AndroidMediaEngine)this.mMediaPlayer).setMediaEngineInterface(this);
            } else {
                this.mMediaPlayer = new IjkMediaEngine();
                ((IjkMediaEngine)this.mMediaPlayer).setMediaEngineInterface(this);
            }
            this.mMediaPlayer.initPlayer();
        }
    }

    protected abstract void setPlayState(int var1);

    protected abstract void setPlayerState(int var1);

    protected abstract boolean checkNetwork();

    protected void startPrepare() {
        if (this.mCurrentUrl == null || this.mCurrentUrl.trim().equals("")) {
            return;
        }
        try {
            if (this.isCache) {
                HttpProxyCacheServer cacheServer = this.getCacheServer();
                String proxyPath = cacheServer.getProxyUrl(this.mCurrentUrl);
                cacheServer.registerCacheListener(this.cacheListener, this.mCurrentUrl);
                if (cacheServer.isCached(this.mCurrentUrl)) {
                    this.bufferPercentage = 100;
                }
                this.mMediaPlayer.setDataSource(proxyPath);
            } else {
                this.mMediaPlayer.setDataSource(this.mCurrentUrl);
            }
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.setPlayState(this.mCurrentState);
            this.setPlayerState(this.isFullScreen() ? 11 : 10);
        }
        catch (Exception e) {
            this.mCurrentState = -1;
            this.setPlayState(this.mCurrentState);
            e.printStackTrace();
        }
    }

    private HttpProxyCacheServer getCacheServer() {
        return VideoCacheManager.getProxy(this.getContext().getApplicationContext());
    }

    @Override
    public void start() {
        if (this.mCurrentState == 0) {
            this.startPlay();
        } else if (this.isInPlaybackState()) {
            this.startInPlaybackState();
        }
        this.setKeepScreenOn(true);
        this.mAudioFocusHelper.requestFocus();
    }

    protected void startPlay() {
        if (this.mAutoRotate) {
            this.orientationEventListener.enable();
        }
        if (this.checkNetwork()) {
            return;
        }
        this.initPlayer();
        this.startPrepare();
    }

    protected void startInPlaybackState() {
        this.mMediaPlayer.start();
        this.mCurrentState = 3;
        this.setPlayState(this.mCurrentState);
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            this.setPlayState(this.mCurrentState);
            this.setKeepScreenOn(false);
            this.mAudioFocusHelper.abandonFocus();
        }
    }

    public void resume() {
        if (this.isInPlaybackState() && !this.mMediaPlayer.isPlaying() && this.mCurrentState != 5) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            this.setPlayState(this.mCurrentState);
            this.mAudioFocusHelper.requestFocus();
            this.setKeepScreenOn(true);
        }
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.setPlayState(this.mCurrentState);
            this.mAudioFocusHelper.abandonFocus();
            this.setKeepScreenOn(false);
        }
    }

    public void release() {
        if (this.mMediaPlayer != null) {
            new Thread(() -> {
                if (this.mMediaPlayer != null) {
                    this.mMediaPlayer.reset();
                    this.mMediaPlayer.release();
                    this.mMediaPlayer = null;
                }
            }).start();
            this.mCurrentState = 0;
            this.setPlayState(this.mCurrentState);
            this.mAudioFocusHelper.abandonFocus();
            this.setKeepScreenOn(false);
        }
        this.orientationEventListener.disable();
        if (this.isCache) {
            this.getCacheServer().unregisterCacheListener(this.cacheListener);
        }
        this.isLockFullScreen = false;
        this.mCurrentPosition = 0;
    }

    public void setVideoListener(VideoListener listener) {
        this.listener = listener;
    }

    protected boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    @Override
    public int getDuration() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return 0;
    }

    @Override
    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            this.mCurrentPosition = (int)this.mMediaPlayer.getCurrentPosition();
            return this.mCurrentPosition;
        }
        return 0;
    }

    @Override
    public void seekTo(int pos) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(pos);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getBufferPercentage() {
        return this.mMediaPlayer != null ? this.bufferPercentage : 0;
    }

    @Override
    public void setMute() {
        if (this.isMute) {
            this.mMediaPlayer.setVolume(1, 1);
            this.isMute = false;
        } else {
            this.mMediaPlayer.setVolume(0, 0);
            this.isMute = true;
        }
    }

    @Override
    public boolean isMute() {
        return this.isMute;
    }

    @Override
    public void setLock(boolean isLocked) {
        this.isLockFullScreen = isLocked;
    }

    @Override
    public boolean isFullScreen() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.mCurrentTitle;
    }

    @Override
    public void onError() {
        this.mCurrentState = -1;
        if (this.listener != null) {
            this.listener.onError();
        }
        this.setPlayState(this.mCurrentState);
        this.mCurrentPosition = this.getCurrentPosition();
    }

    @Override
    public void onCompletion() {
        this.mCurrentState = 5;
        if (this.listener != null) {
            this.listener.onComplete();
        }
        this.setPlayState(this.mCurrentState);
        this.setKeepScreenOn(false);
    }

    @Override
    public void onInfo(int what, int extra) {
        if (this.listener != null) {
            this.listener.onInfo(what, extra);
        }
        switch (what) {
            case 701: {
                this.mCurrentState = 6;
                this.setPlayState(this.mCurrentState);
                break;
            }
            case 702: {
                this.mCurrentState = 7;
                this.setPlayState(this.mCurrentState);
                break;
            }
            case 3: {
                if (this.getWindowVisibility() == 0) break;
                this.pause();
            }
        }
    }

    @Override
    public void onBufferingUpdate(int position) {
        if (!this.isCache) {
            this.bufferPercentage = position;
        }
    }

    @Override
    public void onPrepared() {
        this.mCurrentState = 2;
        if (this.listener != null) {
            this.listener.onPrepared();
        }
        this.setPlayState(this.mCurrentState);
        if (this.mCurrentPosition > 0) {
            this.seekTo(this.mCurrentPosition);
        }
        this.start();
    }

    private class AudioFocusHelper
    implements AudioManager.OnAudioFocusChangeListener {
        boolean startRequested = false;
        boolean pausedForLoss = false;
        int currentFocus = 0;

        private AudioFocusHelper() {
        }

        public void onAudioFocusChange(int focusChange) {
            if (this.currentFocus == focusChange) {
                return;
            }
            this.currentFocus = focusChange;
            switch (focusChange) {
                case 1: 
                case 2: {
                    if (!this.startRequested && !this.pausedForLoss) break;
                    BaseIjkVideoView.this.start();
                    this.startRequested = false;
                    this.pausedForLoss = false;
                    break;
                }
                case -1: {
                    if (!BaseIjkVideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    BaseIjkVideoView.this.pause();
                    break;
                }
                case -3: 
                case -2: {
                    if (!BaseIjkVideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    BaseIjkVideoView.this.pause();
                }
            }
        }

        boolean requestFocus() {
            if (this.currentFocus == 1) {
                return true;
            }
            if (BaseIjkVideoView.this.mAudioManager == null) {
                return false;
            }
            int status = BaseIjkVideoView.this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
            if (1 == status) {
                this.currentFocus = 1;
                return true;
            }
            this.startRequested = true;
            return false;
        }

        boolean abandonFocus() {
            if (BaseIjkVideoView.this.mAudioManager == null) {
                return false;
            }
            this.startRequested = false;
            int status = BaseIjkVideoView.this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            return 1 == status;
        }
    }
}

