/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.controller;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.dueeeke.videoplayer.R;
import com.dueeeke.videoplayer.listener.ControllerListener;
import com.dueeeke.videoplayer.listener.MediaPlayerControl;
import com.dueeeke.videoplayer.util.Constants;
import com.dueeeke.videoplayer.util.WindowUtil;
import com.dueeeke.videoplayer.widget.CenterView;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public abstract class BaseVideoController
extends FrameLayout {
    protected View controllerView;
    protected MediaPlayerControl mediaPlayer;
    protected boolean mShowing;
    protected CenterView mCenterView;
    protected AudioManager mAudioManager;
    protected boolean isLocked;
    protected int sDefaultTimeout = 3000;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private GestureDetector mGestureDetector;
    protected boolean gestureEnabled;
    private float downX;
    private float downY;
    protected ControllerListener listener;
    protected int currentPlayState;
    protected Runnable mShowProgress = new Runnable(){

        @Override
        public void run() {
            int pos = BaseVideoController.this.setProgress();
            if (BaseVideoController.this.mediaPlayer.isPlaying()) {
                BaseVideoController.this.postDelayed(BaseVideoController.this.mShowProgress, 1000 - pos % 1000);
            }
        }
    };
    protected final Runnable mFadeOut = this::hide;
    protected int streamVolume;
    protected float mBrightness;
    protected int mPosition;
    protected boolean mNeedSeek;

    public BaseVideoController(@NonNull Context context) {
        this(context, null);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void initView() {
        this.controllerView = LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this);
        this.mCenterView = new CenterView(this.getContext());
        this.mCenterView.setVisibility(8);
        this.addView((View)this.mCenterView);
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.setClickable(true);
        this.setFocusable(true);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new MyGestureListener());
        this.setOnTouchListener((v, event) -> this.mGestureDetector.onTouchEvent(event));
    }

    protected abstract int getLayoutId();

    public void show() {
    }

    public void hide() {
    }

    public void setPlayState(int playState) {
        this.currentPlayState = playState;
    }

    public void setPlayerState(int playerState) {
    }

    public void setControllerListener(ControllerListener listener) {
        this.listener = listener;
    }

    protected void doPauseResume() {
        if (this.currentPlayState == 6) {
            return;
        }
        if (this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        } else {
            this.mediaPlayer.start();
        }
    }

    protected void doStartStopFullScreen() {
        if (this.mediaPlayer.isFullScreen()) {
            WindowUtil.scanForActivity(this.getContext()).setRequestedOrientation(1);
            this.mediaPlayer.stopFullScreen();
        } else {
            WindowUtil.scanForActivity(this.getContext()).setRequestedOrientation(0);
            this.mediaPlayer.startFullScreen();
        }
    }

    protected int setProgress() {
        return 0;
    }

    protected String getCurrentSystemTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm", Locale.CHINA);
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downX = ev.getX();
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float absDeltaX = Math.abs(ev.getX() - this.downX);
                float absDeltaY = Math.abs(ev.getY() - this.downY);
                if (!(absDeltaX > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) && !(absDeltaY > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop())) break;
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean detectedUp;
        boolean bl = detectedUp = event.getAction() == 1;
        if (!this.mGestureDetector.onTouchEvent(event) && detectedUp) {
            if (this.mCenterView.getVisibility() == 0) {
                this.mCenterView.setVisibility(8);
            }
            if (this.mNeedSeek) {
                this.mediaPlayer.seekTo(this.mPosition);
                this.mNeedSeek = false;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void slideToChangePosition(float deltaX) {
        this.mCenterView.setVisibility(0);
        this.hide();
        this.mCenterView.setProVisibility(8);
        deltaX = -deltaX;
        int width = this.getMeasuredWidth();
        int duration = this.mediaPlayer.getDuration();
        int currentPosition = this.mediaPlayer.getCurrentPosition();
        int position = (int)(deltaX / (float)width * (float)duration + (float)currentPosition);
        if (position > currentPosition) {
            this.mCenterView.setIcon(R.drawable.ic_action_fast_forward);
        } else {
            this.mCenterView.setIcon(R.drawable.ic_action_fast_rewind);
        }
        if (position > duration) {
            position = duration;
        }
        if (position < 0) {
            position = 0;
        }
        this.mPosition = position;
        this.mCenterView.setTextView(this.stringForTime(position) + "/" + this.stringForTime(duration));
        this.mNeedSeek = true;
    }

    protected void slideToChangeBrightness(float deltaY) {
        float brightness;
        this.mCenterView.setVisibility(0);
        this.hide();
        this.mCenterView.setProVisibility(0);
        Window window = WindowUtil.scanForActivity(this.getContext()).getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        this.mCenterView.setIcon(R.drawable.ic_action_brightness);
        int height = this.getMeasuredHeight();
        if (this.mBrightness == -1.0f) {
            this.mBrightness = 0.5f;
        }
        if ((brightness = deltaY * 2.0f / (float)height * 1.0f + this.mBrightness) < 0.0f) {
            brightness = 0.0f;
        }
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        int percent = (int)(brightness * 100.0f);
        this.mCenterView.setTextView(percent + "%");
        this.mCenterView.setProPercent(percent);
        attributes.screenBrightness = brightness;
        window.setAttributes(attributes);
    }

    protected void slideToChangeVolume(float deltaY) {
        this.mCenterView.setVisibility(0);
        this.hide();
        this.mCenterView.setProVisibility(0);
        int streamMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        int height = this.getMeasuredHeight();
        float deltaV = deltaY * 2.0f / (float)height * (float)streamMaxVolume;
        float index = (float)this.streamVolume + deltaV;
        if (index > (float)streamMaxVolume) {
            index = streamMaxVolume;
        }
        if (index < 0.0f) {
            this.mCenterView.setIcon(R.drawable.ic_action_volume_off);
            index = 0.0f;
        } else {
            this.mCenterView.setIcon(R.drawable.ic_action_volume_up);
        }
        int percent = (int)(index / (float)streamMaxVolume * 100.0f);
        this.mCenterView.setTextView(percent + "%");
        this.mCenterView.setProPercent(percent);
        this.mAudioManager.setStreamVolume(3, (int)index, 0);
    }

    protected String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.post(this.mShowProgress);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.post(this.mShowProgress);
        }
    }

    public boolean onBackPressed() {
        return false;
    }

    public void setMediaPlayer(MediaPlayerControl mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    private class MyGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean firstTouch;
        private boolean mChangePosition;
        private boolean mChangeBrightness;
        private boolean mChangeVolume;

        private MyGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (!BaseVideoController.this.gestureEnabled || WindowUtil.isEdge(BaseVideoController.this.getContext(), e)) {
                return super.onDown(e);
            }
            BaseVideoController.this.streamVolume = BaseVideoController.this.mAudioManager.getStreamVolume(3);
            BaseVideoController.this.mBrightness = WindowUtil.scanForActivity((Context)BaseVideoController.this.getContext()).getWindow().getAttributes().screenBrightness;
            this.firstTouch = true;
            this.mChangePosition = false;
            this.mChangeBrightness = false;
            this.mChangeVolume = false;
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (BaseVideoController.this.mShowing) {
                BaseVideoController.this.hide();
            } else {
                BaseVideoController.this.show();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!BaseVideoController.this.gestureEnabled || WindowUtil.isEdge(BaseVideoController.this.getContext(), e1)) {
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
            float deltaX = e1.getX() - e2.getX();
            float deltaY = e1.getY() - e2.getY();
            if (this.firstTouch) {
                boolean bl = this.mChangePosition = Math.abs(distanceX) >= Math.abs(distanceY);
                if (!this.mChangePosition) {
                    if (e2.getX() > (float)(Constants.SCREEN_HEIGHT / 2)) {
                        this.mChangeBrightness = true;
                    } else {
                        this.mChangeVolume = true;
                    }
                }
                this.firstTouch = false;
            }
            if (this.mChangePosition) {
                BaseVideoController.this.slideToChangePosition(deltaX);
            } else if (this.mChangeBrightness) {
                BaseVideoController.this.slideToChangeBrightness(deltaY);
            } else if (this.mChangeVolume) {
                BaseVideoController.this.slideToChangeVolume(deltaY);
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (!BaseVideoController.this.isLocked) {
                BaseVideoController.this.doPauseResume();
            }
            return true;
        }
    }
}

