/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.StateSet;
import android.view.MotionEvent;
import java.util.HashMap;
import java.util.Map;
import top.defaults.view.EffectSet;
import top.defaults.view.EffectSettings;
import top.defaults.view.LayerDrawableProxy;
import top.defaults.view.TextButtonEffect;
import top.defaults.view.textbutton.R;

public class TextButton
extends AppCompatTextView {
    private static final boolean DEBUG = false;
    @ColorInt
    int defaultTextColor;
    @ColorInt
    int pressedTextColor;
    @ColorInt
    int disabledTextColor;
    @ColorInt
    int selectedTextColor;
    boolean isUnderlined;
    int effectType;
    int effectDuration;
    @ColorInt
    int defaultBackgroundColor;
    @ColorInt
    int pressedBackgroundColor;
    @ColorInt
    int disabledBackgroundColor;
    @ColorInt
    int selectedBackgroundColor;
    int backgroundEffectType;
    @ColorInt
    int rippleColor;
    private EffectSet effects;
    private Drawable instinctBackground;
    private LayerDrawableProxy backgroundProxy = new LayerDrawableProxy(new Drawable[0]);

    private int getColor(TypedArray typedArray, int key, int defaultValue) {
        return typedArray.getColor(key, Defaults.get().getInt(key, defaultValue).intValue());
    }

    private int getInt(TypedArray typedArray, int key, int defaultValue) {
        return typedArray.getInt(key, Defaults.get().getInt(key, defaultValue).intValue());
    }

    private boolean getBoolean(TypedArray typedArray, int key, boolean defaultValue) {
        return typedArray.getBoolean(key, Defaults.get().getBoolean(key, defaultValue).booleanValue());
    }

    public TextButton(Context context) {
        this(context, null);
    }

    public TextButton(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClickable(true);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextButton);
        this.defaultTextColor = this.getColor(typedArray, R.styleable.TextButton_defaultTextColor, this.getCurrentTextColor());
        this.pressedTextColor = this.getColor(typedArray, R.styleable.TextButton_pressedTextColor, this.calculatePressedColor(this.defaultTextColor));
        this.disabledTextColor = this.getColor(typedArray, R.styleable.TextButton_disabledTextColor, this.calculateDisabledColor(this.defaultTextColor));
        this.selectedTextColor = this.getColor(typedArray, R.styleable.TextButton_selectedTextColor, this.calculateSelectedColor(this.defaultTextColor));
        this.isUnderlined = this.getBoolean(typedArray, R.styleable.TextButton_underline, false);
        this.effectType = this.getInt(typedArray, R.styleable.TextButton_textEffect, 0);
        this.effectDuration = this.getInt(typedArray, R.styleable.TextButton_effectDuration, -1);
        this.defaultBackgroundColor = this.getColor(typedArray, R.styleable.TextButton_defaultBackgroundColor, 0);
        this.pressedBackgroundColor = this.getColor(typedArray, R.styleable.TextButton_pressedBackgroundColor, this.calculatePressedColor(this.defaultBackgroundColor));
        this.disabledBackgroundColor = this.getColor(typedArray, R.styleable.TextButton_disabledBackgroundColor, this.calculateDisabledColor(this.defaultBackgroundColor));
        this.selectedBackgroundColor = this.getColor(typedArray, R.styleable.TextButton_selectedBackgroundColor, this.calculateSelectedColor(this.defaultBackgroundColor));
        this.backgroundEffectType = this.getInt(typedArray, R.styleable.TextButton_backgroundEffect, -1);
        this.rippleColor = this.getColor(typedArray, R.styleable.TextButton_rippleColor, this.defaultTextColor);
        typedArray.recycle();
        this.instinctBackground = this.getBackground();
        this.apply();
    }

    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(10);
        settings.put("key_effect_duration", this.effectDuration);
        EffectSettings.reviewAndAdjustSettings(this.effectType, settings);
        return settings;
    }

    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable(background);
        this.instinctBackground = background;
        this.apply();
    }

    public void setEffects(TextButtonEffect ... effects) {
        this.effects.clear();
        if (effects.length == 0) {
            this.effects = null;
        } else {
            this.effects.add(effects);
        }
        this.apply();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.apply();
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.apply();
    }

    public void addRipple() {
        if (this.effects == null) {
            this.effects = new EffectSet();
        }
        this.effects.addRipple();
        this.apply();
    }

    public void removeRipple() {
        if (this.effects != null) {
            this.effects.removeRipple();
        }
        this.apply();
    }

    private void apply() {
        this.setDefaultTextColorState();
        this.backgroundProxy.clear().addLayer(this.instinctBackground);
        this.setBackgroundWithProxy(this.backgroundProxy);
        if (this.effects == null) {
            this.effects = TextButtonEffect.Factory.create(this);
        }
        this.effects.init(this);
        if (this.isUnderlined) {
            this.setPaintFlags(this.getPaintFlags() | 8);
        }
        this.setGravity(17);
    }

    private int calculatePressedColor(@ColorInt int defaultColor) {
        int alpha = Color.alpha((int)defaultColor);
        alpha = Math.max(16, alpha - 96);
        return Color.argb((int)alpha, (int)Color.red((int)defaultColor), (int)Color.green((int)defaultColor), (int)Color.blue((int)defaultColor));
    }

    private int calculateDisabledColor(@ColorInt int defaultColor) {
        int alpha = Color.alpha((int)defaultColor);
        float[] hsv = new float[3];
        Color.colorToHSV((int)defaultColor, (float[])hsv);
        if (hsv[2] < 0.3f) {
            return -5592406;
        }
        hsv[2] = Math.max(0.0f, hsv[2] - 0.3f);
        return Color.HSVToColor((int)alpha, (float[])hsv);
    }

    private int calculateSelectedColor(@ColorInt int defaultColor) {
        int alpha = Color.alpha((int)defaultColor);
        float[] hsv = new float[3];
        Color.colorToHSV((int)defaultColor, (float[])hsv);
        if (hsv[2] > 0.7f) {
            return -769226;
        }
        hsv[2] = Math.min(1.0f, hsv[2] + 0.3f);
        return Color.HSVToColor((int)alpha, (float[])hsv);
    }

    ColorStateList getTextColorState() {
        return new ColorStateList((int[][])new int[][]{{16842919}, {-16842910}, {0x10100A1}, new int[0]}, new int[]{this.pressedTextColor, this.disabledTextColor, this.selectedTextColor, this.defaultTextColor});
    }

    void setDefaultTextColorState() {
        this.setTextColor(this.getTextColorState());
    }

    private StateListDrawable getBackgroundColorStateDrawable() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(this.pressedBackgroundColor));
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)new ColorDrawable(this.disabledBackgroundColor));
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)new ColorDrawable(this.selectedBackgroundColor));
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)new ColorDrawable(this.defaultBackgroundColor));
        return stateListDrawable;
    }

    void setColorStateBackground() {
        this.setBackgroundWithProxy(this.backgroundProxy.addLayer((Drawable)this.getBackgroundColorStateDrawable()));
    }

    public LayerDrawableProxy getBackgroundProxy() {
        return this.backgroundProxy;
    }

    public void setBackgroundWithProxy(LayerDrawableProxy backgroundProxy) {
        this.backgroundProxy = backgroundProxy;
        super.setBackgroundDrawable((Drawable)backgroundProxy.get());
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled() && this.isClickable()) {
            switch (event.getAction()) {
                case 0: {
                    this.effects.actionDown();
                    break;
                }
                case 1: {
                    this.effects.actionUp();
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public static class Defaults {
        private static Defaults defaults = new Defaults();
        private SparseArray<Object> settings = new SparseArray();

        public static Defaults get() {
            return defaults;
        }

        Integer getInt(int key, int defaultValue) {
            Object o = this.settings.get(key);
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return defaultValue;
        }

        Boolean getBoolean(int key, boolean defaultValue) {
            Object o = this.settings.get(key);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return defaultValue;
        }

        public void set(int key, Object o) {
            this.settings.put(key, o);
        }
    }
}

