/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import top.defaults.view.AnimateBackgroundColorEffect;
import top.defaults.view.AnimateTextColorEffect;
import top.defaults.view.AnimateTextSizeEffect;
import top.defaults.view.ColorStateBackgroundEffect;
import top.defaults.view.EffectSet;
import top.defaults.view.RippleEffect;
import top.defaults.view.TextButton;

public interface TextButtonEffect {
    public static final int TEXT_EFFECT_DEFAULT = 0;
    public static final int TEXT_EFFECT_ANIMATE_COLOR = 1;
    public static final int TEXT_EFFECT_ANIMATE_SIZE = 2;
    public static final int TEXT_EFFECT_ANIMATE_COLOR_AND_SIZE = 3;
    public static final int BACKGROUND_EFFECT_NONE = -1;
    public static final int BACKGROUND_EFFECT_COLOR_STATE = 0;
    public static final int BACKGROUND_EFFECT_RIPPLE = 1;
    public static final int BACKGROUND_EFFECT_ANIMATE_COLOR = 2;

    public void init(TextButton var1);

    public void actionDown();

    public void actionUp();

    public static class Factory {
        static EffectSet create(TextButton textButton) {
            EffectSet effectSet = new EffectSet();
            switch (textButton.effectType) {
                case 1: {
                    effectSet.add(new AnimateTextColorEffect());
                    break;
                }
                case 2: {
                    effectSet.add(new AnimateTextSizeEffect());
                    break;
                }
                case 3: {
                    effectSet.add(new AnimateTextColorEffect());
                    effectSet.add(new AnimateTextSizeEffect());
                    break;
                }
            }
            switch (textButton.backgroundEffectType) {
                case 0: {
                    effectSet.add(new ColorStateBackgroundEffect());
                    break;
                }
                case 1: {
                    effectSet.add(new RippleEffect());
                    break;
                }
                case 2: {
                    effectSet.add(new AnimateBackgroundColorEffect());
                    break;
                }
            }
            effectSet.init(textButton);
            return effectSet;
        }
    }
}

