/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.Map;
import top.defaults.view.MapUtil;

public class EffectSettings {
    static final String KEY_EFFECT_DURATION = "key_effect_duration";
    private static final Interpolator DEFAULT_INTERPOLATOR = new AccelerateInterpolator();
    private static final int DURATION_SHORT = 100;
    private static final int DURATION_MEDIUM = 200;
    private static final int DURATION_LONG = 300;
    private static final int DEFAULT_DURATION = 100;

    static void apply(ValueAnimator animator, Map<String, Object> settings) {
        animator.setInterpolator((TimeInterpolator)DEFAULT_INTERPOLATOR);
        animator.setDuration((long)MapUtil.getIntOrDefault(settings, KEY_EFFECT_DURATION, 100));
    }

    static void reviewAndAdjustSettings(int type, Map<String, Object> origin) {
        if (MapUtil.getIntOrDefault(origin, KEY_EFFECT_DURATION, -1) <= 0) {
            switch (type) {
                case 1: {
                    origin.put(KEY_EFFECT_DURATION, 300);
                    break;
                }
                case 3: {
                    origin.put(KEY_EFFECT_DURATION, 200);
                    break;
                }
                default: {
                    origin.put(KEY_EFFECT_DURATION, 100);
                }
            }
        }
    }
}

