/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import top.defaults.view.BackgroundEffect;
import top.defaults.view.RippleEffect;
import top.defaults.view.TextButton;
import top.defaults.view.TextButtonEffect;

public class EffectSet
implements TextButtonEffect {
    private List<TextButtonEffect> effects = new ArrayList<TextButtonEffect>();

    public void add(TextButtonEffect ... effects) {
        this.effects.addAll(Arrays.asList(effects));
    }

    public void clear() {
        this.effects.clear();
    }

    public void addRipple() {
        if (!this.hasRipple()) {
            this.effects.add(new RippleEffect());
        }
    }

    public void removeRipple() {
        for (int i = this.effects.size() - 1; i >= 0; --i) {
            TextButtonEffect effect = this.effects.get(i);
            if (!(effect instanceof RippleEffect)) continue;
            ((RippleEffect)effect).restore();
            this.effects.remove(effect);
        }
    }

    private boolean hasRipple() {
        boolean hasRipple = false;
        for (TextButtonEffect effect : this.effects) {
            if (!(effect instanceof RippleEffect)) continue;
            hasRipple = true;
            break;
        }
        return hasRipple;
    }

    @Override
    public void init(TextButton textButton) {
        boolean hasRipple = this.hasRipple();
        for (TextButtonEffect effect : this.effects) {
            if (hasRipple && effect instanceof BackgroundEffect && !(effect instanceof RippleEffect)) continue;
            effect.init(textButton);
        }
    }

    @Override
    public void actionDown() {
        boolean hasRipple = this.hasRipple();
        for (TextButtonEffect effect : this.effects) {
            if (hasRipple && effect instanceof BackgroundEffect && !(effect instanceof RippleEffect)) continue;
            effect.actionDown();
        }
    }

    @Override
    public void actionUp() {
        boolean hasRipple = this.hasRipple();
        for (TextButtonEffect effect : this.effects) {
            if (hasRipple && effect instanceof BackgroundEffect && !(effect instanceof RippleEffect)) continue;
            effect.actionUp();
        }
    }
}

