/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import top.defaults.view.BackgroundEffect;
import top.defaults.view.EffectSettings;
import top.defaults.view.TextButton;

public class AnimateBackgroundColorEffect
implements BackgroundEffect {
    private ValueAnimator pressColorAnimation;
    private TextButton textButton;
    private ColorDrawable ownLayer;
    private Runnable reverseAnimation;

    @Override
    public void init(final TextButton textButton) {
        this.restore();
        this.textButton = textButton;
        this.pressColorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{textButton.defaultBackgroundColor, textButton.pressedBackgroundColor});
        EffectSettings.apply(this.pressColorAnimation, textButton.getSettings());
        this.ownLayer = new ColorDrawable(textButton.defaultBackgroundColor);
        textButton.setBackgroundWithProxy(textButton.getBackgroundProxy().addLayer((Drawable)this.ownLayer));
        this.pressColorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimateBackgroundColorEffect.this.ownLayer.setColor(((Integer)animation.getAnimatedValue()).intValue());
                textButton.invalidate();
            }
        });
        this.pressColorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation, boolean isReverse) {
                if (isReverse) {
                    AnimateBackgroundColorEffect.this.ownLayer.setColor(textButton.defaultBackgroundColor);
                    textButton.invalidate();
                }
            }

            public void onAnimationCancel(Animator animation) {
                AnimateBackgroundColorEffect.this.ownLayer.setColor(textButton.defaultBackgroundColor);
                textButton.invalidate();
            }
        });
    }

    private void restore() {
        if (this.textButton != null) {
            this.textButton.setBackgroundWithProxy(this.textButton.getBackgroundProxy().removeLayer((Drawable)this.ownLayer));
        }
    }

    @Override
    public void actionDown() {
        this.pressColorAnimation.cancel();
        this.textButton.removeCallbacks(this.reverseAnimation);
        this.pressColorAnimation.start();
    }

    @Override
    public void actionUp() {
        this.reverseAnimation = new Runnable(){

            @Override
            public void run() {
                AnimateBackgroundColorEffect.this.pressColorAnimation.reverse();
            }
        };
        this.textButton.postDelayed(this.reverseAnimation, this.pressColorAnimation.getDuration() - this.pressColorAnimation.getCurrentPlayTime());
    }
}

