/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.res.ColorStateList;
import top.defaults.view.AnimateTextColorEffect;
import top.defaults.view.AnimateTextSizeEffect;
import top.defaults.view.TextButton;

public interface TextButtonEffect {
    public static final int EFFECT_DEFAULT = 0;
    public static final int EFFECT_ANIMATE_TEXT_COLOR = 1;
    public static final int EFFECT_ANIMATE_TEXT_SIZE = 2;
    public static final int EFFECT_ANIMATE_TEXT_COLOR_AND_SIZE = 3;

    public void init(TextButton var1);

    public void actionDown();

    public void actionUp();

    public static class DefaultEffect
    implements TextButtonEffect {
        @Override
        public void init(TextButton textButton) {
        }

        @Override
        public void actionDown() {
        }

        @Override
        public void actionUp() {
        }
    }

    public static class Factory {
        static TextButtonEffect create(TextButton textButton) {
            TextButtonEffect effect;
            ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}, {-16842910}, new int[0]}, new int[]{textButton.pressedTextColor, textButton.disabledTextColor, textButton.defaultTextColor});
            textButton.setTextColor(colorStateList);
            switch (textButton.effectType) {
                case 1: {
                    effect = new AnimateTextColorEffect();
                    break;
                }
                case 2: {
                    effect = new AnimateTextSizeEffect();
                    break;
                }
                case 3: {
                    effect = new TextButtonEffect(){
                        AnimateTextColorEffect colorEffect = new AnimateTextColorEffect();
                        AnimateTextSizeEffect sizeEffect = new AnimateTextSizeEffect();

                        @Override
                        public void init(TextButton textButton) {
                            this.colorEffect.init(textButton);
                            this.sizeEffect.init(textButton);
                        }

                        @Override
                        public void actionDown() {
                            this.colorEffect.actionDown();
                            this.sizeEffect.actionDown();
                        }

                        @Override
                        public void actionUp() {
                            this.colorEffect.actionUp();
                            this.sizeEffect.actionUp();
                        }
                    };
                    break;
                }
                default: {
                    effect = new DefaultEffect();
                }
            }
            effect.init(textButton);
            return effect;
        }
    }
}

