/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.drawabletoolbox;

import android.graphics.drawable.GradientDrawable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002\u001a=\u0010\b\u001a\u00020\t2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\n\u001a\u00020\u00062\u001a\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\f\"\u0006\u0012\u0002\b\u00030\u0001H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017\u001a\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017\u001a\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001f\"\u0012\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"gradientState", "Ljava/lang/Class;", "resolveField", "Ljava/lang/reflect/Field;", "source", "fieldName", "", "resolveGradientState", "resolveMethod", "Ljava/lang/reflect/Method;", "methodName", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "setColors", "", "drawable", "Landroid/graphics/drawable/GradientDrawable;", "value", "", "setGradientRadius", "", "setGradientRadiusType", "", "setInnerRadius", "setInnerRadiusRatio", "setOrientation", "Landroid/graphics/drawable/GradientDrawable$Orientation;", "setThickness", "setThicknessRatio", "setUseLevelForShape", "", "drawabletoolbox_release"})
public final class ReflectionsKt {
    private static final Class<?> gradientState = ReflectionsKt.resolveGradientState();

    private static final Class<?> resolveGradientState() {
        Class<?>[] classes = GradientDrawable.class.getDeclaredClasses();
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> singleClass;
            Class<?> clazz = singleClass = classes[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"singleClass");
            if (!Intrinsics.areEqual((Object)clazz.getSimpleName(), (Object)"GradientState")) continue;
            return singleClass;
        }
        throw (Throwable)new RuntimeException("GradientState could not be found in current GradientDrawable implementation");
    }

    private static final Field resolveField(Class<?> source, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field;
        Field field2 = field = source.getDeclaredField(fieldName);
        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
        field2.setAccessible(true);
        return field;
    }

    private static final Method resolveMethod(Class<?> source, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method method;
        Method method2 = method = source.getDeclaredMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
        method2.setAccessible(true);
        return method;
    }

    public static final void setInnerRadius(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = ReflectionsKt.resolveField(gradientState, "mInnerRadius");
            innerRadius.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setInnerRadiusRatio(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = ReflectionsKt.resolveField(gradientState, "mInnerRadiusRatio");
            innerRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setThickness(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = ReflectionsKt.resolveField(gradientState, "mThickness");
            innerRadius.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setThicknessRatio(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = ReflectionsKt.resolveField(gradientState, "mThicknessRatio");
            innerRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setUseLevelForShape(@NotNull GradientDrawable drawable, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field useLevelForShape = ReflectionsKt.resolveField(gradientState, "mUseLevelForShape");
            useLevelForShape.setBoolean(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setOrientation(@NotNull GradientDrawable drawable, @NotNull GradientDrawable.Orientation value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            Field orientation = ReflectionsKt.resolveField(gradientState, "mOrientation");
            orientation.set(drawable.getConstantState(), value);
            Field rectIdDirty = ReflectionsKt.resolveField(GradientDrawable.class, "mRectIsDirty");
            rectIdDirty.setBoolean(drawable, true);
            drawable.invalidateSelf();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setColors(@NotNull GradientDrawable drawable, @NotNull int[] value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            Field colors = ReflectionsKt.resolveField(gradientState, "mColors");
            colors.set(drawable.getConstantState(), value);
            drawable.invalidateSelf();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setGradientRadiusType(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field type = ReflectionsKt.resolveField(gradientState, "mGradientRadiusType");
            type.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setGradientRadius(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field gradientRadius = ReflectionsKt.resolveField(gradientState, "mGradientRadius");
            gradientRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

