/*
 * Decompiled with CFR 0.152.
 */
package com.fonfon.kgeohash;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.fonfon.kgeohash.BoundingBox;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0012\b\u0016\u0018\u0000 b2\u00020\u0001:\u0001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB!\b\u0017\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013B\u0017\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B\u0017\b\u0012\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001cJ\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020BH\u0002J\b\u0010D\u001a\u00020BH\u0002J\u0013\u0010E\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u001e\u00a2\u0006\u0002\u0010 J\t\u0010F\u001a\u00020\u0000H\u0086\u0002J\b\u0010G\u001a\u00020\bH\u0016J\u0018\u0010H\u001a\u00020B2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u0018\u0010M\u001a\u00020B2\u0006\u0010N\u001a\u00020\u00112\u0006\u0010I\u001a\u00020JH\u0002J\u0013\u0010O\u001a\u00020L2\b\u0010P\u001a\u0004\u0018\u00010QH\u0096\u0002J\u0018\u0010R\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020\bH\u0002J\u0018\u0010U\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010V\u001a\u00020\bH\u0016J\t\u0010W\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010X\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u00152\u0006\u0010Y\u001a\u00020\u0015H\u0002J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\bJ\b\u0010\\\u001a\u0004\u0018\u00010\u0000J\u0010\u0010]\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010^\u001a\u00020\u0006J\b\u0010_\u001a\u00020\u000eH\u0016J\u0018\u0010`\u001a\u00020B2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010a\u001a\u00020\bH\u0016R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\b0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010:R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b>\u0010.R\u0011\u0010?\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b@\u0010.\u00a8\u0006c"}, d2={"Lcom/fonfon/kgeohash/GeoHash;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "location", "Landroid/location/Location;", "charsCount", "", "(Landroid/location/Location;I)V", "boundingBox", "Lcom/fonfon/kgeohash/BoundingBox;", "(Lcom/fonfon/kgeohash/BoundingBox;I)V", "hash", "", "(Ljava/lang/String;)V", "lat", "", "lon", "(DDI)V", "hashVal", "", "significantBits", "", "(JB)V", "latBits", "", "lonBits", "([J[J)V", "adjacent", "", "getAdjacent", "()[Lcom/fonfon/kgeohash/GeoHash;", "adjacentBox", "getAdjacentBox", "bits", "<set-?>", "getBoundingBox", "()Lcom/fonfon/kgeohash/BoundingBox;", "setBoundingBox", "(Lcom/fonfon/kgeohash/BoundingBox;)V", "decodeMap", "Ljava/util/HashMap;", "", "easternNeighbour", "getEasternNeighbour", "()Lcom/fonfon/kgeohash/GeoHash;", "northernNeighbour", "getNorthernNeighbour", "numberOfLatLonBits", "", "getNumberOfLatLonBits", "()[I", "ord", "getOrd", "()J", "rightAlignedLatitudeBits", "getRightAlignedLatitudeBits", "()[J", "rightAlignedLongitudeBits", "getRightAlignedLongitudeBits", "southernNeighbour", "getSouthernNeighbour", "westernNeighbour", "getWesternNeighbour", "addOffBitToEnd", "", "addOnBitToEnd", "checkConvert", "childs", "dec", "describeContents", "divideRangeDecode", "range", "", "b", "", "divideRangeEncode", "value", "equals", "other", "", "extractEverySecondBit", "copyOfBits", "numberOfBits", "generateLocation", "hashCode", "inc", "maskLastNBits", "n", "next", "step", "parent", "precisionFromCharCount", "toLocation", "toString", "writeToParcel", "flags", "CREATOR", "library_release"})
public class GeoHash
implements Parcelable {
    private final HashMap<Character, Integer> decodeMap;
    private long bits;
    private byte significantBits;
    @NotNull
    private BoundingBox boundingBox;
    @NotNull
    public static final String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    public static final int BASE32_BITS = 5;
    public static final int MAX_CHARACTER_PRECISION = 12;
    public static final int MAX_GEO_HASH_BITS_COUNT = 60;
    public static final long FIRST_BIT_FLAGGED = Long.MIN_VALUE;
    public static final double LATITUDE_MAX_ABS = 90.0;
    public static final double LONGITUDE_MAX_ABS = 180.0;
    private static final int MAX_BIT_PRECISION;
    @NotNull
    private static final int[] BITS;
    public static final CREATOR CREATOR;

    @NotNull
    public final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    private final void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    @NotNull
    public final GeoHash getNorthernNeighbour() {
        GeoHash geoHash;
        long[] lArray = this.getRightAlignedLatitudeBits();
        GeoHash geoHash2 = geoHash;
        GeoHash geoHash3 = geoHash;
        long[] it = lArray;
        it[0] = it[0] + 1L;
        it[0] = this.maskLastNBits(it[0], it[1]);
        long[] lArray2 = lArray;
        geoHash2(lArray2, this.getRightAlignedLongitudeBits());
        return geoHash3;
    }

    @NotNull
    public final GeoHash getSouthernNeighbour() {
        GeoHash geoHash;
        long[] lArray = this.getRightAlignedLatitudeBits();
        GeoHash geoHash2 = geoHash;
        GeoHash geoHash3 = geoHash;
        long[] it = lArray;
        it[0] = it[0] + -1L;
        it[0] = this.maskLastNBits(it[0], it[1]);
        long[] lArray2 = lArray;
        geoHash2(lArray2, this.getRightAlignedLongitudeBits());
        return geoHash3;
    }

    @NotNull
    public final GeoHash getEasternNeighbour() {
        GeoHash geoHash;
        long[] lArray = this.getRightAlignedLongitudeBits();
        long[] lArray2 = this.getRightAlignedLatitudeBits();
        GeoHash geoHash2 = geoHash;
        GeoHash geoHash3 = geoHash;
        long[] it = lArray;
        it[0] = it[0] + 1L;
        it[0] = this.maskLastNBits(it[0], it[1]);
        long[] lArray3 = lArray;
        geoHash2(lArray2, lArray3);
        return geoHash3;
    }

    @NotNull
    public final GeoHash getWesternNeighbour() {
        GeoHash geoHash;
        long[] lArray = this.getRightAlignedLongitudeBits();
        long[] lArray2 = this.getRightAlignedLatitudeBits();
        GeoHash geoHash2 = geoHash;
        GeoHash geoHash3 = geoHash;
        long[] it = lArray;
        it[0] = it[0] + -1L;
        it[0] = this.maskLastNBits(it[0], it[1]);
        long[] lArray3 = lArray;
        geoHash2(lArray2, lArray3);
        return geoHash3;
    }

    @NotNull
    public final GeoHash[] getAdjacent() {
        return new GeoHash[]{this.getNorthernNeighbour(), this.getNorthernNeighbour().getEasternNeighbour(), this.getEasternNeighbour(), this.getSouthernNeighbour().getEasternNeighbour(), this.getSouthernNeighbour(), this.getSouthernNeighbour().getWesternNeighbour(), this.getWesternNeighbour(), this.getNorthernNeighbour().getWesternNeighbour()};
    }

    @NotNull
    public final GeoHash[] getAdjacentBox() {
        return new GeoHash[]{this.getNorthernNeighbour().getWesternNeighbour(), this.getNorthernNeighbour(), this.getNorthernNeighbour().getEasternNeighbour(), this.getWesternNeighbour(), this, this.getEasternNeighbour(), this.getSouthernNeighbour().getWesternNeighbour(), this.getSouthernNeighbour(), this.getSouthernNeighbour().getEasternNeighbour()};
    }

    private final long getOrd() {
        return this.bits >>> MAX_BIT_PRECISION - this.significantBits;
    }

    private final int[] getNumberOfLatLonBits() {
        return new int[]{this.significantBits / 2, this.significantBits / 2 + (this.significantBits % 2 == 0 ? 0 : 1)};
    }

    private final long[] getRightAlignedLatitudeBits() {
        long bitsCopy = this.bits << 1;
        return new long[]{this.extractEverySecondBit(bitsCopy, this.getNumberOfLatLonBits()[0]), this.getNumberOfLatLonBits()[0]};
    }

    private final long[] getRightAlignedLongitudeBits() {
        long bitsCopy = this.bits;
        return new long[]{this.extractEverySecondBit(bitsCopy, this.getNumberOfLatLonBits()[1]), this.getNumberOfLatLonBits()[1]};
    }

    @NotNull
    public final GeoHash next(int step) {
        return new GeoHash(this.getOrd() + (long)step << MAX_BIT_PRECISION - this.significantBits, this.significantBits);
    }

    @NotNull
    public final GeoHash inc() {
        return this.next(1);
    }

    @NotNull
    public final GeoHash dec() {
        return this.next(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GeoHash[] childs() {
        this.checkConvert();
        if (this.significantBits / 5 < 12) {
            void var2_2;
            int size$iv = base32.length();
            GeoHash[] result$iv = new GeoHash[size$iv];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void i;
                GeoHash geoHash;
                void i$iv;
                void var5_5 = i$iv;
                void var9_7 = i$iv++;
                GeoHash[] geoHashArray = result$iv;
                geoHashArray[var9_7] = geoHash = new GeoHash(this.toString() + base32.charAt((int)i));
            }
            return var2_2;
        }
        return null;
    }

    @Nullable
    public final GeoHash parent() {
        if (this.significantBits > 5) {
            GeoHash geoHash;
            String hash;
            String string = hash = this.toString();
            int n = 0;
            int n2 = hash.length() - 1;
            GeoHash geoHash2 = geoHash;
            GeoHash geoHash3 = geoHash;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            geoHash2(string4);
            return geoHash3;
        }
        return null;
    }

    @NotNull
    public final Location toLocation() {
        return this.boundingBox.getCenter();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        this.checkConvert();
        StringBuilder buf = new StringBuilder();
        long firstBitFlag = -576460752303423488L;
        long bitsCopy = this.bits;
        int partialChunks = (int)Math.ceil(this.significantBits / 5);
        int n = 0;
        int n2 = partialChunks;
        while (n < n2) {
            void i;
            buf.append(base32.charAt((int)((bitsCopy & firstBitFlag) >>> 59)));
            bitsCopy <<= 5;
            ++i;
        }
        String string = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
        return string;
    }

    private final int precisionFromCharCount(int charsCount) {
        if (charsCount > 12) {
            throw (Throwable)new IllegalArgumentException("A geohash can only be 12 character long.");
        }
        return charsCount * 5 <= 60 ? charsCount * 5 : 60;
    }

    private final void checkConvert() {
        if (this.significantBits % 5 != 0) {
            throw (Throwable)new IllegalStateException("Cannot convert a geoHash to base32");
        }
    }

    private final void divideRangeEncode(double value, double[] range) {
        double mid = (range[0] + range[1]) / (double)2;
        if (value >= mid) {
            this.addOnBitToEnd();
            range[0] = mid;
        } else {
            this.addOffBitToEnd();
            range[1] = mid;
        }
    }

    private final void addOnBitToEnd() {
        byte by = this.significantBits;
        this.significantBits = (byte)(by + 1);
        this.bits <<= 1;
        this.bits |= 1L;
    }

    private final void addOffBitToEnd() {
        byte by = this.significantBits;
        this.significantBits = (byte)(by + 1);
        this.bits <<= 1;
    }

    private final Location generateLocation(double lat, double lon) {
        Location location;
        Location it = location = new Location("javaClass");
        it.setLatitude(lat);
        it.setLongitude(lon);
        return location;
    }

    private final void divideRangeDecode(double[] range, boolean b) {
        double mid = (range[0] + range[1]) / (double)2;
        if (b) {
            this.addOnBitToEnd();
            range[0] = mid;
        } else {
            this.addOffBitToEnd();
            range[1] = mid;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long extractEverySecondBit(long copyOfBits, int numberOfBits) {
        long bitsCopy = copyOfBits;
        long value = 0L;
        int n = 0;
        int n2 = numberOfBits;
        while (n < n2) {
            void i;
            if ((bitsCopy & Long.MIN_VALUE) == Long.MIN_VALUE) {
                value |= 1L;
            }
            value <<= 1;
            bitsCopy <<= 2;
            ++i;
        }
        return value >>>= 1;
    }

    private final long maskLastNBits(long value, long n) {
        long mask = -1L;
        return value & (mask >>>= (int)((long)MAX_BIT_PRECISION - n));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fonfon.kgeohash.GeoHash");
        }
        GeoHash cfr_ignored_0 = (GeoHash)object2;
        if (this.bits != ((GeoHash)other).bits) {
            return false;
        }
        if (this.significantBits != ((GeoHash)other).significantBits) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.boundingBox, (Object)((GeoHash)other).boundingBox) ^ true);
    }

    public int hashCode() {
        int result = ((Object)this.bits).hashCode();
        result = 31 * result + this.significantBits;
        result = 31 * result + this.boundingBox.hashCode();
        return result;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeLong(this.bits);
        parcel.writeByte(this.significantBits);
        parcel.writeParcelable((Parcelable)this.boundingBox, flags);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public GeoHash(@NotNull Parcel parcel) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        HashMap hashMap = new HashMap();
        GeoHash geoHash = this;
        HashMap it = hashMap;
        Object object = base32;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int index$iv = 0;
        for (void item$iv : $receiver$iv) {
            void c;
            int n = index$iv++;
            void var9_10 = item$iv;
            int index = n;
            Map map = it;
            Character c2 = Character.valueOf((char)c);
            Integer n2 = index;
            map.put(c2, n2);
        }
        HashMap hashMap2 = hashMap;
        geoHash.decodeMap = hashMap2;
        this.bits = parcel.readLong();
        this.significantBits = parcel.readByte();
        Parcelable parcelable = parcel.readParcelable(BoundingBox.class.getClassLoader());
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"parcel.readParcelable(Bo\u2026::class.java.classLoader)");
        this.boundingBox = (BoundingBox)parcelable;
    }

    @JvmOverloads
    public GeoHash(@NotNull Location location, int charsCount) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this(location.getLatitude(), location.getLongitude(), charsCount);
    }

    @JvmOverloads
    public /* synthetic */ GeoHash(Location location, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        this(location, n);
    }

    @JvmOverloads
    public GeoHash(@NotNull Location location) {
        this(location, 0, 2, null);
    }

    @JvmOverloads
    public GeoHash(@NotNull BoundingBox boundingBox, int charsCount) {
        Intrinsics.checkParameterIsNotNull((Object)boundingBox, (String)"boundingBox");
        this(boundingBox.getCenter().getLatitude(), boundingBox.getCenter().getLongitude(), charsCount);
    }

    @JvmOverloads
    public /* synthetic */ GeoHash(BoundingBox boundingBox, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        this(boundingBox, n);
    }

    @JvmOverloads
    public GeoHash(@NotNull BoundingBox boundingBox) {
        this(boundingBox, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public GeoHash(@NotNull String hash) {
        int n;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        HashMap hashMap = new HashMap();
        GeoHash geoHash = this;
        HashMap it = hashMap;
        Object object = base32;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int index$iv = 0;
        for (int item$iv : $receiver$iv) {
            void c;
            int n2 = index$iv++;
            n = item$iv;
            int index = n2;
            Map map = it;
            Character c2 = Character.valueOf((char)c);
            Integer n3 = index;
            map.put(c2, n3);
        }
        HashMap hashMap2 = hashMap;
        geoHash.decodeMap = hashMap2;
        boolean isEvenBit = true;
        double[] latRange = new double[]{-90.0, 90.0};
        double[] lonRange = new double[]{-180.0, 180.0};
        index$iv = 0;
        int n4 = hash.length();
        while (index$iv < n4) {
            void i;
            int item$iv;
            Integer cd = this.decodeMap.get(Character.valueOf(hash.charAt((int)i)));
            item$iv = 0;
            n = 5;
            while (item$iv < n) {
                void j;
                int mask = BITS[j];
                if (isEvenBit) {
                    Integer n5 = cd;
                    if (n5 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.divideRangeDecode(lonRange, (n5 & mask) != 0);
                } else {
                    Integer n6 = cd;
                    if (n6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.divideRangeDecode(latRange, (n6 & mask) != 0);
                }
                isEvenBit = !isEvenBit;
                ++j;
            }
            ++i;
        }
        this.boundingBox = new BoundingBox(this.generateLocation(latRange[0], lonRange[0]), this.generateLocation(latRange[1], lonRange[1]));
        this.bits <<= MAX_BIT_PRECISION - this.significantBits;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public GeoHash(double lat, double lon, int charsCount) {
        void $receiver$iv;
        HashMap hashMap = new HashMap();
        GeoHash geoHash = this;
        HashMap it = hashMap;
        Object object = base32;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int index$iv = 0;
        for (void item$iv : $receiver$iv) {
            void c;
            int n = index$iv++;
            void var13_17 = item$iv;
            int index = n;
            Map map = it;
            Character c2 = Character.valueOf((char)c);
            Integer n2 = index;
            map.put(c2, n2);
        }
        HashMap hashMap2 = hashMap;
        geoHash.decodeMap = hashMap2;
        int desiredPrecision = this.precisionFromCharCount(charsCount);
        int precision = Math.min(desiredPrecision, MAX_BIT_PRECISION);
        boolean isEvenBit = true;
        double[] latRange = new double[]{-90.0, 90.0};
        double[] lonRange = new double[]{-180.0, 180.0};
        while (this.significantBits < precision) {
            if (isEvenBit) {
                this.divideRangeEncode(lon, lonRange);
            } else {
                this.divideRangeEncode(lat, latRange);
            }
            isEvenBit = !isEvenBit;
        }
        this.boundingBox = new BoundingBox(this.generateLocation(latRange[0], lonRange[0]), this.generateLocation(latRange[1], lonRange[1]));
        this.bits <<= MAX_BIT_PRECISION - precision;
    }

    @JvmOverloads
    public /* synthetic */ GeoHash(double d, double d2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        this(d, d2, n);
    }

    @JvmOverloads
    public GeoHash(double lat, double lon) {
        this(lat, lon, 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public GeoHash(long hashVal, byte significantBits) {
        void $receiver$iv;
        HashMap hashMap = new HashMap();
        GeoHash geoHash = this;
        HashMap it = hashMap;
        Object object = base32;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int index$iv = 0;
        for (void item$iv : $receiver$iv) {
            void c;
            int n = index$iv++;
            void var11_13 = item$iv;
            int index = n;
            Map map = it;
            Character c2 = Character.valueOf((char)c);
            Integer n2 = index;
            map.put(c2, n2);
        }
        HashMap hashMap2 = hashMap;
        geoHash.decodeMap = hashMap2;
        boolean isEvenBit = true;
        double[] latRange = new double[]{-90.0, 90.0};
        double[] lonRange = new double[]{-180.0, 180.0};
        String binStr = Long.toBinaryString(hashVal);
        while (binStr.length() < MAX_BIT_PRECISION) {
            binStr = '0' + binStr;
        }
        int n = 0;
        int n3 = significantBits;
        while (n < n3) {
            void i;
            if (isEvenBit) {
                this.divideRangeDecode(lonRange, binStr.charAt((int)i) != '0');
            } else {
                this.divideRangeDecode(latRange, binStr.charAt((int)i) != '0');
            }
            isEvenBit = !isEvenBit;
            ++i;
        }
        this.boundingBox = new BoundingBox(this.generateLocation(latRange[0], lonRange[0]), this.generateLocation(latRange[1], lonRange[1]));
        this.bits <<= MAX_BIT_PRECISION - this.significantBits;
    }

    /*
     * WARNING - void declaration
     */
    private GeoHash(long[] latBits, long[] lonBits) {
        void $receiver$iv;
        HashMap hashMap = new HashMap();
        GeoHash geoHash = this;
        HashMap it = hashMap;
        Object object = base32;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int index$iv22 = 0;
        for (void item$iv : $receiver$iv) {
            void c;
            int n = index$iv22++;
            void var10_14 = item$iv;
            int index = n;
            Map map = it;
            Character c2 = Character.valueOf((char)c);
            Integer n2 = index;
            map.put(c2, n2);
        }
        HashMap hashMap2 = hashMap;
        geoHash.decodeMap = hashMap2;
        latBits[0] = latBits[0] << (int)((long)MAX_BIT_PRECISION - latBits[1]);
        lonBits[0] = lonBits[0] << (int)((long)MAX_BIT_PRECISION - lonBits[1]);
        boolean isEvenBit = false;
        double[] latRange = new double[]{-90.0, 90.0};
        double[] lonRange = new double[]{-180.0, 180.0};
        long index$iv22 = 0L;
        long l = latBits[1] + lonBits[1];
        while (index$iv22 < l) {
            void i;
            if (isEvenBit) {
                this.divideRangeDecode(latRange, (latBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                latBits[0] = latBits[0] << 1;
            } else {
                this.divideRangeDecode(lonRange, (lonBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                lonBits[0] = lonBits[0] << 1;
            }
            isEvenBit = !isEvenBit;
            ++i;
        }
        this.bits <<= MAX_BIT_PRECISION - this.significantBits;
        this.boundingBox = new BoundingBox(this.generateLocation(latRange[0], lonRange[0]), this.generateLocation(latRange[1], lonRange[1]));
    }

    static {
        CREATOR = new CREATOR(null);
        MAX_BIT_PRECISION = Long.bitCount(Long.MAX_VALUE) + 1;
        BITS = new int[]{16, 8, 4, 2, 1};
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001d\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/fonfon/kgeohash/GeoHash$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/fonfon/kgeohash/GeoHash;", "()V", "BASE32_BITS", "", "BITS", "", "getBITS", "()[I", "FIRST_BIT_FLAGGED", "", "LATITUDE_MAX_ABS", "", "LONGITUDE_MAX_ABS", "MAX_BIT_PRECISION", "getMAX_BIT_PRECISION", "()I", "MAX_CHARACTER_PRECISION", "MAX_GEO_HASH_BITS_COUNT", "base32", "", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "(I)[Lcom/fonfon/kgeohash/GeoHash;", "library_release"})
    public static final class CREATOR
    implements Parcelable.Creator<GeoHash> {
        public final int getMAX_BIT_PRECISION() {
            return MAX_BIT_PRECISION;
        }

        @NotNull
        public final int[] getBITS() {
            return BITS;
        }

        @NotNull
        public GeoHash createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            return new GeoHash(parcel);
        }

        @NotNull
        public GeoHash[] newArray(int size) {
            return new GeoHash[size];
        }

        private CREATOR() {
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

