/*
 * Decompiled with CFR 0.152.
 */
package com.fonfon.geohash;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.fonfon.geohash.LocationExt;

public class BoundingBox
implements Parcelable {
    private double minLatitude;
    private double maxLatitude;
    private double minLongitude;
    private double maxLongitude;
    public static final Parcelable.Creator<BoundingBox> CREATOR = new Parcelable.Creator<BoundingBox>(){

        public BoundingBox createFromParcel(Parcel in) {
            return new BoundingBox(in);
        }

        public BoundingBox[] newArray(int size) {
            return new BoundingBox[size];
        }
    };

    public BoundingBox(Location p1, Location p2) {
        this(p1.getLatitude(), p2.getLatitude(), p1.getLongitude(), p2.getLongitude());
    }

    private BoundingBox(double y1, double y2, double x1, double x2) {
        this.minLongitude = Math.min(x1, x2);
        this.maxLongitude = Math.max(x1, x2);
        this.minLatitude = Math.min(y1, y2);
        this.maxLatitude = Math.max(y1, y2);
    }

    protected BoundingBox(Parcel in) {
        this.minLatitude = in.readDouble();
        this.maxLatitude = in.readDouble();
        this.minLongitude = in.readDouble();
        this.maxLongitude = in.readDouble();
    }

    public Location getTopLeft() {
        return LocationExt.newLocation(this.maxLatitude, this.minLongitude);
    }

    public Location getTopRight() {
        return LocationExt.newLocation(this.maxLatitude, this.maxLongitude);
    }

    public Location getBottomLeft() {
        return LocationExt.newLocation(this.minLatitude, this.minLongitude);
    }

    public Location getBottomRight() {
        return LocationExt.newLocation(this.minLatitude, this.maxLongitude);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox that = (BoundingBox)obj;
            return this.minLatitude == that.minLatitude && this.minLongitude == that.minLongitude && this.maxLatitude == that.maxLatitude && this.maxLongitude == that.maxLongitude;
        }
        return false;
    }

    public boolean contains(Location point) {
        return point.getLatitude() >= this.minLatitude && point.getLongitude() >= this.minLongitude && point.getLatitude() <= this.maxLatitude && point.getLongitude() <= this.maxLongitude;
    }

    public boolean intersects(BoundingBox other) {
        return !(other.minLongitude > this.maxLongitude || other.maxLongitude < this.minLongitude || other.minLatitude > this.maxLatitude || other.maxLatitude < this.minLatitude);
    }

    public String toString() {
        return this.getTopLeft().toString() + " -> " + this.getBottomRight().toString();
    }

    public Location getCenterPoint() {
        return LocationExt.newLocation((this.minLatitude + this.maxLatitude) / 2.0, (this.minLongitude + this.maxLongitude) / 2.0);
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.minLatitude);
        dest.writeDouble(this.maxLatitude);
        dest.writeDouble(this.minLongitude);
        dest.writeDouble(this.maxLongitude);
    }
}

