/*
 * Decompiled with CFR 0.152.
 */
package com.fonfon.geohash;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.fonfon.geohash.BoundingBox;
import com.fonfon.geohash.LocationExt;
import java.util.HashMap;
import java.util.Map;

public final class GeoHash
implements Parcelable {
    public static final int MAX_CHARACTER_PRECISION = 12;
    private static final long FIRST_BIT_FLAGGED = Long.MIN_VALUE;
    private static final double LATITUDE_MAX_ABS = 90.0;
    private static final double LONGITUDE_MAX_ABS = 180.0;
    private static final int MAX_BIT_PRECISION = Long.bitCount(Long.MAX_VALUE) + 1;
    private static final int BASE32_BITS = 5;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};
    private static final String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static final int MAX_GEO_HASH_BITS_COUNT = 60;
    private static final Map<Character, Integer> decodeMap = new HashMap<Character, Integer>();
    private long bits = 0L;
    private byte significantBits = 0;
    private BoundingBox boundingBox;
    public static final Parcelable.Creator<GeoHash> CREATOR;

    private GeoHash() {
    }

    protected GeoHash(Parcel in) {
        this.bits = in.readLong();
        this.significantBits = in.readByte();
        this.boundingBox = (BoundingBox)in.readParcelable(BoundingBox.class.getClassLoader());
    }

    public static GeoHash fromLocation(Location location, int numberOfCharacters) {
        if (numberOfCharacters > 12) {
            throw new IllegalArgumentException("A geohash can only be 12 character long.");
        }
        int desiredPrecision = numberOfCharacters * 5 <= 60 ? numberOfCharacters * 5 : 60;
        return new GeoHash(location.getLatitude(), location.getLongitude(), desiredPrecision);
    }

    public static GeoHash fromString(String geohash) {
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        boolean isEvenBit = true;
        GeoHash hash = new GeoHash();
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = decodeMap.get(Character.valueOf(geohash.charAt(i)));
            for (int j = 0; j < 5; ++j) {
                int mask = BITS[j];
                if (isEvenBit) {
                    GeoHash.divideRangeDecode(hash, longitudeRange, (cd & mask) != 0);
                } else {
                    GeoHash.divideRangeDecode(hash, latitudeRange, (cd & mask) != 0);
                }
                isEvenBit = !isEvenBit;
            }
        }
        GeoHash.setBoundingBox(hash, latitudeRange, longitudeRange);
        hash.bits <<= MAX_BIT_PRECISION - hash.significantBits;
        return hash;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Location getCenter() {
        return this.boundingBox.getCenterPoint();
    }

    public GeoHash next(int step) {
        return GeoHash.fromOrd(this.ord() + (long)step, this.significantBits);
    }

    public GeoHash next() {
        return this.next(1);
    }

    public GeoHash prev() {
        return this.next(-1);
    }

    public GeoHash[] getAdjacent() {
        GeoHash northern = this.getNorthernNeighbour();
        GeoHash eastern = this.getEasternNeighbour();
        GeoHash southern = this.getSouthernNeighbour();
        GeoHash western = this.getWesternNeighbour();
        return new GeoHash[]{northern, northern.getEasternNeighbour(), eastern, southern.getEasternNeighbour(), southern, southern.getWesternNeighbour(), western, northern.getWesternNeighbour()};
    }

    public GeoHash getNorthernNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        latitudeBits[0] = latitudeBits[0] + 1L;
        latitudeBits[0] = this.maskLastNBits(latitudeBits[0], latitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getSouthernNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        latitudeBits[0] = latitudeBits[0] - 1L;
        latitudeBits[0] = this.maskLastNBits(latitudeBits[0], latitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getEasternNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        longitudeBits[0] = longitudeBits[0] + 1L;
        longitudeBits[0] = this.maskLastNBits(longitudeBits[0], longitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getWesternNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        longitudeBits[0] = longitudeBits[0] - 1L;
        longitudeBits[0] = this.maskLastNBits(longitudeBits[0], longitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public String toString() {
        if (this.significantBits % 5 != 0) {
            throw new IllegalStateException("Cannot convert a geoHash to base32");
        }
        StringBuilder buf = new StringBuilder();
        long firstFiveBitsMask = -576460752303423488L;
        long bitsCopy = this.bits;
        int partialChunks = (int)Math.ceil((double)this.significantBits / 5.0);
        for (int i = 0; i < partialChunks; ++i) {
            int pointer = (int)((bitsCopy & firstFiveBitsMask) >>> 59);
            buf.append(base32.charAt(pointer));
            bitsCopy <<= 5;
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeoHash) {
            GeoHash other = (GeoHash)obj;
            return other.significantBits == this.significantBits && other.bits == this.bits;
        }
        return false;
    }

    private static GeoHash fromLongValue(long hashVal, int significantBits) {
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        boolean isEvenBit = true;
        GeoHash hash = new GeoHash();
        String binaryString = Long.toBinaryString(hashVal);
        while (binaryString.length() < MAX_BIT_PRECISION) {
            binaryString = "0" + binaryString;
        }
        for (int j = 0; j < significantBits; ++j) {
            if (isEvenBit) {
                GeoHash.divideRangeDecode(hash, longitudeRange, binaryString.charAt(j) != '0');
            } else {
                GeoHash.divideRangeDecode(hash, latitudeRange, binaryString.charAt(j) != '0');
            }
            isEvenBit = !isEvenBit;
        }
        GeoHash.setBoundingBox(hash, latitudeRange, longitudeRange);
        hash.bits <<= MAX_BIT_PRECISION - hash.significantBits;
        return hash;
    }

    private static GeoHash fromOrd(long ord, int significantBits) {
        return GeoHash.fromLongValue(ord << MAX_BIT_PRECISION - significantBits, significantBits);
    }

    private static void setBoundingBox(GeoHash hash, double[] latitudeRange, double[] longitudeRange) {
        hash.boundingBox = new BoundingBox(LocationExt.newLocation(latitudeRange[0], longitudeRange[0]), LocationExt.newLocation(latitudeRange[1], longitudeRange[1]));
    }

    private static void divideRangeDecode(GeoHash hash, double[] range, boolean b) {
        double mid = (range[0] + range[1]) / 2.0;
        if (b) {
            hash.addOnBitToEnd();
            range[0] = mid;
        } else {
            hash.addOffBitToEnd();
            range[1] = mid;
        }
    }

    private GeoHash(double latitude, double longitude, int desiredPrecision) {
        desiredPrecision = Math.min(desiredPrecision, MAX_BIT_PRECISION);
        boolean isEvenBit = true;
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        while (this.significantBits < desiredPrecision) {
            if (isEvenBit) {
                this.divideRangeEncode(longitude, longitudeRange);
            } else {
                this.divideRangeEncode(latitude, latitudeRange);
            }
            isEvenBit = !isEvenBit;
        }
        GeoHash.setBoundingBox(this, latitudeRange, longitudeRange);
        this.bits <<= MAX_BIT_PRECISION - desiredPrecision;
    }

    private void divideRangeEncode(double value, double[] range) {
        double mid = (range[0] + range[1]) / 2.0;
        if (value >= mid) {
            this.addOnBitToEnd();
            range[0] = mid;
        } else {
            this.addOffBitToEnd();
            range[1] = mid;
        }
    }

    private void addOnBitToEnd() {
        this.significantBits = (byte)(this.significantBits + 1);
        this.bits <<= 1;
        this.bits |= 1L;
    }

    private void addOffBitToEnd() {
        this.significantBits = (byte)(this.significantBits + 1);
        this.bits <<= 1;
    }

    private long ord() {
        int insignificantBits = MAX_BIT_PRECISION - this.significantBits;
        return this.bits >>> insignificantBits;
    }

    private long[] getRightAlignedLatitudeBits() {
        long copyOfBits = this.bits << 1;
        long value = this.extractEverySecondBit(copyOfBits, this.getNumberOfLatLonBits()[0]);
        return new long[]{value, this.getNumberOfLatLonBits()[0]};
    }

    private long[] getRightAlignedLongitudeBits() {
        long copyOfBits = this.bits;
        long value = this.extractEverySecondBit(copyOfBits, this.getNumberOfLatLonBits()[1]);
        return new long[]{value, this.getNumberOfLatLonBits()[1]};
    }

    private long extractEverySecondBit(long copyOfBits, int numberOfBits) {
        long value = 0L;
        for (int i = 0; i < numberOfBits; ++i) {
            if ((copyOfBits & Long.MIN_VALUE) == Long.MIN_VALUE) {
                value |= 1L;
            }
            value <<= 1;
            copyOfBits <<= 2;
        }
        return value >>>= 1;
    }

    private int[] getNumberOfLatLonBits() {
        if (this.significantBits % 2 == 0) {
            return new int[]{this.significantBits / 2, this.significantBits / 2};
        }
        return new int[]{this.significantBits / 2, this.significantBits / 2 + 1};
    }

    private long maskLastNBits(long value, long n) {
        long mask = -1L;
        return value & (mask >>>= (int)((long)MAX_BIT_PRECISION - n));
    }

    private GeoHash recombineLatLonBitsToHash(long[] latBits, long[] lonBits) {
        GeoHash hash = new GeoHash();
        boolean isEvenBit = false;
        latBits[0] = latBits[0] << (int)((long)MAX_BIT_PRECISION - latBits[1]);
        lonBits[0] = lonBits[0] << (int)((long)MAX_BIT_PRECISION - lonBits[1]);
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        int i = 0;
        while ((long)i < latBits[1] + lonBits[1]) {
            if (isEvenBit) {
                GeoHash.divideRangeDecode(hash, latitudeRange, (latBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                latBits[0] = latBits[0] << 1;
            } else {
                GeoHash.divideRangeDecode(hash, longitudeRange, (lonBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                lonBits[0] = lonBits[0] << 1;
            }
            isEvenBit = !isEvenBit;
            ++i;
        }
        hash.bits <<= MAX_BIT_PRECISION - hash.significantBits;
        GeoHash.setBoundingBox(hash, latitudeRange, longitudeRange);
        return hash;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.bits);
        dest.writeByte(this.significantBits);
        dest.writeParcelable((Parcelable)this.boundingBox, flags);
    }

    static {
        for (int i = 0; i < base32.length(); ++i) {
            decodeMap.put(Character.valueOf(base32.charAt(i)), i);
        }
        CREATOR = new Parcelable.Creator<GeoHash>(){

            public GeoHash createFromParcel(Parcel in) {
                return new GeoHash(in);
            }

            public GeoHash[] newArray(int size) {
                return new GeoHash[size];
            }
        };
    }
}

