/*
 * Decompiled with CFR 0.152.
 */
package com.tsongkha.spinnerdatepicker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.tsongkha.spinnerdatepicker.DatePicker;
import com.tsongkha.spinnerdatepicker.OnDateChangedListener;
import com.tsongkha.spinnerdatepicker.R;
import java.text.DateFormat;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mCallBack;
    private final DateFormat mTitleDateFormat;

    DatePickerDialog(Context context, int theme, int spinnerTheme, OnDateSetListener callBack, Calendar defaultDate, Calendar minDate, Calendar maxDate) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mTitleDateFormat = DateFormat.getDateInstance(1);
        this.updateTitle(defaultDate);
        this.setButton(-1, context.getText(17039370), this);
        this.setButton(-2, context.getText(0x1040000), null);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_picker_dialog_container, null);
        this.setView(view);
        this.mDatePicker = new DatePicker((ViewGroup)view, spinnerTheme);
        this.mDatePicker.setMinDate(minDate.getTimeInMillis());
        this.mDatePicker.setMaxDate(maxDate.getTimeInMillis());
        this.mDatePicker.init(defaultDate.get(1), defaultDate.get(2), defaultDate.get(5), this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
        }
    }

    @Override
    public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        Calendar updatedDate = Calendar.getInstance();
        updatedDate.set(1, year);
        updatedDate.set(2, monthOfYear);
        updatedDate.set(5, dayOfMonth);
        this.updateTitle(updatedDate);
    }

    private void updateTitle(Calendar updatedDate) {
        DateFormat dateFormat = this.mTitleDateFormat;
        this.setTitle(dateFormat.format(updatedDate.getTime()));
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, day);
        this.updateTitle(c);
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

