/*
 * Decompiled with CFR 0.152.
 */
package com.tsongkha.spinnerdatepicker;

import android.animation.LayoutTransition;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.tsongkha.spinnerdatepicker.ICU;
import com.tsongkha.spinnerdatepicker.R;
import com.tsongkha.spinnerdatepicker.TwoDigitFormatter;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class DatePicker
extends FrameLayout {
    public static int NO_YEAR = 0;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final TwoDigitFormatter sTwoDigitFormatter = new TwoDigitFormatter();
    private final LinearLayout mPickerContainer;
    private final NumberPicker mDayPicker;
    private final NumberPicker mMonthPicker;
    private final NumberPicker mYearPicker;
    private OnDateChangedListener mOnDateChangedListener;
    private int mDay;
    private int mMonth;
    private int mYear;
    private boolean mYearOptional;
    private boolean mHasYear;

    public DatePicker(Context context, ViewGroup root, int numberPickerStyle) {
        super(context, null, 0);
        LayoutInflater inflater = (LayoutInflater)new ContextThemeWrapper(context, numberPickerStyle).getSystemService("layout_inflater");
        inflater.inflate(R.layout.date_picker_container, (ViewGroup)this, true);
        this.mPickerContainer = (LinearLayout)this.findViewById(R.id.parent);
        this.mDayPicker = (NumberPicker)inflater.inflate(R.layout.number_picker_day_month, (ViewGroup)this.mPickerContainer, true).findViewById(R.id.number_picker);
        this.mDayPicker.setId(R.id.day);
        this.mDayPicker.setFormatter((NumberPicker.Formatter)sTwoDigitFormatter);
        this.mDayPicker.setOnLongPressUpdateInterval(100L);
        this.mDayPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mDay = newVal;
                DatePicker.this.notifyDateChanged();
            }
        });
        this.mMonthPicker = (NumberPicker)inflater.inflate(R.layout.number_picker_day_month, (ViewGroup)this.mPickerContainer).findViewById(R.id.number_picker);
        this.mMonthPicker.setId(R.id.month);
        this.mMonthPicker.setFormatter((NumberPicker.Formatter)sTwoDigitFormatter);
        DateFormatSymbols dfs = new DateFormatSymbols();
        String[] months = dfs.getShortMonths();
        if (months[0].startsWith("1")) {
            for (int i = 0; i < months.length; ++i) {
                months[i] = String.valueOf(i + 1);
            }
            this.mMonthPicker.setMinValue(1);
            this.mMonthPicker.setMaxValue(12);
        } else {
            this.mMonthPicker.setMinValue(1);
            this.mMonthPicker.setMaxValue(12);
            this.mMonthPicker.setDisplayedValues(months);
        }
        this.mMonthPicker.setOnLongPressUpdateInterval(200L);
        this.mMonthPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mMonth = newVal - 1;
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        });
        this.mYearPicker = (NumberPicker)inflater.inflate(R.layout.number_picker_year, (ViewGroup)this.mPickerContainer).findViewById(R.id.number_picker);
        this.mYearPicker.setId(R.id.year);
        this.mYearPicker.setOnLongPressUpdateInterval(100L);
        this.mYearPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mYear = newVal;
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        });
        this.mYearPicker.setMinValue(1900);
        this.mYearPicker.setMaxValue(2100);
        Calendar cal = Calendar.getInstance();
        this.init(cal.get(1), cal.get(2), cal.get(5), null);
        this.reorderPickers();
        this.mPickerContainer.setLayoutTransition(new LayoutTransition());
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        root.addView((View)this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mDayPicker.setEnabled(enabled);
        this.mMonthPicker.setEnabled(enabled);
        this.mYearPicker.setEnabled(enabled);
    }

    private void reorderPickers() {
        String skeleton = this.mHasYear ? "yyyyMMMdd" : "MMMdd";
        String pattern = DateFormat.getBestDateTimePattern((Locale)Locale.getDefault(), (String)skeleton);
        char[] order = ICU.getDateFormatOrder(pattern);
        this.mPickerContainer.removeAllViews();
        for (char field : order) {
            if (field == 'd') {
                this.mPickerContainer.addView((View)this.mDayPicker);
                continue;
            }
            if (field == 'M') {
                this.mPickerContainer.addView((View)this.mMonthPicker);
                continue;
            }
            this.mPickerContainer.addView((View)this.mYearPicker);
        }
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        if (this.mYear != year || this.mMonth != monthOfYear || this.mDay != dayOfMonth) {
            this.mYear = this.mYearOptional && year == NO_YEAR ? this.getCurrentYear() : year;
            this.mMonth = monthOfYear;
            this.mDay = dayOfMonth;
            this.updateSpinners();
            this.reorderPickers();
            this.notifyDateChanged();
        }
    }

    private int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mYear, this.mMonth, this.mDay, this.mHasYear, this.mYearOptional);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mYear = ss.getYear();
        this.mMonth = ss.getMonth();
        this.mDay = ss.getDay();
        this.mHasYear = ss.hasYear();
        this.mYearOptional = ss.isYearOptional();
        this.updateSpinners();
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.init(year, monthOfYear, dayOfMonth, false, onDateChangedListener);
    }

    public void init(int year, int monthOfYear, int dayOfMonth, boolean yearOptional, OnDateChangedListener onDateChangedListener) {
        this.mYear = yearOptional && year == NO_YEAR ? this.getCurrentYear() : year;
        this.mMonth = monthOfYear;
        this.mDay = dayOfMonth;
        this.mYearOptional = yearOptional;
        this.mHasYear = yearOptional ? year != NO_YEAR : true;
        this.mOnDateChangedListener = onDateChangedListener;
        this.updateSpinners();
    }

    private void updateSpinners() {
        this.updateDaySpinner();
        this.mYearPicker.setValue(this.mYear);
        this.mYearPicker.setVisibility(this.mHasYear ? 0 : 8);
        this.mMonthPicker.setValue(this.mMonth + 1);
    }

    private void updateDaySpinner() {
        Calendar cal = Calendar.getInstance();
        cal.set(this.mHasYear ? this.mYear : 2000, this.mMonth, 1);
        int max = cal.getActualMaximum(5);
        this.mDayPicker.setMinValue(1);
        this.mDayPicker.setMaxValue(max);
        this.mDayPicker.setValue(this.mDay);
    }

    public int getYear() {
        return this.mYearOptional && !this.mHasYear ? NO_YEAR : this.mYear;
    }

    public boolean isYearOptional() {
        return this.mYearOptional;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfMonth() {
        return this.mDay;
    }

    private void adjustMaxDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.mHasYear ? this.mYear : 2000);
        cal.set(2, this.mMonth);
        int max = cal.getActualMaximum(5);
        if (this.mDay > max) {
            this.mDay = max;
        }
    }

    private void notifyDateChanged() {
        if (this.mOnDateChangedListener != null) {
            int year = this.mYearOptional && !this.mHasYear ? NO_YEAR : this.mYear;
            this.mOnDateChangedListener.onDateChanged(this, year, this.mMonth, this.mDay);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mYear;
        private final int mMonth;
        private final int mDay;
        private final boolean mHasYear;
        private final boolean mYearOptional;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int year, int month, int day, boolean hasYear, boolean yearOptional) {
            super(superState);
            this.mYear = year;
            this.mMonth = month;
            this.mDay = day;
            this.mHasYear = hasYear;
            this.mYearOptional = yearOptional;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mYear = in.readInt();
            this.mMonth = in.readInt();
            this.mDay = in.readInt();
            this.mHasYear = in.readInt() != 0;
            this.mYearOptional = in.readInt() != 0;
        }

        public int getYear() {
            return this.mYear;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getDay() {
            return this.mDay;
        }

        public boolean hasYear() {
            return this.mHasYear;
        }

        public boolean isYearOptional() {
            return this.mYearOptional;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYear);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mDay);
            dest.writeInt(this.mHasYear ? 1 : 0);
            dest.writeInt(this.mYearOptional ? 1 : 0);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }
}

