/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.protobuf.propertydescriptor;

import com.github.dozermapper.core.BeanBuilder;
import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.AbstractPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.DeepHierarchyUtils;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.protobuf.builder.ProtoBeanBuilder;
import com.github.dozermapper.protobuf.util.ProtoUtils;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtoFieldPropertyDescriptor
extends AbstractPropertyDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoFieldPropertyDescriptor.class);
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private Class<?> propertyType;
    private Class<?> genericType;
    private Descriptors.FieldDescriptor fieldDescriptor;

    ProtoFieldPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    public Class<?> getPropertyType() {
        if (this.propertyType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                }
                catch (Exception ignore) {
                    LOG.info("Determine field type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                    }
                    catch (Exception secondIgnore) {
                        LOG.info("Determine field type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaClass(this.getFieldDescriptor(), this.beanContainer);
            }
            this.propertyType = result;
        }
        return this.propertyType;
    }

    public Object getPropertyValue(Object bean) {
        Object result;
        if (MappingUtils.isDeepMapping((String)this.fieldName)) {
            result = DeepHierarchyUtils.getDeepFieldValue((Object)bean, (String)this.fieldName, (boolean)this.isIndexed, (int)this.index, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
        } else {
            result = this.getSimplePropertyValue(bean);
            if (this.isIndexed) {
                result = MappingUtils.getIndexedValue((Object)result, (int)this.index);
            }
        }
        return result;
    }

    private Object getSimplePropertyValue(Object bean) {
        if (bean instanceof BeanBuilder) {
            return null;
        }
        if (!(bean instanceof Message)) {
            throw new MappingException("Expected a Message instance, but got " + bean.getClass().getCanonicalName());
        }
        Object value = ProtoUtils.getFieldValue(bean, this.fieldName);
        return ProtoUtils.unwrapEnums(value, this.beanContainer);
    }

    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (!(bean instanceof ProtoBeanBuilder)) {
            throw new MappingException("Expected a ProtoBeanBuilder instance, but got " + bean.getClass().getCanonicalName());
        }
        ProtoBeanBuilder builder = (ProtoBeanBuilder)bean;
        if ((value = ProtoUtils.wrapEnums(value)) != null) {
            if (this.getFieldDescriptor().isMapField()) {
                String propertyName = Character.toUpperCase(this.fieldName.charAt(0)) + this.fieldName.substring(1);
                String methodName = String.format("putAll%s", propertyName);
                try {
                    Method mapSetterMethod = builder.internalProtoBuilder().getClass().getMethod(methodName, Map.class);
                    mapSetterMethod.invoke((Object)builder.internalProtoBuilder(), value);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new MappingException("Could not call map setter method " + methodName, (Throwable)ex);
                }
            } else {
                builder.internalProtoBuilder().setField(this.getFieldDescriptor(), value);
            }
        } else {
            builder.internalProtoBuilder().clearField(this.getFieldDescriptor());
        }
    }

    public Class<?> genericType() {
        if (this.genericType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                }
                catch (Exception ignore) {
                    LOG.info("Determine field generic type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                    }
                    catch (Exception secondIgnore) {
                        LOG.info("Determine field generic type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaGenericClassForCollection(this.getFieldDescriptor(), this.beanContainer);
            }
            this.genericType = result;
        }
        return this.genericType;
    }

    private Descriptors.FieldDescriptor getFieldDescriptor() {
        if (this.fieldDescriptor == null && Message.class.isAssignableFrom(this.clazz)) {
            this.fieldDescriptor = ProtoUtils.getFieldDescriptor(this.clazz, this.fieldName);
            if (this.fieldDescriptor == null && !MappingUtils.isDeepMapping((String)this.fieldName)) {
                throw new MappingException("No field descriptor for field with name: " + this.fieldName);
            }
        }
        return this.fieldDescriptor;
    }
}

