/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.spring;

import com.github.dozermapper.core.BeanFactory;
import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.CustomFieldMapper;
import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.events.EventListener;
import com.github.dozermapper.core.loader.api.BeanMappingBuilder;
import com.github.dozermapper.spring.DozerBeanMapperBuilderCustomizer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.io.Resource;

public class DozerBeanMapperFactoryBean
extends ApplicationObjectSupport
implements InitializingBean,
FactoryBean<Mapper> {
    private CustomFieldMapper customFieldMapper;
    private final List<String> mappingFileUrls = new ArrayList<String>(1);
    private final List<CustomConverter> customConverters = new ArrayList<CustomConverter>(0);
    private final List<BeanMappingBuilder> mappingBuilders = new ArrayList<BeanMappingBuilder>(0);
    private final List<EventListener> eventListeners = new ArrayList<EventListener>(0);
    private final Map<String, BeanFactory> beanFactories = new HashMap<String, BeanFactory>(0);
    private final Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>(0);
    private final List<DozerBeanMapperBuilderCustomizer> builderCustomizers = new ArrayList<DozerBeanMapperBuilderCustomizer>(0);
    private Mapper mapper;

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
    }

    public void setMappingFiles(Resource[] mappingFiles) throws IOException {
        if (mappingFiles != null && mappingFiles.length > 0) {
            for (Resource mappingFile : mappingFiles) {
                URL url = mappingFile.getURL();
                this.mappingFileUrls.add(url.toString());
            }
        }
    }

    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.customConverters.addAll(customConverters);
    }

    public void setMappingBuilders(List<BeanMappingBuilder> mappingBuilders) {
        this.mappingBuilders.addAll(mappingBuilders);
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners.addAll(eventListeners);
    }

    public void setFactories(Map<String, BeanFactory> beanFactories) {
        this.beanFactories.putAll(beanFactories);
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.customConvertersWithId.putAll(customConvertersWithId);
    }

    public void setBuilderCustomizers(List<DozerBeanMapperBuilderCustomizer> builderCustomizers) {
        this.builderCustomizers.addAll(builderCustomizers);
    }

    public void afterPropertiesSet() {
        Map contextCustomConvertersWithId = this.getApplicationContext().getBeansOfType(CustomConverter.class);
        Map contextBeanMappingBuilders = this.getApplicationContext().getBeansOfType(BeanMappingBuilder.class);
        Map contextEventListeners = this.getApplicationContext().getBeansOfType(EventListener.class);
        Map contextBeanFactories = this.getApplicationContext().getBeansOfType(BeanFactory.class);
        Map contextBuilderCustomizers = this.getApplicationContext().getBeansOfType(DozerBeanMapperBuilderCustomizer.class);
        this.customConverters.addAll(contextCustomConvertersWithId.values());
        this.mappingBuilders.addAll(contextBeanMappingBuilders.values());
        this.beanFactories.putAll(contextBeanFactories);
        this.eventListeners.addAll(contextEventListeners.values());
        this.customConvertersWithId.putAll(contextCustomConvertersWithId);
        this.builderCustomizers.addAll(contextBuilderCustomizers.values());
        DozerBeanMapperBuilder builder = DozerBeanMapperBuilder.create().withMappingFiles(this.mappingFileUrls).withCustomFieldMapper(this.customFieldMapper).withCustomConverters(this.customConverters).withMappingBuilders(this.mappingBuilders).withEventListeners(this.eventListeners).withBeanFactorys(this.beanFactories).withCustomConvertersWithIds(this.customConvertersWithId);
        this.builderCustomizers.forEach(customizer -> customizer.customize(builder));
        this.mapper = builder.build();
    }

    public Mapper getObject() {
        return this.mapper;
    }

    public Class<Mapper> getObjectType() {
        return Mapper.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

