/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.spring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerBeanMapper;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.DozerEventListener;
import org.dozer.Mapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DozerBeanMapperFactoryBean
implements FactoryBean<Mapper>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    DozerBeanMapper beanMapper;
    private Resource[] mappingFiles;
    private List<BeanMappingBuilder> mappingBuilders;
    private CustomFieldMapper customFieldMapper;
    private List<CustomConverter> customConverters;
    private Map<String, CustomConverter> customConvertersWithId;
    private List<DozerEventListener> eventListeners;
    private Map<String, BeanFactory> factories;
    private ApplicationContext applicationContext;

    public final void setMappingFiles(Resource[] mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public final void setMappingBuilders(List<BeanMappingBuilder> mappingBuilders) {
        this.mappingBuilders = mappingBuilders;
    }

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
    }

    public final void setCustomConverters(List<CustomConverter> customConverters) {
        this.customConverters = customConverters;
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.customConvertersWithId = customConvertersWithId;
    }

    public final void setEventListeners(List<DozerEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public final void setFactories(Map<String, BeanFactory> factories) {
        this.factories = factories;
    }

    public final Mapper getObject() throws Exception {
        return this.beanMapper;
    }

    public final Class<Mapper> getObjectType() {
        return Mapper.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        this.beanMapper = (DozerBeanMapper)DozerBeanMapperBuilder.buildDefault();
        this.loadMappingFiles();
        ArrayList<Object> allConverters = new ArrayList<Object>();
        HashMap<String, CustomConverter> allIdConverters = new HashMap<String, CustomConverter>();
        HashMap<String, BeanFactory> allFactories = new HashMap<String, BeanFactory>();
        ArrayList<Object> allListeners = new ArrayList<Object>();
        ArrayList<Object> allMappingBuilders = new ArrayList<Object>();
        Map contextConverters = this.applicationContext.getBeansOfType(CustomConverter.class);
        Map contextBeanFactories = this.applicationContext.getBeansOfType(BeanFactory.class);
        Map contextEventListeners = this.applicationContext.getBeansOfType(DozerEventListener.class);
        Map contextMappingBuilders = this.applicationContext.getBeansOfType(BeanMappingBuilder.class);
        allConverters.addAll(contextConverters.values());
        allIdConverters.putAll(contextConverters);
        allFactories.putAll(contextBeanFactories);
        allListeners.addAll(contextEventListeners.values());
        allMappingBuilders.addAll(contextMappingBuilders.values());
        if (this.customFieldMapper != null) {
            this.beanMapper.setCustomFieldMapper(this.customFieldMapper);
        }
        if (this.customConverters != null) {
            allConverters.addAll(this.customConverters);
        }
        if (this.customConvertersWithId != null) {
            allIdConverters.putAll(this.customConvertersWithId);
        }
        if (this.eventListeners != null) {
            allListeners.addAll(this.eventListeners);
        }
        if (this.factories != null) {
            allFactories.putAll(this.factories);
        }
        if (this.mappingBuilders != null) {
            allMappingBuilders.addAll(this.mappingBuilders);
        }
        if (!allConverters.isEmpty()) {
            this.beanMapper.setCustomConverters(allConverters);
        }
        if (!allIdConverters.isEmpty()) {
            this.beanMapper.setCustomConvertersWithId(allIdConverters);
        }
        if (!allFactories.isEmpty()) {
            this.beanMapper.setFactories(allFactories);
        }
        if (!allListeners.isEmpty()) {
            this.beanMapper.setEventListeners(allListeners);
        }
        if (!allMappingBuilders.isEmpty()) {
            for (BeanMappingBuilder beanMappingBuilder : allMappingBuilders) {
                this.beanMapper.addMapping(beanMappingBuilder);
            }
        }
    }

    private void loadMappingFiles() throws IOException {
        if (this.mappingFiles != null) {
            ArrayList<String> mappings = new ArrayList<String>(this.mappingFiles.length);
            for (Resource mappingFile : this.mappingFiles) {
                URL url = mappingFile.getURL();
                mappings.add(url.toString());
            }
            this.beanMapper.setMappingFiles(mappings);
        }
    }

    public void destroy() throws Exception {
        if (this.beanMapper != null) {
            this.beanMapper.destroy();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

