/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import io.github.douglasjunior.androidSimpleTooltip.R;
import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltipUtils;

@SuppressLint(value={"ViewConstructor"})
public class OverlayView
extends View {
    private static final int mDefaultOverlayCircleOffsetRes = R.dimen.simpletooltip_overlay_circle_offset;
    private static final int mDefaultOverlayAlphaRes = R.integer.simpletooltip_overlay_alpha;
    private View mAnchorView;
    private Bitmap bitmap;
    private float offset = 0.0f;

    OverlayView(Context context, View anchorView) {
        super(context);
        this.mAnchorView = anchorView;
        this.offset = context.getResources().getDimension(mDefaultOverlayCircleOffsetRes);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.bitmap == null) {
            this.createWindowFrame();
        }
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    private void createWindowFrame() {
        this.bitmap = Bitmap.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas osCanvas = new Canvas(this.bitmap);
        RectF outerRectangle = new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        Paint paint = new Paint(1);
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setAlpha(this.getResources().getInteger(mDefaultOverlayAlphaRes));
        osCanvas.drawRect(outerRectangle, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        RectF anchorRecr = SimpleTooltipUtils.calculeRectInWindow(this.mAnchorView);
        RectF overlayRecr = SimpleTooltipUtils.calculeRectInWindow(this);
        float left = anchorRecr.left - overlayRecr.left;
        float top = anchorRecr.top - overlayRecr.top;
        RectF oval = new RectF(left - this.offset, top - this.offset, left + (float)this.mAnchorView.getMeasuredWidth() + this.offset, top + (float)this.mAnchorView.getMeasuredHeight() + this.offset);
        osCanvas.drawOval(oval, paint);
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
        this.bitmap = null;
    }

    public View getAnchorView() {
        return this.mAnchorView;
    }

    public void setAnchorView(View anchorView) {
        this.mAnchorView = anchorView;
        this.invalidate();
    }
}

