/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.ColorInt;

class ArrowDrawable
extends ColorDrawable {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private final Paint mPaint = new Paint(1);
    private final int mBackgroundColor;
    private Path mPath;
    private final int mDirection;

    ArrowDrawable(@ColorInt int foregroundColor, int direction) {
        this.mBackgroundColor = 0;
        this.mPaint.setColor(foregroundColor);
        this.mDirection = direction;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updatePath(bounds);
    }

    private synchronized void updatePath(Rect bounds) {
        this.mPath = new Path();
        switch (this.mDirection) {
            case 0: {
                this.mPath.moveTo((float)bounds.width(), (float)bounds.height());
                this.mPath.lineTo(0.0f, (float)(bounds.height() / 2));
                this.mPath.lineTo((float)bounds.width(), 0.0f);
                this.mPath.lineTo((float)bounds.width(), (float)bounds.height());
                break;
            }
            case 1: {
                this.mPath.moveTo(0.0f, (float)bounds.height());
                this.mPath.lineTo((float)(bounds.width() / 2), 0.0f);
                this.mPath.lineTo((float)bounds.width(), (float)bounds.height());
                this.mPath.lineTo(0.0f, (float)bounds.height());
                break;
            }
            case 2: {
                this.mPath.moveTo(0.0f, 0.0f);
                this.mPath.lineTo((float)bounds.width(), (float)(bounds.height() / 2));
                this.mPath.lineTo(0.0f, (float)bounds.height());
                this.mPath.lineTo(0.0f, 0.0f);
                break;
            }
            case 3: {
                this.mPath.moveTo(0.0f, 0.0f);
                this.mPath.lineTo((float)(bounds.width() / 2), (float)bounds.height());
                this.mPath.lineTo((float)bounds.width(), 0.0f);
                this.mPath.lineTo(0.0f, 0.0f);
            }
        }
        this.mPath.close();
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(this.mBackgroundColor);
        if (this.mPath == null) {
            this.updatePath(this.getBounds());
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        if (this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mPaint.getColor() >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }
}

