/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.labels;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.donkingliang.labels.R;
import java.util.ArrayList;
import java.util.List;

public class LabelsView
extends ViewGroup
implements View.OnClickListener,
View.OnLongClickListener {
    private Context mContext;
    private ColorStateList mTextColor;
    private float mTextSize;
    private Drawable mLabelBg;
    private int mLabelWidth = -2;
    private int mLabelHeight = -2;
    private int mLabelGravity = 17;
    private int mTextPaddingLeft;
    private int mTextPaddingTop;
    private int mTextPaddingRight;
    private int mTextPaddingBottom;
    private int mWordMargin;
    private int mLineMargin;
    private SelectType mSelectType;
    private int mMaxSelect;
    private int mMinSelect;
    private int mMaxLines;
    private boolean isSingleLine = false;
    private boolean isTextBold = false;
    private boolean isIndicator;
    private static final int KEY_DATA = R.id.tag_key_data;
    private static final int KEY_POSITION = R.id.tag_key_position;
    private ArrayList<Object> mLabels = new ArrayList();
    private ArrayList<Integer> mSelectLabels = new ArrayList();
    private ArrayList<Integer> mCompulsorys = new ArrayList();
    private int lines;
    private OnLabelClickListener mLabelClickListener;
    private OnLabelLongClickListener mLabelLongClickListener;
    private OnLabelSelectChangeListener mLabelSelectChangeListener;
    private OnSelectChangeIntercept mOnSelectChangeIntercept;
    private static final String KEY_SUPER_STATE = "key_super_state";
    private static final String KEY_TEXT_COLOR_STATE = "key_text_color_state";
    private static final String KEY_TEXT_SIZE_STATE = "key_text_size_state";
    private static final String KEY_BG_RES_ID_STATE = "key_bg_res_id_state";
    private static final String KEY_PADDING_STATE = "key_padding_state";
    private static final String KEY_WORD_MARGIN_STATE = "key_word_margin_state";
    private static final String KEY_LINE_MARGIN_STATE = "key_line_margin_state";
    private static final String KEY_SELECT_TYPE_STATE = "key_select_type_state";
    private static final String KEY_MAX_SELECT_STATE = "key_max_select_state";
    private static final String KEY_MIN_SELECT_STATE = "key_min_select_state";
    private static final String KEY_MAX_LINES_STATE = "key_max_lines_state";
    private static final String KEY_INDICATOR_STATE = "key_indicator_state";
    private static final String KEY_LABELS_STATE = "key_labels_state";
    private static final String KEY_SELECT_LABELS_STATE = "key_select_labels_state";
    private static final String KEY_COMPULSORY_LABELS_STATE = "key_select_compulsory_state";
    private static final String KEY_LABEL_WIDTH_STATE = "key_label_width_state";
    private static final String KEY_LABEL_HEIGHT_STATE = "key_label_height_state";
    private static final String KEY_LABEL_GRAVITY_STATE = "key_label_gravity_state";
    private static final String KEY_SINGLE_LINE_STATE = "key_single_line_state";
    private static final String KEY_TEXT_STYLE_STATE = "key_text_style_state";

    public LabelsView(Context context) {
        super(context);
        this.mContext = context;
        this.showEditPreview();
    }

    public LabelsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.getAttrs(context, attrs);
        this.showEditPreview();
    }

    public LabelsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getAttrs(context, attrs);
        this.showEditPreview();
    }

    private void getAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.LabelsView);
            int type = mTypedArray.getInt(R.styleable.LabelsView_selectType, 1);
            this.mSelectType = SelectType.get(type);
            this.mMaxSelect = mTypedArray.getInteger(R.styleable.LabelsView_maxSelect, 0);
            this.mMinSelect = mTypedArray.getInteger(R.styleable.LabelsView_minSelect, 0);
            this.mMaxLines = mTypedArray.getInteger(R.styleable.LabelsView_maxLines, 0);
            this.isIndicator = mTypedArray.getBoolean(R.styleable.LabelsView_isIndicator, false);
            this.mLabelGravity = mTypedArray.getInt(R.styleable.LabelsView_labelGravity, this.mLabelGravity);
            this.mLabelWidth = mTypedArray.getLayoutDimension(R.styleable.LabelsView_labelTextWidth, this.mLabelWidth);
            this.mLabelHeight = mTypedArray.getLayoutDimension(R.styleable.LabelsView_labelTextHeight, this.mLabelHeight);
            this.mTextColor = mTypedArray.hasValue(R.styleable.LabelsView_labelTextColor) ? mTypedArray.getColorStateList(R.styleable.LabelsView_labelTextColor) : ColorStateList.valueOf((int)-16777216);
            this.mTextSize = mTypedArray.getDimension(R.styleable.LabelsView_labelTextSize, (float)this.sp2px(14.0f));
            if (mTypedArray.hasValue(R.styleable.LabelsView_labelTextPadding)) {
                int textPadding;
                this.mTextPaddingRight = this.mTextPaddingBottom = (textPadding = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_labelTextPadding, 0));
                this.mTextPaddingTop = this.mTextPaddingBottom;
                this.mTextPaddingLeft = this.mTextPaddingBottom;
            } else {
                this.mTextPaddingLeft = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_labelTextPaddingLeft, this.dp2px(10.0f));
                this.mTextPaddingTop = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_labelTextPaddingTop, this.dp2px(5.0f));
                this.mTextPaddingRight = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_labelTextPaddingRight, this.dp2px(10.0f));
                this.mTextPaddingBottom = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_labelTextPaddingBottom, this.dp2px(5.0f));
            }
            this.mLineMargin = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_lineMargin, this.dp2px(5.0f));
            this.mWordMargin = mTypedArray.getDimensionPixelOffset(R.styleable.LabelsView_wordMargin, this.dp2px(5.0f));
            if (mTypedArray.hasValue(R.styleable.LabelsView_labelBackground)) {
                int labelBgResId = mTypedArray.getResourceId(R.styleable.LabelsView_labelBackground, 0);
                if (labelBgResId != 0) {
                    this.mLabelBg = this.getResources().getDrawable(labelBgResId);
                } else {
                    int labelBgColor = mTypedArray.getColor(R.styleable.LabelsView_labelBackground, 0);
                    this.mLabelBg = new ColorDrawable(labelBgColor);
                }
            } else {
                this.mLabelBg = this.getResources().getDrawable(R.drawable.default_label_bg);
            }
            this.isSingleLine = mTypedArray.getBoolean(R.styleable.LabelsView_singleLine, false);
            this.isTextBold = mTypedArray.getBoolean(R.styleable.LabelsView_isTextBold, false);
            mTypedArray.recycle();
        }
    }

    private void showEditPreview() {
        if (this.isInEditMode()) {
            ArrayList<String> label = new ArrayList<String>();
            label.add("Label 1");
            label.add("Label 2");
            label.add("Label 3");
            label.add("Label 4");
            label.add("Label 5");
            label.add("Label 6");
            label.add("Label 7");
            this.setLabels(label);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isSingleLine) {
            this.measureSingleLine(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureMultiLine(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureSingleLine(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int contentWidth = 0;
        int maxItemHeight = 0;
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            contentWidth += view.getMeasuredWidth();
            if (i != count - 1) {
                contentWidth += this.mWordMargin;
            }
            maxItemHeight = Math.max(maxItemHeight, view.getMeasuredHeight());
        }
        this.setMeasuredDimension(this.measureSize(widthMeasureSpec, contentWidth + this.getPaddingLeft() + this.getPaddingRight()), this.measureSize(heightMeasureSpec, maxItemHeight + this.getPaddingTop() + this.getPaddingBottom()));
        this.lines = count > 0 ? 1 : 0;
    }

    private void measureMultiLine(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int contentHeight = 0;
        int lineWidth = 0;
        int maxLineWidth = 0;
        int maxItemHeight = 0;
        int lineCount = 1;
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            if (lineWidth + view.getMeasuredWidth() > maxWidth) {
                if (this.mMaxLines > 0 && ++lineCount > this.mMaxLines) {
                    --lineCount;
                    break;
                }
                contentHeight += this.mLineMargin;
                contentHeight += maxItemHeight;
                maxItemHeight = 0;
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
                lineWidth = 0;
            }
            lineWidth += view.getMeasuredWidth();
            maxItemHeight = Math.max(maxItemHeight, view.getMeasuredHeight());
            if (i == count - 1) continue;
            if (lineWidth + this.mWordMargin > maxWidth) {
                if (this.mMaxLines > 0 && ++lineCount > this.mMaxLines) {
                    --lineCount;
                    break;
                }
                contentHeight += this.mLineMargin;
                contentHeight += maxItemHeight;
                maxItemHeight = 0;
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
                lineWidth = 0;
                continue;
            }
            lineWidth += this.mWordMargin;
        }
        maxLineWidth = Math.max(maxLineWidth, lineWidth);
        this.setMeasuredDimension(this.measureSize(widthMeasureSpec, maxLineWidth + this.getPaddingLeft() + this.getPaddingRight()), this.measureSize(heightMeasureSpec, (contentHeight += maxItemHeight) + this.getPaddingTop() + this.getPaddingBottom()));
        this.lines = count > 0 ? lineCount : 0;
    }

    private int measureSize(int measureSpec, int size) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = size;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        result = Math.max(result, this.getSuggestedMinimumWidth());
        result = LabelsView.resolveSizeAndState((int)result, (int)measureSpec, (int)0);
        return result;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int x = this.getPaddingLeft();
        int y = this.getPaddingTop();
        int contentWidth = right - left;
        int maxItemHeight = 0;
        int lineCount = 1;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (!this.isSingleLine && contentWidth < x + view.getMeasuredWidth() + this.getPaddingRight()) {
                if (this.mMaxLines > 0 && ++lineCount > this.mMaxLines) break;
                x = this.getPaddingLeft();
                y += this.mLineMargin;
                y += maxItemHeight;
                maxItemHeight = 0;
            }
            view.layout(x, y, x + view.getMeasuredWidth(), y + view.getMeasuredHeight());
            x += view.getMeasuredWidth();
            x += this.mWordMargin;
            maxItemHeight = Math.max(maxItemHeight, view.getMeasuredHeight());
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, super.onSaveInstanceState());
        if (this.mTextColor != null) {
            bundle.putParcelable(KEY_TEXT_COLOR_STATE, (Parcelable)this.mTextColor);
        }
        bundle.putFloat(KEY_TEXT_SIZE_STATE, this.mTextSize);
        bundle.putInt(KEY_LABEL_WIDTH_STATE, this.mLabelWidth);
        bundle.putInt(KEY_LABEL_HEIGHT_STATE, this.mLabelHeight);
        bundle.putInt(KEY_LABEL_GRAVITY_STATE, this.mLabelGravity);
        bundle.putIntArray(KEY_PADDING_STATE, new int[]{this.mTextPaddingLeft, this.mTextPaddingTop, this.mTextPaddingRight, this.mTextPaddingBottom});
        bundle.putInt(KEY_WORD_MARGIN_STATE, this.mWordMargin);
        bundle.putInt(KEY_LINE_MARGIN_STATE, this.mLineMargin);
        bundle.putInt(KEY_SELECT_TYPE_STATE, this.mSelectType.value);
        bundle.putInt(KEY_MAX_SELECT_STATE, this.mMaxSelect);
        bundle.putInt(KEY_MIN_SELECT_STATE, this.mMinSelect);
        bundle.putInt(KEY_MAX_LINES_STATE, this.mMaxLines);
        bundle.putBoolean(KEY_INDICATOR_STATE, this.isIndicator);
        if (!this.mSelectLabels.isEmpty()) {
            bundle.putIntegerArrayList(KEY_SELECT_LABELS_STATE, this.mSelectLabels);
        }
        if (!this.mCompulsorys.isEmpty()) {
            bundle.putIntegerArrayList(KEY_COMPULSORY_LABELS_STATE, this.mCompulsorys);
        }
        bundle.putBoolean(KEY_SINGLE_LINE_STATE, this.isSingleLine);
        bundle.putBoolean(KEY_TEXT_STYLE_STATE, this.isTextBold);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            ArrayList selectLabel;
            Bundle bundle = (Bundle)state;
            super.onRestoreInstanceState(bundle.getParcelable(KEY_SUPER_STATE));
            ColorStateList color = (ColorStateList)bundle.getParcelable(KEY_TEXT_COLOR_STATE);
            if (color != null) {
                this.setLabelTextColor(color);
            }
            this.setLabelTextSize(bundle.getFloat(KEY_TEXT_SIZE_STATE, this.mTextSize));
            this.mLabelWidth = bundle.getInt(KEY_LABEL_WIDTH_STATE, this.mLabelWidth);
            this.mLabelHeight = bundle.getInt(KEY_LABEL_HEIGHT_STATE, this.mLabelHeight);
            this.setLabelGravity(bundle.getInt(KEY_LABEL_GRAVITY_STATE, this.mLabelGravity));
            int[] padding = bundle.getIntArray(KEY_PADDING_STATE);
            if (padding != null && padding.length == 4) {
                this.setLabelTextPadding(padding[0], padding[1], padding[2], padding[3]);
            }
            this.setWordMargin(bundle.getInt(KEY_WORD_MARGIN_STATE, this.mWordMargin));
            this.setLineMargin(bundle.getInt(KEY_LINE_MARGIN_STATE, this.mLineMargin));
            this.setSelectType(SelectType.get(bundle.getInt(KEY_SELECT_TYPE_STATE, this.mSelectType.value)));
            this.setMaxSelect(bundle.getInt(KEY_MAX_SELECT_STATE, this.mMaxSelect));
            this.setMinSelect(bundle.getInt(KEY_MIN_SELECT_STATE, this.mMinSelect));
            this.setMaxLines(bundle.getInt(KEY_MAX_LINES_STATE, this.mMaxLines));
            this.setIndicator(bundle.getBoolean(KEY_INDICATOR_STATE, this.isIndicator));
            this.setSingleLine(bundle.getBoolean(KEY_SINGLE_LINE_STATE, this.isSingleLine));
            this.setTextBold(bundle.getBoolean(KEY_TEXT_STYLE_STATE, this.isTextBold));
            ArrayList compulsory = bundle.getIntegerArrayList(KEY_COMPULSORY_LABELS_STATE);
            if (compulsory != null && !compulsory.isEmpty()) {
                this.setCompulsorys(compulsory);
            }
            if ((selectLabel = bundle.getIntegerArrayList(KEY_SELECT_LABELS_STATE)) != null && !selectLabel.isEmpty()) {
                int size = selectLabel.size();
                int[] positions = new int[size];
                for (int i = 0; i < size; ++i) {
                    positions[i] = (Integer)selectLabel.get(i);
                }
                this.setSelects(positions);
            }
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setLabels(List<String> labels) {
        this.setLabels(labels, new LabelTextProvider<String>(){

            @Override
            public CharSequence getLabelText(TextView label, int position, String data) {
                return data.trim();
            }
        });
    }

    public <T> void setLabels(List<T> labels, LabelTextProvider<T> provider) {
        this.innerClearAllSelect();
        this.removeAllViews();
        this.mLabels.clear();
        if (labels != null) {
            this.mLabels.addAll(labels);
            int size = labels.size();
            for (int i = 0; i < size; ++i) {
                this.addLabel(labels.get(i), i, provider);
            }
            this.ensureLabelClickable();
        }
        if (this.mSelectType == SelectType.SINGLE_IRREVOCABLY) {
            this.setSelects(0);
        }
    }

    public <T> List<T> getLabels() {
        return this.mLabels;
    }

    private <T> void addLabel(T data, int position, LabelTextProvider<T> provider) {
        TextView label = new TextView(this.mContext);
        label.setPadding(this.mTextPaddingLeft, this.mTextPaddingTop, this.mTextPaddingRight, this.mTextPaddingBottom);
        label.setTextSize(0, this.mTextSize);
        label.setGravity(this.mLabelGravity);
        label.setTextColor(this.mTextColor);
        label.setBackgroundDrawable(this.mLabelBg.getConstantState().newDrawable());
        label.setTag(KEY_DATA, data);
        label.setTag(KEY_POSITION, (Object)position);
        label.setOnClickListener((View.OnClickListener)this);
        label.setOnLongClickListener((View.OnLongClickListener)this);
        label.getPaint().setFakeBoldText(this.isTextBold);
        this.addView((View)label, this.mLabelWidth, this.mLabelHeight);
        label.setText(provider.getLabelText(label, position, data));
    }

    private void ensureLabelClickable() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TextView label = (TextView)this.getChildAt(i);
            label.setClickable(this.mLabelClickListener != null || this.mLabelLongClickListener != null || this.mSelectType != SelectType.NONE);
        }
    }

    public void onClick(View v) {
        if (v instanceof TextView) {
            TextView label = (TextView)v;
            if (!this.isIndicator && this.mSelectType != SelectType.NONE) {
                if (label.isSelected()) {
                    boolean irrevocable = this.mSelectType == SelectType.MULTI && this.mCompulsorys.contains((Integer)label.getTag(KEY_POSITION));
                    irrevocable = irrevocable || this.mSelectType == SelectType.MULTI && this.mSelectLabels.size() <= this.mMinSelect;
                    boolean bl = irrevocable = irrevocable || this.mSelectType == SelectType.SINGLE_IRREVOCABLY;
                    if (!irrevocable && !this.selectChangeIntercept(label)) {
                        this.setLabelSelect(label, false);
                    }
                } else if (this.mSelectType == SelectType.SINGLE || this.mSelectType == SelectType.SINGLE_IRREVOCABLY) {
                    if (!this.selectChangeIntercept(label)) {
                        this.innerClearAllSelect();
                        this.setLabelSelect(label, true);
                    }
                } else if (!(this.mSelectType != SelectType.MULTI || this.mMaxSelect > 0 && this.mMaxSelect <= this.mSelectLabels.size() || this.selectChangeIntercept(label))) {
                    this.setLabelSelect(label, true);
                }
            }
            if (this.mLabelClickListener != null) {
                this.mLabelClickListener.onLabelClick(label, label.getTag(KEY_DATA), (Integer)label.getTag(KEY_POSITION));
            }
        }
    }

    public boolean onLongClick(View v) {
        if (v instanceof TextView) {
            TextView label = (TextView)v;
            if (this.mLabelLongClickListener != null) {
                return this.mLabelLongClickListener.onLabelLongClick(label, label.getTag(KEY_DATA), (Integer)label.getTag(KEY_POSITION));
            }
        }
        return false;
    }

    private void setLabelSelect(TextView label, boolean isSelect) {
        if (label.isSelected() != isSelect) {
            label.setSelected(isSelect);
            if (isSelect) {
                this.mSelectLabels.add((Integer)label.getTag(KEY_POSITION));
            } else {
                this.mSelectLabels.remove((Integer)label.getTag(KEY_POSITION));
            }
            if (this.mLabelSelectChangeListener != null) {
                this.mLabelSelectChangeListener.onLabelSelectChange(label, label.getTag(KEY_DATA), isSelect, (Integer)label.getTag(KEY_POSITION));
            }
        }
    }

    private boolean selectChangeIntercept(TextView label) {
        return this.mOnSelectChangeIntercept != null && this.mOnSelectChangeIntercept.onIntercept(label, label.getTag(KEY_DATA), label.isSelected(), !label.isSelected(), (Integer)label.getTag(KEY_POSITION));
    }

    public void clearAllSelect() {
        if (this.mSelectType != SelectType.SINGLE_IRREVOCABLY) {
            if (this.mSelectType == SelectType.MULTI && !this.mCompulsorys.isEmpty()) {
                this.clearNotCompulsorySelect();
            } else {
                this.innerClearAllSelect();
            }
        }
    }

    private void innerClearAllSelect() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.setLabelSelect((TextView)this.getChildAt(i), false);
        }
        this.mSelectLabels.clear();
    }

    private void clearNotCompulsorySelect() {
        int count = this.getChildCount();
        ArrayList<Integer> temps = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            if (this.mCompulsorys.contains(i)) continue;
            this.setLabelSelect((TextView)this.getChildAt(i), false);
            temps.add(i);
        }
        this.mSelectLabels.removeAll(temps);
    }

    public void setSelects(List<Integer> positions) {
        if (positions != null) {
            int size = positions.size();
            int[] ps = new int[size];
            for (int i = 0; i < size; ++i) {
                ps[i] = positions.get(i);
            }
            this.setSelects(ps);
        }
    }

    public void setSelects(int ... positions) {
        if (this.mSelectType != SelectType.NONE) {
            ArrayList<TextView> selectLabels = new ArrayList<TextView>();
            int count = this.getChildCount();
            int size = this.mSelectType == SelectType.SINGLE || this.mSelectType == SelectType.SINGLE_IRREVOCABLY ? 1 : this.mMaxSelect;
            for (int p : positions) {
                if (p >= count) continue;
                TextView label = (TextView)this.getChildAt(p);
                if (!selectLabels.contains(label)) {
                    this.setLabelSelect(label, true);
                    selectLabels.add(label);
                }
                if (size > 0 && selectLabels.size() == size) break;
            }
            for (int i = 0; i < count; ++i) {
                TextView label = (TextView)this.getChildAt(i);
                if (selectLabels.contains(label)) continue;
                this.setLabelSelect(label, false);
            }
        }
    }

    public void setCompulsorys(List<Integer> positions) {
        if (this.mSelectType == SelectType.MULTI && positions != null) {
            this.mCompulsorys.clear();
            this.mCompulsorys.addAll(positions);
            this.innerClearAllSelect();
            this.setSelects(positions);
        }
    }

    public void setCompulsorys(int ... positions) {
        if (this.mSelectType == SelectType.MULTI && positions != null) {
            ArrayList<Integer> ps = new ArrayList<Integer>(positions.length);
            for (int i : positions) {
                ps.add(i);
            }
            this.setCompulsorys(ps);
        }
    }

    public List<Integer> getCompulsorys() {
        return this.mCompulsorys;
    }

    public void clearCompulsorys() {
        if (this.mSelectType == SelectType.MULTI && !this.mCompulsorys.isEmpty()) {
            this.mCompulsorys.clear();
            this.innerClearAllSelect();
        }
    }

    public List<Integer> getSelectLabels() {
        return this.mSelectLabels;
    }

    public <T> List<T> getSelectLabelDatas() {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = this.mSelectLabels.size();
        for (int i = 0; i < size; ++i) {
            View label = this.getChildAt(this.mSelectLabels.get(i));
            Object data = label.getTag(KEY_DATA);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public void setLabelBackgroundResource(int resId) {
        this.setLabelBackgroundDrawable(this.getResources().getDrawable(resId));
    }

    public void setLabelBackgroundColor(int color) {
        this.setLabelBackgroundDrawable((Drawable)new ColorDrawable(color));
    }

    public void setLabelBackgroundDrawable(Drawable drawable2) {
        this.mLabelBg = drawable2;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TextView label = (TextView)this.getChildAt(i);
            label.setBackgroundDrawable(this.mLabelBg.getConstantState().newDrawable());
        }
    }

    public void setLabelTextPadding(int left, int top, int right, int bottom) {
        if (this.mTextPaddingLeft != left || this.mTextPaddingTop != top || this.mTextPaddingRight != right || this.mTextPaddingBottom != bottom) {
            this.mTextPaddingLeft = left;
            this.mTextPaddingTop = top;
            this.mTextPaddingRight = right;
            this.mTextPaddingBottom = bottom;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                TextView label = (TextView)this.getChildAt(i);
                label.setPadding(left, top, right, bottom);
            }
        }
    }

    public int getTextPaddingLeft() {
        return this.mTextPaddingLeft;
    }

    public int getTextPaddingTop() {
        return this.mTextPaddingTop;
    }

    public int getTextPaddingRight() {
        return this.mTextPaddingRight;
    }

    public int getTextPaddingBottom() {
        return this.mTextPaddingBottom;
    }

    public void setLabelTextSize(float size) {
        if (this.mTextSize != size) {
            this.mTextSize = size;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                TextView label = (TextView)this.getChildAt(i);
                label.setTextSize(0, size);
            }
        }
    }

    public float getLabelTextSize() {
        return this.mTextSize;
    }

    public void setLabelTextColor(int color) {
        this.setLabelTextColor(ColorStateList.valueOf((int)color));
    }

    public void setLabelTextColor(ColorStateList color) {
        this.mTextColor = color;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TextView label = (TextView)this.getChildAt(i);
            label.setTextColor(this.mTextColor);
        }
    }

    public ColorStateList getLabelTextColor() {
        return this.mTextColor;
    }

    public void setLabelGravity(int gravity) {
        if (this.mLabelGravity != gravity) {
            this.mLabelGravity = gravity;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                TextView label = (TextView)this.getChildAt(i);
                label.setGravity(gravity);
            }
        }
    }

    public int getLabelGravity() {
        return this.mLabelGravity;
    }

    public void setTextBold(boolean isBold) {
        if (this.isTextBold != isBold) {
            this.isTextBold = isBold;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                TextView label = (TextView)this.getChildAt(i);
                label.getPaint().setFakeBoldText(this.isTextBold);
                label.invalidate();
            }
        }
    }

    public boolean isTextBold() {
        return this.isTextBold;
    }

    public void setLineMargin(int margin) {
        if (this.mLineMargin != margin) {
            this.mLineMargin = margin;
            this.requestLayout();
        }
    }

    public int getLineMargin() {
        return this.mLineMargin;
    }

    public void setWordMargin(int margin) {
        if (this.mWordMargin != margin) {
            this.mWordMargin = margin;
            this.requestLayout();
        }
    }

    public int getWordMargin() {
        return this.mWordMargin;
    }

    public void setSelectType(SelectType selectType) {
        if (this.mSelectType != selectType) {
            this.mSelectType = selectType;
            this.innerClearAllSelect();
            if (this.mSelectType == SelectType.SINGLE_IRREVOCABLY) {
                this.setSelects(0);
            }
            if (this.mSelectType != SelectType.MULTI) {
                this.mCompulsorys.clear();
            }
            this.ensureLabelClickable();
        }
    }

    public SelectType getSelectType() {
        return this.mSelectType;
    }

    public void setMaxSelect(int maxSelect) {
        if (this.mMaxSelect != maxSelect) {
            this.mMaxSelect = maxSelect;
            if (this.mSelectType == SelectType.MULTI) {
                this.innerClearAllSelect();
            }
        }
    }

    public int getMaxSelect() {
        return this.mMaxSelect;
    }

    public void setMinSelect(int minSelect) {
        this.mMinSelect = minSelect;
    }

    public int getMinSelect() {
        return this.mMinSelect;
    }

    public void setMaxLines(int maxLines) {
        if (this.mMaxLines != maxLines) {
            this.mMaxLines = maxLines;
            this.requestLayout();
        }
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setIndicator(boolean indicator) {
        this.isIndicator = indicator;
    }

    public boolean isIndicator() {
        return this.isIndicator;
    }

    public void setSingleLine(boolean isSingleLine) {
        if (this.isSingleLine != isSingleLine) {
            this.isSingleLine = isSingleLine;
            this.requestLayout();
        }
    }

    public boolean isSingleLine() {
        return this.isSingleLine;
    }

    public int getLines() {
        return this.lines;
    }

    public void setOnLabelClickListener(OnLabelClickListener l) {
        this.mLabelClickListener = l;
        this.ensureLabelClickable();
    }

    public void setOnLabelLongClickListener(OnLabelLongClickListener l) {
        this.mLabelLongClickListener = l;
        this.ensureLabelClickable();
    }

    public void setOnLabelSelectChangeListener(OnLabelSelectChangeListener l) {
        this.mLabelSelectChangeListener = l;
    }

    public void setOnSelectChangeIntercept(OnSelectChangeIntercept intercept) {
        this.mOnSelectChangeIntercept = intercept;
    }

    private int sp2px(float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int dp2px(float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public static interface LabelTextProvider<T> {
        public CharSequence getLabelText(TextView var1, int var2, T var3);
    }

    public static interface OnSelectChangeIntercept {
        public boolean onIntercept(TextView var1, Object var2, boolean var3, boolean var4, int var5);
    }

    public static interface OnLabelSelectChangeListener {
        public void onLabelSelectChange(TextView var1, Object var2, boolean var3, int var4);
    }

    public static interface OnLabelLongClickListener {
        public boolean onLabelLongClick(TextView var1, Object var2, int var3);
    }

    public static interface OnLabelClickListener {
        public void onLabelClick(TextView var1, Object var2, int var3);
    }

    public static enum SelectType {
        NONE(1),
        SINGLE(2),
        SINGLE_IRREVOCABLY(3),
        MULTI(4);

        int value;

        private SelectType(int value) {
            this.value = value;
        }

        static SelectType get(int value) {
            switch (value) {
                case 1: {
                    return NONE;
                }
                case 2: {
                    return SINGLE;
                }
                case 3: {
                    return SINGLE_IRREVOCABLY;
                }
                case 4: {
                    return MULTI;
                }
            }
            return NONE;
        }
    }
}

