/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;

public class ClipImageView
extends AppCompatImageView {
    private PointF mDownPoint;
    private PointF mMiddlePoint;
    private Matrix mMatrix;
    private Matrix mTempMatrix;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private final int MODE_NONE = 0;
    private final int MODE_DRAG = 1;
    private final int MODE_ZOOM = 2;
    private final int MODE_POINTER_UP = 3;
    private int CURR_MODE = 0;
    private float mLastDistance;
    private Paint mFrontGroundPaint = new Paint();
    private int mTargetWidth;
    private int mTargetHeight;
    private Xfermode mXfermode;
    private Rect r;
    private RectF rf;
    private float mCircleCenterX;
    private float mCircleCenterY;
    private float mCircleX;
    private float mCircleY;
    private boolean isCutImage;
    private float mRatio = 1.0f;

    public ClipImageView(Context context) {
        super(context);
        this.setRadius();
    }

    public ClipImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setRadius();
    }

    public void setBitmapData(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.mBitmapHeight = bitmap.getHeight();
        this.mBitmapWidth = bitmap.getWidth();
        this.setImageBitmap(bitmap);
        this.init();
    }

    private void init() {
        this.mDownPoint = new PointF();
        this.mMiddlePoint = new PointF();
        this.mMatrix = new Matrix();
        this.mTempMatrix = new Matrix();
        this.mFrontGroundPaint.setColor(Color.parseColor((String)"#ac000000"));
        this.mFrontGroundPaint.setAntiAlias(true);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.post(new Runnable(){

            @Override
            public void run() {
                ClipImageView.this.center();
            }
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setRadius();
    }

    private void setRadius() {
        this.mTargetWidth = ClipImageView.getScreenWidth(this.getContext());
        this.mTargetHeight = (int)((float)this.mTargetWidth * this.mRatio);
        this.mCircleCenterX = this.getWidth() / 2;
        this.mCircleCenterY = this.getHeight() / 2;
        this.mCircleX = this.mCircleCenterX - (float)(this.mTargetWidth / 2);
        this.mCircleY = this.mCircleCenterY - (float)(this.mTargetHeight / 2);
    }

    public void setRatio(float ratio) {
        if (this.mRatio != ratio) {
            this.mRatio = ratio;
            this.setRadius();
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isCutImage) {
            return;
        }
        if (this.rf == null || this.rf.isEmpty()) {
            this.r = new Rect(0, 0, this.getWidth(), this.getHeight());
            this.rf = new RectF(this.r);
        }
        int sc = canvas.saveLayer(this.rf, null, 31);
        canvas.drawRect(this.r, this.mFrontGroundPaint);
        this.mFrontGroundPaint.setXfermode(this.mXfermode);
        float left = this.mCircleCenterX - (float)(this.mTargetWidth / 2);
        float top = this.mCircleCenterY - (float)(this.mTargetHeight / 2);
        float right = this.mCircleCenterX + (float)(this.mTargetWidth / 2);
        float bottom = this.mCircleCenterY + (float)(this.mTargetHeight / 2);
        canvas.drawRect(left, top, right, bottom, this.mFrontGroundPaint);
        canvas.restoreToCount(sc);
        this.mFrontGroundPaint.setXfermode(null);
    }

    public Bitmap clipImage() {
        this.isCutImage = true;
        Paint paint = new Paint();
        this.setDrawingCacheEnabled(true);
        Bitmap bitmap = this.getDrawingCache();
        Bitmap targetBitmap = Bitmap.createBitmap((int)this.mTargetWidth, (int)this.mTargetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(targetBitmap);
        int left = -bitmap.getWidth() / 2 + this.mTargetWidth / 2;
        int top = -this.getHeight() / 2 + this.mTargetHeight / 2;
        int right = bitmap.getWidth() / 2 + this.mTargetWidth / 2;
        int bottom = this.getHeight() / 2 + this.mTargetHeight / 2;
        RectF dst = new RectF((float)left, (float)top, (float)right, (float)bottom);
        canvas.drawBitmap(bitmap, null, dst, paint);
        this.setDrawingCacheEnabled(false);
        bitmap.recycle();
        bitmap = null;
        this.isCutImage = false;
        return targetBitmap;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mMatrix == null) {
            return super.onTouchEvent(event);
        }
        float[] values = new float[9];
        this.mMatrix.getValues(values);
        float left = values[2];
        float top = values[5];
        float right = left + (float)this.mBitmapWidth * values[0];
        float bottom = top + (float)this.mBitmapHeight * values[4];
        float x = 0.0f;
        float y = 0.0f;
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.CURR_MODE = 1;
                this.mDownPoint.set(event.getX(), event.getY());
                break;
            }
            case 5: {
                if (!(this.getDistance(event) > 10.0f)) break;
                this.CURR_MODE = 2;
                this.midPoint(this.mMiddlePoint, event);
                this.mLastDistance = this.getDistance(event);
                break;
            }
            case 2: {
                if (this.CURR_MODE == 1 || this.CURR_MODE == 3) {
                    if (this.CURR_MODE == 1) {
                        x = event.getX() - this.mDownPoint.x;
                        y = event.getY() - this.mDownPoint.y;
                        if (x + left > this.mCircleX) {
                            x = 0.0f;
                        }
                        if (x + right < this.mCircleX + (float)this.mTargetWidth) {
                            x = 0.0f;
                        }
                        if (y + top > this.mCircleY) {
                            y = 0.0f;
                        }
                        if (y + bottom < this.mCircleY + (float)this.mTargetHeight) {
                            y = 0.0f;
                        }
                        this.mMatrix.postTranslate(x, y);
                        this.mDownPoint.set(event.getX(), event.getY());
                        break;
                    }
                    this.CURR_MODE = 1;
                    this.mDownPoint.set(event.getX(), event.getY());
                    break;
                }
                float distance = this.getDistance(event);
                if (!(distance > 10.0f)) break;
                float scale = distance / this.mLastDistance;
                if (left >= this.mCircleX) {
                    this.mMiddlePoint.x = 0.0f;
                }
                if (right <= this.mCircleX + (float)this.mTargetWidth) {
                    this.mMiddlePoint.x = right;
                }
                if (top >= this.mCircleY) {
                    this.mMiddlePoint.y = 0.0f;
                }
                if (bottom <= this.mCircleY + (float)this.mTargetHeight) {
                    this.mMiddlePoint.y = bottom;
                }
                this.mTempMatrix.set(this.mMatrix);
                this.mTempMatrix.postScale(scale, scale, this.mMiddlePoint.x, this.mMiddlePoint.y);
                float[] temp_values = new float[9];
                this.mTempMatrix.getValues(temp_values);
                float temp_left = temp_values[2];
                float temp_top = temp_values[5];
                float temp_right = temp_left + (float)this.mBitmapWidth * temp_values[0];
                float temp_bottom = temp_top + (float)this.mBitmapHeight * temp_values[4];
                if (temp_left > this.mCircleX || temp_right < this.mCircleX + (float)this.mTargetWidth || temp_top > this.mCircleY || temp_bottom < this.mCircleY + (float)this.mTargetHeight) {
                    return true;
                }
                this.mMatrix.postScale(scale, scale, this.mMiddlePoint.x, this.mMiddlePoint.y);
                this.mLastDistance = this.getDistance(event);
                break;
            }
            case 1: {
                this.CURR_MODE = 0;
                break;
            }
            case 6: {
                this.CURR_MODE = 3;
            }
        }
        this.setImageMatrix(this.mMatrix);
        return true;
    }

    private float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    protected void center() {
        float height = this.mBitmapHeight;
        float width = this.mBitmapWidth;
        float scale = Math.max((float)this.mTargetWidth / width, (float)this.mTargetHeight / height);
        float deltaX = -(width * scale - (float)this.getWidth()) / 2.0f;
        float deltaY = -(height * scale - (float)this.getHeight()) / 2.0f;
        this.mMatrix.postScale(scale, scale);
        this.mMatrix.postTranslate(deltaX, deltaY);
        this.setImageMatrix(this.mMatrix);
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }
}

