/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import com.donkingliang.imageselector.utils.StringUtils;
import com.donkingliang.imageselector.utils.UriUtils;
import com.donkingliang.imageselector.utils.VersionUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageUtil {
    public static String getImageCacheDir(Context context) {
        File file = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            file = VersionUtils.isAndroidQ() ? context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) : context.getExternalCacheDir();
        }
        if (file == null) {
            file = context.getCacheDir();
        }
        return file.getPath() + File.separator + "image_select";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveImage(Bitmap bitmap, String path, String name) {
        FileOutputStream b = null;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = path + File.separator + name + ".jpg";
        try {
            b = new FileOutputStream(fileName);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)b);
            String string2 = fileName;
            return string2;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (b != null) {
                    b.flush();
                    b.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static Bitmap zoomBitmap(Bitmap bm, int reqWidth, int reqHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)reqWidth / (float)width;
        float scaleHeight = (float)reqHeight / (float)height;
        float scale = Math.min(scaleWidth, scaleHeight);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    @SuppressLint(value={"NewApi"})
    public static Bitmap decodeSampledBitmapFromFile(Context context, String pathName, int reqWidth, int reqHeight) {
        int degree = 0;
        Uri uri = UriUtils.getImageContentUri(context, pathName);
        ParcelFileDescriptor parcelFileDescriptor = null;
        FileDescriptor fileDescriptor = null;
        try {
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            ExifInterface exifInterface = null;
            exifInterface = VersionUtils.isAndroidQ() ? new ExifInterface(fileDescriptor) : new ExifInterface(pathName);
            int result = exifInterface.getAttributeInt("Orientation", 0);
            switch (result) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            if (VersionUtils.isAndroidQ()) {
                BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            } else {
                BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
            }
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            Bitmap bitmap = null;
            bitmap = VersionUtils.isAndroidQ() ? ImageUtil.getBitmapFromUri(context, uri, options) : BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
            parcelFileDescriptor.close();
            if (degree != 0) {
                Bitmap newBitmap = ImageUtil.rotateImageView(bitmap, degree);
                bitmap.recycle();
                bitmap = null;
                return newBitmap;
            }
            return bitmap;
        }
        catch (OutOfMemoryError error) {
            Log.e((String)"eee", (String)"\u5185\u5b58\u6cc4\u9732\uff01");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Bitmap getBitmapFromUri(Context context, Uri uri) {
        return ImageUtil.getBitmapFromUri(context, uri, null);
    }

    public static Bitmap getBitmapFromUri(Context context, Uri uri, BitmapFactory.Options options) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            Bitmap image = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            parcelFileDescriptor.close();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap rotateImageView(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        if (width > reqWidth && height > reqHeight) {
            int widthRatio = Math.round((float)width / (float)reqWidth);
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = Math.max(widthRatio, heightRatio);
        }
        return inSampleSize;
    }

    public static boolean isEffective(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    public static boolean isEffective(Context context, Uri uri) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCutImage(Context context, String path) {
        return ImageUtil.isCutImage(ImageUtil.getImageCacheDir(context), path);
    }

    public static boolean isCutImage(String dir, String path) {
        if (!StringUtils.isEmptyString(path)) {
            return path.startsWith(dir);
        }
        return false;
    }

    public static void savePicture(final Context context, final Uri uri, final long takeTime) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (ImageUtil.isNeedSavePicture(context, takeTime)) {
                    context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
                }
            }
        }).start();
    }

    private static boolean isNeedSavePicture(Context context, long takeTime) {
        Uri mImageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendQueryParameter("limit", "1").build();
        ContentResolver mContentResolver = context.getContentResolver();
        Cursor mCursor = mContentResolver.query(mImageUri, new String[]{"date_added", "_id", "_size"}, "_size>0", null, "_id DESC");
        if (mCursor != null && mCursor.getCount() > 0 && mCursor.moveToFirst()) {
            long time = mCursor.getLong(mCursor.getColumnIndex("date_added"));
            int id2 = mCursor.getInt(mCursor.getColumnIndex("_id"));
            if (String.valueOf(time).length() < 13) {
                time *= 1000L;
            }
            mCursor.close();
            return time + 1000L < takeTime;
        }
        return true;
    }
}

