/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.utils;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import com.donkingliang.imageselector.ClipImageActivity;
import com.donkingliang.imageselector.ImageSelectorActivity;
import com.donkingliang.imageselector.entry.RequestConfig;
import com.donkingliang.imageselector.model.ImageModel;
import java.util.ArrayList;

public class ImageSelector {
    public static final String SELECT_RESULT = "select_result";
    public static final String IS_CAMERA_IMAGE = "is_camera_image";
    public static final String KEY_CONFIG = "key_config";
    public static final String MAX_SELECT_COUNT = "max_select_count";
    public static final String IS_SINGLE = "is_single";
    public static final String POSITION = "position";
    public static final String IS_CONFIRM = "is_confirm";
    public static final int RESULT_CODE = 18;

    public static void preload(Context context) {
        ImageModel.preloadAndRegisterContentObserver(context);
    }

    public static void clearCache(Context context) {
        ImageModel.clearCache(context);
    }

    public static ImageSelectorBuilder builder() {
        return new ImageSelectorBuilder();
    }

    public static class ImageSelectorBuilder {
        private RequestConfig config = new RequestConfig();

        private ImageSelectorBuilder() {
        }

        public ImageSelectorBuilder setCrop(boolean isCrop) {
            this.config.isCrop = isCrop;
            return this;
        }

        public ImageSelectorBuilder setCropRatio(float ratio) {
            this.config.cropRatio = ratio;
            return this;
        }

        public ImageSelectorBuilder setSingle(boolean isSingle) {
            this.config.isSingle = isSingle;
            return this;
        }

        @Deprecated
        public ImageSelectorBuilder setViewImage(boolean isViewImage) {
            this.config.canPreview = isViewImage;
            return this;
        }

        public ImageSelectorBuilder canPreview(boolean canPreview) {
            this.config.canPreview = canPreview;
            return this;
        }

        public ImageSelectorBuilder useCamera(boolean useCamera) {
            this.config.useCamera = useCamera;
            return this;
        }

        public ImageSelectorBuilder onlyTakePhoto(boolean onlyTakePhoto) {
            this.config.onlyTakePhoto = onlyTakePhoto;
            return this;
        }

        public ImageSelectorBuilder setMaxSelectCount(int maxSelectCount) {
            this.config.maxSelectCount = maxSelectCount;
            return this;
        }

        public ImageSelectorBuilder setSelected(ArrayList<String> selected) {
            this.config.selected = selected;
            return this;
        }

        public void start(Activity activity, int requestCode) {
            this.config.requestCode = requestCode;
            if (this.config.onlyTakePhoto) {
                this.config.useCamera = true;
            }
            if (this.config.isCrop) {
                ClipImageActivity.openActivity(activity, requestCode, this.config);
            } else {
                ImageSelectorActivity.openActivity(activity, requestCode, this.config);
            }
        }

        public void start(androidx.fragment.app.Fragment fragment, int requestCode) {
            this.config.requestCode = requestCode;
            if (this.config.onlyTakePhoto) {
                this.config.useCamera = true;
            }
            if (this.config.isCrop) {
                ClipImageActivity.openActivity(fragment, requestCode, this.config);
            } else {
                ImageSelectorActivity.openActivity(fragment, requestCode, this.config);
            }
        }

        public void start(Fragment fragment, int requestCode) {
            this.config.requestCode = requestCode;
            if (this.config.onlyTakePhoto) {
                this.config.useCamera = true;
            }
            if (this.config.isCrop) {
                ClipImageActivity.openActivity(fragment, requestCode, this.config);
            } else {
                ImageSelectorActivity.openActivity(fragment, requestCode, this.config);
            }
        }
    }
}

