/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.donkingliang.imageselector.R;
import com.donkingliang.imageselector.entry.Folder;
import com.donkingliang.imageselector.entry.Image;
import com.donkingliang.imageselector.utils.VersionUtils;
import java.util.ArrayList;

public class FolderAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private ArrayList<Folder> mFolders;
    private LayoutInflater mInflater;
    private int mSelectItem;
    private OnFolderSelectListener mListener;
    private boolean isAndroidQ = VersionUtils.isAndroidQ();

    public FolderAdapter(Context context, ArrayList<Folder> folders) {
        this.mContext = context;
        this.mFolders = folders;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.mInflater.inflate(R.layout.adapter_folder, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        final Folder folder = this.mFolders.get(position);
        ArrayList<Image> images = folder.getImages();
        holder.tvFolderName.setText((CharSequence)folder.getName());
        holder.ivSelect.setVisibility(this.mSelectItem == position ? 0 : 8);
        if (images != null && !images.isEmpty()) {
            holder.tvFolderSize.setText((CharSequence)this.mContext.getString(R.string.selector_image_num, new Object[]{images.size()}));
            Glide.with((Context)this.mContext).load(this.isAndroidQ ? images.get(0).getUri() : images.get(0).getPath()).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).into(holder.ivImage);
        } else {
            holder.tvFolderSize.setText((CharSequence)this.mContext.getString(R.string.selector_image_num, new Object[]{0}));
            holder.ivImage.setImageBitmap(null);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FolderAdapter.this.mSelectItem = holder.getAdapterPosition();
                FolderAdapter.this.notifyDataSetChanged();
                if (FolderAdapter.this.mListener != null) {
                    FolderAdapter.this.mListener.OnFolderSelect(folder);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mFolders == null ? 0 : this.mFolders.size();
    }

    public void setOnFolderSelectListener(OnFolderSelectListener listener) {
        this.mListener = listener;
    }

    public static interface OnFolderSelectListener {
        public void OnFolderSelect(Folder var1);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivImage;
        ImageView ivSelect;
        TextView tvFolderName;
        TextView tvFolderSize;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivImage = (ImageView)itemView.findViewById(R.id.iv_image);
            this.ivSelect = (ImageView)itemView.findViewById(R.id.iv_select);
            this.tvFolderName = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.tvFolderSize = (TextView)itemView.findViewById(R.id.tv_folder_size);
        }
    }
}

