/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.imageselector;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.os.EnvironmentCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.donkingliang.imageselector.PreviewActivity;
import com.donkingliang.imageselector.R;
import com.donkingliang.imageselector.adapter.FolderAdapter;
import com.donkingliang.imageselector.adapter.ImageAdapter;
import com.donkingliang.imageselector.entry.Folder;
import com.donkingliang.imageselector.entry.Image;
import com.donkingliang.imageselector.entry.RequestConfig;
import com.donkingliang.imageselector.model.ImageModel;
import com.donkingliang.imageselector.utils.DateUtils;
import com.donkingliang.imageselector.utils.ImageUtil;
import com.donkingliang.imageselector.utils.UriUtils;
import com.donkingliang.imageselector.utils.VersionUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class ImageSelectorActivity
extends AppCompatActivity {
    private TextView tvTime;
    private TextView tvFolderName;
    private TextView tvConfirm;
    private TextView tvPreview;
    private FrameLayout btnConfirm;
    private FrameLayout btnPreview;
    private RecyclerView rvImage;
    private RecyclerView rvFolder;
    private View masking;
    private ImageAdapter mAdapter;
    private GridLayoutManager mLayoutManager;
    private ArrayList<Folder> mFolders;
    private Folder mFolder;
    private boolean applyLoadImage = false;
    private boolean applyCamera = false;
    private static final int PERMISSION_WRITE_EXTERNAL_REQUEST_CODE = 17;
    private static final int PERMISSION_CAMERA_REQUEST_CODE = 18;
    private static final int CAMERA_REQUEST_CODE = 16;
    private Uri mCameraUri;
    private String mCameraImagePath;
    private long mTakeTime;
    private boolean isOpenFolder;
    private boolean isShowTime;
    private boolean isInitFolder;
    private boolean isSingle;
    private boolean canPreview = true;
    private int mMaxCount;
    private boolean useCamera = true;
    private boolean onlyTakePhoto = false;
    private Handler mHideHandler = new Handler();
    private Runnable mHide = new Runnable(){

        @Override
        public void run() {
            ImageSelectorActivity.this.hideTime();
        }
    };
    private ArrayList<String> mSelectedImages;

    public static void openActivity(Activity activity, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)activity, ImageSelectorActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void openActivity(androidx.fragment.app.Fragment fragment, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)fragment.getActivity(), ImageSelectorActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void openActivity(Fragment fragment, int requestCode, RequestConfig config) {
        Intent intent = new Intent((Context)fragment.getActivity(), ImageSelectorActivity.class);
        intent.putExtra("key_config", (Parcelable)config);
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        RequestConfig config = (RequestConfig)intent.getParcelableExtra("key_config");
        this.mMaxCount = config.maxSelectCount;
        this.isSingle = config.isSingle;
        this.canPreview = config.canPreview;
        this.useCamera = config.useCamera;
        this.mSelectedImages = config.selected;
        this.onlyTakePhoto = config.onlyTakePhoto;
        if (this.onlyTakePhoto) {
            this.checkPermissionAndCamera();
        } else {
            this.setContentView(R.layout.activity_image_select);
            this.setStatusBarColor();
            this.initView();
            this.initListener();
            this.initImageList();
            this.checkPermissionAndLoadImages();
            this.hideFolderList();
            this.setSelectImageCount(0);
        }
    }

    private void setStatusBarColor() {
        if (VersionUtils.isAndroidL()) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#373c3d"));
        }
    }

    private void initView() {
        this.rvImage = (RecyclerView)this.findViewById(R.id.rv_image);
        this.rvFolder = (RecyclerView)this.findViewById(R.id.rv_folder);
        this.tvConfirm = (TextView)this.findViewById(R.id.tv_confirm);
        this.tvPreview = (TextView)this.findViewById(R.id.tv_preview);
        this.btnConfirm = (FrameLayout)this.findViewById(R.id.btn_confirm);
        this.btnPreview = (FrameLayout)this.findViewById(R.id.btn_preview);
        this.tvFolderName = (TextView)this.findViewById(R.id.tv_folder_name);
        this.tvTime = (TextView)this.findViewById(R.id.tv_time);
        this.masking = this.findViewById(R.id.masking);
    }

    private void initListener() {
        this.findViewById(R.id.btn_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSelectorActivity.this.finish();
            }
        });
        this.btnPreview.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList<Image> images = new ArrayList<Image>();
                images.addAll(ImageSelectorActivity.this.mAdapter.getSelectImages());
                ImageSelectorActivity.this.toPreviewActivity(images, 0);
            }
        });
        this.btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSelectorActivity.this.confirm();
            }
        });
        this.findViewById(R.id.btn_folder).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageSelectorActivity.this.isInitFolder) {
                    if (ImageSelectorActivity.this.isOpenFolder) {
                        ImageSelectorActivity.this.closeFolder();
                    } else {
                        ImageSelectorActivity.this.openFolder();
                    }
                }
            }
        });
        this.masking.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSelectorActivity.this.closeFolder();
            }
        });
        this.rvImage.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                ImageSelectorActivity.this.changeTime();
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                ImageSelectorActivity.this.changeTime();
            }
        });
    }

    private void initImageList() {
        Configuration configuration = this.getResources().getConfiguration();
        this.mLayoutManager = configuration.orientation == 1 ? new GridLayoutManager((Context)this, 3) : new GridLayoutManager((Context)this, 5);
        this.rvImage.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mAdapter = new ImageAdapter((Context)this, this.mMaxCount, this.isSingle, this.canPreview);
        this.rvImage.setAdapter((RecyclerView.Adapter)this.mAdapter);
        ((SimpleItemAnimator)this.rvImage.getItemAnimator()).setSupportsChangeAnimations(false);
        if (this.mFolders != null && !this.mFolders.isEmpty()) {
            this.setFolder(this.mFolders.get(0));
        }
        this.mAdapter.setOnImageSelectListener(new ImageAdapter.OnImageSelectListener(){

            @Override
            public void OnImageSelect(Image image, boolean isSelect, int selectCount) {
                ImageSelectorActivity.this.setSelectImageCount(selectCount);
            }
        });
        this.mAdapter.setOnItemClickListener(new ImageAdapter.OnItemClickListener(){

            @Override
            public void OnItemClick(Image image, int position) {
                ImageSelectorActivity.this.toPreviewActivity(ImageSelectorActivity.this.mAdapter.getData(), position);
            }

            @Override
            public void OnCameraClick() {
                ImageSelectorActivity.this.checkPermissionAndCamera();
            }
        });
    }

    private void initFolderList() {
        if (this.mFolders != null && !this.mFolders.isEmpty()) {
            this.isInitFolder = true;
            this.rvFolder.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            FolderAdapter adapter = new FolderAdapter((Context)this, this.mFolders);
            adapter.setOnFolderSelectListener(new FolderAdapter.OnFolderSelectListener(){

                @Override
                public void OnFolderSelect(Folder folder) {
                    ImageSelectorActivity.this.setFolder(folder);
                    ImageSelectorActivity.this.closeFolder();
                }
            });
            this.rvFolder.setAdapter((RecyclerView.Adapter)adapter);
        }
    }

    private void hideFolderList() {
        this.rvFolder.post(new Runnable(){

            @Override
            public void run() {
                ImageSelectorActivity.this.rvFolder.setTranslationY((float)ImageSelectorActivity.this.rvFolder.getHeight());
                ImageSelectorActivity.this.rvFolder.setVisibility(8);
                ImageSelectorActivity.this.rvFolder.setBackgroundColor(-1);
            }
        });
    }

    private void setFolder(Folder folder) {
        if (folder != null && this.mAdapter != null && !folder.equals(this.mFolder)) {
            this.mFolder = folder;
            this.tvFolderName.setText((CharSequence)folder.getName());
            this.rvImage.scrollToPosition(0);
            this.mAdapter.refresh(folder.getImages(), folder.isUseCamera());
        }
    }

    private void setSelectImageCount(int count) {
        if (count == 0) {
            this.btnConfirm.setEnabled(false);
            this.btnPreview.setEnabled(false);
            this.tvConfirm.setText(R.string.selector_send);
            this.tvPreview.setText(R.string.selector_preview);
        } else {
            this.btnConfirm.setEnabled(true);
            this.btnPreview.setEnabled(true);
            this.tvPreview.setText((CharSequence)(this.getString(R.string.selector_preview) + "(" + count + ")"));
            if (this.isSingle) {
                this.tvConfirm.setText(R.string.selector_send);
            } else if (this.mMaxCount > 0) {
                this.tvConfirm.setText((CharSequence)(this.getString(R.string.selector_send) + "(" + count + "/" + this.mMaxCount + ")"));
            } else {
                this.tvConfirm.setText((CharSequence)(this.getString(R.string.selector_send) + "(" + count + ")"));
            }
        }
    }

    private void openFolder() {
        if (!this.isOpenFolder) {
            this.masking.setVisibility(0);
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.rvFolder, (String)"translationY", (float[])new float[]{this.rvFolder.getHeight(), 0.0f}).setDuration(300L);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    ImageSelectorActivity.this.rvFolder.setVisibility(0);
                }
            });
            animator.start();
            this.isOpenFolder = true;
        }
    }

    private void closeFolder() {
        if (this.isOpenFolder) {
            this.masking.setVisibility(8);
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.rvFolder, (String)"translationY", (float[])new float[]{0.0f, this.rvFolder.getHeight()}).setDuration(300L);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ImageSelectorActivity.this.rvFolder.setVisibility(8);
                }
            });
            animator.start();
            this.isOpenFolder = false;
        }
    }

    private void hideTime() {
        if (this.isShowTime) {
            ObjectAnimator.ofFloat((Object)this.tvTime, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(300L).start();
            this.isShowTime = false;
        }
    }

    private void showTime() {
        if (!this.isShowTime) {
            ObjectAnimator.ofFloat((Object)this.tvTime, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(300L).start();
            this.isShowTime = true;
        }
    }

    private void changeTime() {
        int firstVisibleItem = this.getFirstVisibleItem();
        Image image = this.mAdapter.getFirstVisibleImage(firstVisibleItem);
        if (image != null) {
            String time = DateUtils.getImageTime((Context)this, image.getTime());
            this.tvTime.setText((CharSequence)time);
            this.showTime();
            this.mHideHandler.removeCallbacks(this.mHide);
            this.mHideHandler.postDelayed(this.mHide, 1500L);
        }
    }

    private int getFirstVisibleItem() {
        return this.mLayoutManager.findFirstVisibleItemPosition();
    }

    private void confirm() {
        if (this.mAdapter == null) {
            return;
        }
        ArrayList<Image> selectImages = this.mAdapter.getSelectImages();
        ArrayList<String> images = new ArrayList<String>();
        for (Image image : selectImages) {
            images.add(image.getPath());
        }
        this.saveImageAndFinish(images, false);
    }

    private void saveImageAndFinish(ArrayList<String> images, boolean isCameraImage) {
        this.setResult(images, isCameraImage);
        this.finish();
    }

    private void setResult(ArrayList<String> images, boolean isCameraImage) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra("select_result", images);
        intent.putExtra("is_camera_image", isCameraImage);
        this.setResult(-1, intent);
    }

    private void toPreviewActivity(ArrayList<Image> images, int position) {
        if (images != null && !images.isEmpty()) {
            PreviewActivity.openActivity((Activity)this, images, this.mAdapter.getSelectImages(), this.isSingle, this.mMaxCount, position);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.applyLoadImage) {
            this.applyLoadImage = false;
            this.checkPermissionAndLoadImages();
        }
        if (this.applyCamera) {
            this.applyCamera = false;
            this.checkPermissionAndCamera();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 18) {
            if (data != null && data.getBooleanExtra("is_confirm", false)) {
                this.confirm();
            } else {
                this.mAdapter.notifyDataSetChanged();
                this.setSelectImageCount(this.mAdapter.getSelectImages().size());
            }
        } else if (requestCode == 16) {
            if (resultCode == -1) {
                ArrayList<String> images = new ArrayList<String>();
                Uri savePictureUri = null;
                if (VersionUtils.isAndroidQ()) {
                    savePictureUri = this.mCameraUri;
                    images.add(UriUtils.getPathForUri((Context)this, this.mCameraUri));
                } else {
                    savePictureUri = Uri.fromFile((File)new File(this.mCameraImagePath));
                    images.add(this.mCameraImagePath);
                }
                ImageUtil.savePicture((Context)this, savePictureUri, this.mTakeTime);
                this.saveImageAndFinish(images, true);
            } else if (this.onlyTakePhoto) {
                this.finish();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mLayoutManager != null && this.mAdapter != null) {
            if (newConfig.orientation == 1) {
                this.mLayoutManager.setSpanCount(3);
            } else if (newConfig.orientation == 2) {
                this.mLayoutManager.setSpanCount(5);
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void checkPermissionAndLoadImages() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (hasWriteExternalPermission == 0) {
            this.loadImageForSDCard();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)17);
        }
    }

    private void checkPermissionAndCamera() {
        int hasCameraPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA");
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (hasCameraPermission == 0 && hasWriteExternalPermission == 0) {
            this.openCamera();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)18);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 17) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.loadImageForSDCard();
            } else {
                this.showExceptionDialog(true);
            }
        } else if (requestCode == 18) {
            if (grantResults.length > 1 && grantResults[0] == 0 && grantResults[1] == 0) {
                this.openCamera();
            } else {
                this.showExceptionDialog(false);
            }
        }
    }

    private void showExceptionDialog(final boolean applyLoad) {
        new AlertDialog.Builder((Context)this).setCancelable(false).setTitle(R.string.selector_hint).setMessage(R.string.selector_permissions_hint).setNegativeButton(R.string.selector_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                ImageSelectorActivity.this.finish();
            }
        }).setPositiveButton(R.string.selector_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                ImageSelectorActivity.this.startAppSettings();
                if (applyLoad) {
                    ImageSelectorActivity.this.applyLoadImage = true;
                } else {
                    ImageSelectorActivity.this.applyCamera = true;
                }
            }
        }).show();
    }

    private void loadImageForSDCard() {
        ImageModel.loadImageForSDCard((Context)this, new ImageModel.DataCallback(){

            @Override
            public void onSuccess(ArrayList<Folder> folders) {
                ImageSelectorActivity.this.mFolders = folders;
                ImageSelectorActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ImageSelectorActivity.this.mFolders != null && !ImageSelectorActivity.this.mFolders.isEmpty()) {
                            ImageSelectorActivity.this.initFolderList();
                            ((Folder)ImageSelectorActivity.this.mFolders.get(0)).setUseCamera(ImageSelectorActivity.this.useCamera);
                            ImageSelectorActivity.this.setFolder((Folder)ImageSelectorActivity.this.mFolders.get(0));
                            if (ImageSelectorActivity.this.mSelectedImages != null && ImageSelectorActivity.this.mAdapter != null) {
                                ImageSelectorActivity.this.mAdapter.setSelectedImages(ImageSelectorActivity.this.mSelectedImages);
                                ImageSelectorActivity.this.mSelectedImages = null;
                                ImageSelectorActivity.this.setSelectImageCount(ImageSelectorActivity.this.mAdapter.getSelectImages().size());
                            }
                        }
                    }
                });
            }
        });
    }

    private void openCamera() {
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (captureIntent.resolveActivity(this.getPackageManager()) != null) {
            File photoFile = null;
            Uri photoUri = null;
            if (VersionUtils.isAndroidQ()) {
                photoUri = this.createImagePathUri();
            } else {
                try {
                    photoFile = this.createImageFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (photoFile != null) {
                    this.mCameraImagePath = photoFile.getAbsolutePath();
                    photoUri = VersionUtils.isAndroidN() ? FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + ".imageSelectorProvider"), (File)photoFile) : Uri.fromFile((File)photoFile);
                }
            }
            this.mCameraUri = photoUri;
            if (photoUri != null) {
                captureIntent.putExtra("output", (Parcelable)photoUri);
                captureIntent.addFlags(2);
                this.startActivityForResult(captureIntent, 16);
                this.mTakeTime = System.currentTimeMillis();
            }
        }
    }

    public Uri createImagePathUri() {
        String status = Environment.getExternalStorageState();
        SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
        long time = System.currentTimeMillis();
        String imageName = timeFormatter.format(new Date(time));
        ContentValues values = new ContentValues(2);
        values.put("_display_name", imageName);
        values.put("mime_type", "image/jpeg");
        if (status.equals("mounted")) {
            return this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return this.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
    }

    private File createImageFile() throws IOException {
        File tempFile;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String imageFileName = String.format("JPEG_%s.jpg", timeStamp);
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists()) {
            storageDir.mkdir();
        }
        if (!"mounted".equals(EnvironmentCompat.getStorageState((File)(tempFile = new File(storageDir, imageFileName))))) {
            return null;
        }
        return tempFile;
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 0 && this.isOpenFolder) {
            this.closeFolder();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

