/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.consecutivescroller;

import android.view.animation.Interpolator;

public class OverScrollInterpolator
implements Interpolator {
    public static int INTERPOLATOR_VISCOUS_FLUID = 0;
    public static int INTERPOLATOR_DECELERATE = 1;
    private int type;
    private static final float VISCOUS_FLUID_SCALE = 8.0f;
    private static final float VISCOUS_FLUID_NORMALIZE = 1.0f / OverScrollInterpolator.viscousFluid(1.0f);
    private static final float VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * OverScrollInterpolator.viscousFluid(1.0f);

    public OverScrollInterpolator(int type) {
        this.type = type;
    }

    private static float viscousFluid(float x) {
        if ((x *= 8.0f) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            float start = 0.36787945f;
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = start + x * (1.0f - start);
        }
        return x;
    }

    public float getInterpolation(float input) {
        if (this.type == INTERPOLATOR_DECELERATE) {
            return 1.0f - (1.0f - input) * (1.0f - input);
        }
        float interpolated = VISCOUS_FLUID_NORMALIZE * OverScrollInterpolator.viscousFluid(input);
        if (interpolated > 0.0f) {
            return interpolated + VISCOUS_FLUID_OFFSET;
        }
        return interpolated;
    }
}

