/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.consecutivescroller;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.donkingliang.consecutivescroller.ConsecutiveScrollerLayout;
import com.donkingliang.consecutivescroller.IConsecutiveScroller;
import com.donkingliang.consecutivescroller.ScrollUtils;
import java.util.ArrayList;
import java.util.List;

public class ConsecutiveViewPager
extends ViewPager
implements IConsecutiveScroller {
    private int mAdjustHeight;

    public ConsecutiveViewPager(@NonNull Context context) {
        super(context);
    }

    public ConsecutiveViewPager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isConsecutiveParentAndBottom() && this.mAdjustHeight > 0) {
            int height = ConsecutiveViewPager.getDefaultSize((int)0, (int)heightMeasureSpec) - this.mAdjustHeight;
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)View.MeasureSpec.getMode((int)heightMeasureSpec)));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (ScrollUtils.isConsecutiveScrollerChild((View)this)) {
            this.disableChildScroll(child);
            if (child instanceof ViewGroup) {
                ((ViewGroup)child).setClipToPadding(false);
            }
        }
    }

    private void disableChildScroll(View child) {
        child.setVerticalScrollBarEnabled(false);
        child.setHorizontalScrollBarEnabled(false);
        child.setOverScrollMode(2);
        ViewCompat.setNestedScrollingEnabled((View)child, (boolean)false);
    }

    private boolean isConsecutiveParentAndBottom() {
        ViewParent parent = this.getParent();
        if (parent instanceof ConsecutiveScrollerLayout) {
            ConsecutiveScrollerLayout layout = (ConsecutiveScrollerLayout)parent;
            return layout.indexOfChild((View)this) == layout.getChildCount() - 1;
        }
        return false;
    }

    public int getAdjustHeight() {
        return this.mAdjustHeight;
    }

    public void setAdjustHeight(int adjustHeight) {
        if (this.mAdjustHeight != adjustHeight) {
            this.mAdjustHeight = adjustHeight;
            this.requestLayout();
        }
    }

    @Override
    public View getCurrentScrollerView() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (view.getX() != (float)(this.getScrollX() + this.getPaddingLeft())) continue;
            return view;
        }
        return this;
    }

    @Override
    public List<View> getScrolledViews() {
        ArrayList<View> views = new ArrayList<View>();
        int count = this.getChildCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                views.add(this.getChildAt(i));
            }
        }
        return views;
    }
}

