/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.consecutivescroller;

import android.graphics.Rect;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.donkingliang.consecutivescroller.ConsecutiveScrollerLayout;
import com.donkingliang.consecutivescroller.IConsecutiveScroller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ScrollUtils {
    static Method computeVerticalScrollOffsetMethod;
    static Method computeVerticalScrollRangeMethod;
    static Method computeVerticalScrollExtentMethod;
    private static final Rect mBounds;

    static int computeVerticalScrollOffset(View view) {
        View scrolledView = ScrollUtils.getScrolledView(view);
        if (scrolledView instanceof ScrollingView) {
            return ((ScrollingView)scrolledView).computeVerticalScrollOffset();
        }
        try {
            Object o;
            if (computeVerticalScrollOffsetMethod == null) {
                computeVerticalScrollOffsetMethod = View.class.getDeclaredMethod("computeVerticalScrollOffset", new Class[0]);
                computeVerticalScrollOffsetMethod.setAccessible(true);
            }
            if ((o = computeVerticalScrollOffsetMethod.invoke((Object)scrolledView, new Object[0])) != null) {
                return (Integer)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scrolledView.getScrollY();
    }

    static int computeVerticalScrollRange(View view) {
        View scrolledView = ScrollUtils.getScrolledView(view);
        if (scrolledView instanceof ScrollingView) {
            return ((ScrollingView)scrolledView).computeVerticalScrollRange();
        }
        try {
            Object o;
            if (computeVerticalScrollRangeMethod == null) {
                computeVerticalScrollRangeMethod = View.class.getDeclaredMethod("computeVerticalScrollRange", new Class[0]);
                computeVerticalScrollRangeMethod.setAccessible(true);
            }
            if ((o = computeVerticalScrollRangeMethod.invoke((Object)scrolledView, new Object[0])) != null) {
                return (Integer)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scrolledView.getHeight();
    }

    static int computeVerticalScrollExtent(View view) {
        View scrolledView = ScrollUtils.getScrolledView(view);
        if (scrolledView instanceof ScrollingView) {
            return ((ScrollingView)scrolledView).computeVerticalScrollExtent();
        }
        try {
            Object o;
            if (computeVerticalScrollExtentMethod == null) {
                computeVerticalScrollExtentMethod = View.class.getDeclaredMethod("computeVerticalScrollExtent", new Class[0]);
                computeVerticalScrollExtentMethod.setAccessible(true);
            }
            if ((o = computeVerticalScrollExtentMethod.invoke((Object)scrolledView, new Object[0])) != null) {
                return (Integer)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scrolledView.getHeight();
    }

    static int getScrollTopOffset(View view) {
        if (ScrollUtils.isConsecutiveScrollerChild(view) && ScrollUtils.canScrollVertically(view, -1)) {
            return Math.min(-ScrollUtils.computeVerticalScrollOffset(view), -1);
        }
        return 0;
    }

    static int getScrollBottomOffset(View view) {
        if (ScrollUtils.isConsecutiveScrollerChild(view) && ScrollUtils.canScrollVertically(view, 1)) {
            return Math.max(ScrollUtils.computeVerticalScrollRange(view) - ScrollUtils.computeVerticalScrollOffset(view) - ScrollUtils.computeVerticalScrollExtent(view), 1);
        }
        return 0;
    }

    static boolean canScrollHorizontally(View view) {
        return ScrollUtils.isConsecutiveScrollerChild(view) && (view.canScrollHorizontally(1) || view.canScrollHorizontally(-1));
    }

    static boolean canScrollVertically(View view) {
        return ScrollUtils.isConsecutiveScrollerChild(view) && (ScrollUtils.canScrollVertically(view, 1) || ScrollUtils.canScrollVertically(view, -1));
    }

    static boolean canScrollVertically(View view, int direction) {
        View scrolledView = ScrollUtils.getScrolledView(view);
        if (scrolledView.getVisibility() == 8) {
            return false;
        }
        if (scrolledView instanceof AbsListView) {
            AbsListView listView = (AbsListView)scrolledView;
            if (Build.VERSION.SDK_INT >= 19) {
                return listView.canScrollList(direction);
            }
            return false;
        }
        if (scrolledView instanceof RecyclerView) {
            View child;
            int i;
            RecyclerView recyclerView = (RecyclerView)scrolledView;
            if ((recyclerView.canScrollHorizontally(1) || recyclerView.canScrollHorizontally(-1)) && !recyclerView.canScrollVertically(direction)) {
                return false;
            }
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            if (layoutManager != null && adapter != null && adapter.getItemCount() > 0) {
                boolean isReverseLayout = false;
                if (layoutManager instanceof LinearLayoutManager) {
                    isReverseLayout = ((LinearLayoutManager)layoutManager).getReverseLayout();
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    isReverseLayout = ((StaggeredGridLayoutManager)layoutManager).getReverseLayout();
                }
                int targetPosition = 0;
                targetPosition = isReverseLayout ? (direction < 0 ? adapter.getItemCount() - 1 : 0) : (direction > 0 ? adapter.getItemCount() - 1 : 0);
                View itemView = layoutManager.findViewByPosition(targetPosition);
                if (itemView == null) {
                    return true;
                }
            } else {
                return false;
            }
            int count = recyclerView.getChildCount();
            if (direction > 0) {
                for (i = count - 1; i >= 0; --i) {
                    child = recyclerView.getChildAt(i);
                    recyclerView.getDecoratedBoundsWithMargins(child, mBounds);
                    if (ScrollUtils.mBounds.bottom <= recyclerView.getHeight() - recyclerView.getPaddingBottom()) continue;
                    return true;
                }
                return false;
            }
            for (i = 0; i < count; ++i) {
                child = recyclerView.getChildAt(i);
                recyclerView.getDecoratedBoundsWithMargins(child, mBounds);
                if (ScrollUtils.mBounds.top >= recyclerView.getPaddingTop()) continue;
                return true;
            }
            return false;
        }
        return scrolledView.canScrollVertically(direction);
    }

    static List<View> getTouchViews(View rootView, int touchX, int touchY) {
        ArrayList<View> views = new ArrayList<View>();
        ScrollUtils.addTouchViews(views, rootView, touchX, touchY);
        return views;
    }

    private static void addTouchViews(List<View> views, View view, int touchX, int touchY) {
        if (ScrollUtils.isConsecutiveScrollerChild(view) && ScrollUtils.isTouchPointInView(view, touchX, touchY)) {
            views.add(view);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    ScrollUtils.addTouchViews(views, viewGroup.getChildAt(i), touchX, touchY);
                }
            }
        }
    }

    static boolean isTouchPointInView(View view, int x, int y) {
        if (view == null) {
            return false;
        }
        int[] position = new int[2];
        view.getLocationOnScreen(position);
        int left = position[0];
        int top = position[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return x >= left && x <= right && y >= top && y <= bottom;
    }

    static int getRawX(View rootView, MotionEvent ev, int pointerIndex) {
        if (Build.VERSION.SDK_INT >= 29) {
            return (int)ev.getRawX(pointerIndex);
        }
        int[] position = new int[2];
        rootView.getLocationOnScreen(position);
        int left = position[0];
        return (int)((float)left + ev.getX(pointerIndex));
    }

    static int getRawY(View rootView, MotionEvent ev, int pointerIndex) {
        if (Build.VERSION.SDK_INT >= 29) {
            return (int)ev.getRawY(pointerIndex);
        }
        int[] position = new int[2];
        rootView.getLocationOnScreen(position);
        int top = position[1];
        return (int)((float)top + ev.getY(pointerIndex));
    }

    static List<Integer> getScrollOffsetForViews(List<View> views) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (View view : views) {
            offsets.add(ScrollUtils.computeVerticalScrollOffset(view));
        }
        return offsets;
    }

    static boolean equalsOffsets(List<Integer> offsets1, List<Integer> offsets2) {
        if (offsets1.size() != offsets2.size()) {
            return false;
        }
        int size = offsets1.size();
        for (int i = 0; i < size; ++i) {
            if (offsets1.get(i).equals(offsets2.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isConsecutiveScrollerChild(View view) {
        if (view != null) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof ConsecutiveScrollerLayout.LayoutParams) {
                return ((ConsecutiveScrollerLayout.LayoutParams)lp).isConsecutive;
            }
            return true;
        }
        return false;
    }

    static View getScrolledView(View view) {
        View consecutiveView = null;
        View scrolledView = ScrollUtils.getScrollChild(view);
        while (scrolledView instanceof IConsecutiveScroller && (consecutiveView = scrolledView) != (scrolledView = ((IConsecutiveScroller)scrolledView).getCurrentScrollerView())) {
        }
        return scrolledView;
    }

    static View getScrollChild(View view) {
        View child;
        int childId;
        ViewGroup.LayoutParams lp;
        if (view != null && (lp = view.getLayoutParams()) instanceof ConsecutiveScrollerLayout.LayoutParams && (childId = ((ConsecutiveScrollerLayout.LayoutParams)lp).scrollChild) != -1 && (child = view.findViewById(childId)) != null) {
            return child;
        }
        return view;
    }

    static boolean startInterceptRequestLayout(RecyclerView view) {
        if ("InterceptRequestLayout".equals(view.getTag())) {
            try {
                Method method = RecyclerView.class.getDeclaredMethod("startInterceptRequestLayout", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)view, new Object[0]);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static void stopInterceptRequestLayout(RecyclerView view) {
        if ("InterceptRequestLayout".equals(view.getTag())) {
            try {
                Method method = RecyclerView.class.getDeclaredMethod("stopInterceptRequestLayout", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)view, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isConsecutiveScrollParent(View view) {
        View child = view;
        while (child.getParent() instanceof ViewGroup && !(child.getParent() instanceof ConsecutiveScrollerLayout)) {
            child = (View)child.getParent();
        }
        if (child.getParent() instanceof ConsecutiveScrollerLayout) {
            return ScrollUtils.isConsecutiveScrollerChild(child);
        }
        return false;
    }

    static boolean isHorizontalScroll(View rootView, int touchX, int touchY) {
        List<View> views = ScrollUtils.getTouchViews(rootView, touchX, touchY);
        for (View view : views) {
            if (!view.canScrollHorizontally(1) && !view.canScrollHorizontally(-1)) continue;
            return true;
        }
        return false;
    }

    static boolean isTouchNotTriggerScrollStick(View rootView, int touchX, int touchY) {
        List<ConsecutiveScrollerLayout> csLayouts = ScrollUtils.getInTouchCSLayout(rootView, touchX, touchY);
        int size = csLayouts.size();
        for (int i = size - 1; i >= 0; --i) {
            ConsecutiveScrollerLayout csl = csLayouts.get(i);
            View topView = ScrollUtils.getTopViewInTouch(csl, touchX, touchY);
            if (topView == null || !csl.isStickyView(topView) || !csl.theChildIsStick(topView)) continue;
            ConsecutiveScrollerLayout.LayoutParams lp = (ConsecutiveScrollerLayout.LayoutParams)topView.getLayoutParams();
            if (lp.isTriggerScroll) continue;
            return true;
        }
        return false;
    }

    static List<ConsecutiveScrollerLayout> getInTouchCSLayout(View rootView, int touchX, int touchY) {
        ArrayList<ConsecutiveScrollerLayout> csLayouts = new ArrayList<ConsecutiveScrollerLayout>();
        List<View> views = ScrollUtils.getTouchViews(rootView, touchX, touchY);
        for (View view : views) {
            if (!(view instanceof ConsecutiveScrollerLayout)) continue;
            csLayouts.add((ConsecutiveScrollerLayout)view);
        }
        return csLayouts;
    }

    static View getTopViewInTouch(ConsecutiveScrollerLayout csl, int touchX, int touchY) {
        int count = csl.getChildCount();
        View topTouchView = null;
        for (int i = 0; i < count; ++i) {
            View child = csl.getChildAt(i);
            if (child.getVisibility() != 0 || !ScrollUtils.isTouchPointInView(child, touchX, touchY)) continue;
            if (topTouchView == null) {
                topTouchView = child;
                continue;
            }
            if (!(ViewCompat.getZ((View)child) > ViewCompat.getZ((View)topTouchView)) && (ViewCompat.getZ((View)child) != ViewCompat.getZ((View)topTouchView) || csl.getDrawingPosition(child) <= csl.getDrawingPosition(topTouchView))) continue;
            topTouchView = child;
        }
        return topTouchView;
    }

    static {
        mBounds = new Rect();
    }
}

