/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.consecutivescroller;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import com.donkingliang.consecutivescroller.ConsecutiveScrollerLayout;
import com.donkingliang.consecutivescroller.IConsecutiveScroller;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ConsecutiveViewPager2
extends FrameLayout
implements IConsecutiveScroller {
    protected ViewPager2 mViewPager2;
    protected RecyclerView mRecyclerView;
    private int mAdjustHeight;
    private static final int TAG_KEY = -123;

    public ConsecutiveViewPager2(@NonNull Context context) {
        super(context);
        this.initialize(context);
    }

    public ConsecutiveViewPager2(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public ConsecutiveViewPager2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mViewPager2 = new ViewPager2(context);
        this.addView((View)this.mViewPager2, -1, -1);
        this.mRecyclerView = (RecyclerView)this.mViewPager2.getChildAt(0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isConsecutiveParentAndBottom() && this.mAdjustHeight > 0) {
            int height = ConsecutiveViewPager2.getDefaultSize((int)0, (int)heightMeasureSpec) - this.mAdjustHeight;
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)View.MeasureSpec.getMode((int)heightMeasureSpec)));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean isConsecutiveParentAndBottom() {
        ViewParent parent = this.getParent();
        if (parent instanceof ConsecutiveScrollerLayout) {
            ConsecutiveScrollerLayout layout = (ConsecutiveScrollerLayout)parent;
            return layout.indexOfChild((View)this) == layout.getChildCount() - 1;
        }
        return false;
    }

    public int getAdjustHeight() {
        return this.mAdjustHeight;
    }

    public void setAdjustHeight(int adjustHeight) {
        if (this.mAdjustHeight != adjustHeight) {
            this.mAdjustHeight = adjustHeight;
            this.requestLayout();
        }
    }

    @Override
    public View getCurrentScrollerView() {
        View itemView;
        RecyclerView scrollerView = null;
        int currentItem = this.getCurrentItem();
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (adapter != null && layoutManager != null && currentItem >= 0 && currentItem < adapter.getItemCount() && (scrollerView = this.findScrolledItemView(itemView = layoutManager.findViewByPosition(currentItem))) != null) {
            this.setAttachListener((View)scrollerView);
        }
        if (scrollerView == null) {
            scrollerView = this.mRecyclerView;
        }
        return scrollerView;
    }

    private void setAttachListener(View scrollerView) {
        ViewGroup.LayoutParams lp;
        if (scrollerView.getTag(-123) != null) {
            AttachListener listener = (AttachListener)scrollerView.getTag(-123);
            if (listener.reference.get() == null) {
                scrollerView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
                scrollerView.setTag(-123, null);
            }
        }
        if (scrollerView.getTag(-123) == null && (lp = this.getLayoutParams()) instanceof ConsecutiveScrollerLayout.LayoutParams && ((ConsecutiveScrollerLayout.LayoutParams)lp).isConsecutive) {
            AttachListener l = new AttachListener(this, scrollerView);
            scrollerView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)l);
            scrollerView.setTag(-123, (Object)l);
        }
    }

    private void scrollChildContent(View v) {
        if (v != null && this.getParent() instanceof ConsecutiveScrollerLayout) {
            ConsecutiveScrollerLayout parent = (ConsecutiveScrollerLayout)this.getParent();
            int thisIndex = parent.indexOfChild((View)this);
            if (thisIndex == parent.getChildCount() - 1 && this.getHeight() < parent.getHeight() && parent.getScrollY() >= parent.mScrollRange) {
                return;
            }
            View firstVisibleView = parent.findFirstVisibleView();
            if (firstVisibleView == null) {
                return;
            }
            int firstIndex = parent.indexOfChild(firstVisibleView);
            if (thisIndex < firstIndex) {
                parent.scrollChildContentToBottom(v);
            } else if (thisIndex > firstIndex) {
                parent.scrollChildContentToTop(v);
            }
        }
    }

    @Override
    public List<View> getScrolledViews() {
        ArrayList<View> views = new ArrayList<View>();
        int count = this.mRecyclerView.getChildCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                views.add(this.findScrolledItemView(this.mRecyclerView.getChildAt(i)));
            }
        }
        return views;
    }

    protected View findScrolledItemView(View view) {
        FrameLayout frameLayout;
        if (this.mRecyclerView.getAdapter() instanceof FragmentStateAdapter && view instanceof FrameLayout && (frameLayout = (FrameLayout)view).getChildCount() > 0) {
            return frameLayout.getChildAt(0);
        }
        return view;
    }

    public ViewPager2 getViewPager2() {
        return this.mViewPager2;
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        this.mViewPager2.setAdapter(adapter);
    }

    @Nullable
    public RecyclerView.Adapter getAdapter() {
        return this.mViewPager2.getAdapter();
    }

    public void setOrientation(int orientation) {
        this.mViewPager2.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.mViewPager2.getOrientation();
    }

    public void setCurrentItem(int item) {
        this.mViewPager2.setCurrentItem(item);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mViewPager2.setCurrentItem(item, smoothScroll);
    }

    public int getCurrentItem() {
        return this.mViewPager2.getCurrentItem();
    }

    public void setOffscreenPageLimit(int limit) {
        this.mViewPager2.setOffscreenPageLimit(limit);
    }

    public int getOffscreenPageLimit() {
        return this.mViewPager2.getOffscreenPageLimit();
    }

    public void registerOnPageChangeCallback(@NonNull ViewPager2.OnPageChangeCallback callback) {
        this.mViewPager2.registerOnPageChangeCallback(callback);
    }

    public void unregisterOnPageChangeCallback(@NonNull ViewPager2.OnPageChangeCallback callback) {
        this.mViewPager2.unregisterOnPageChangeCallback(callback);
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mViewPager2.canScrollHorizontally(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.mViewPager2.canScrollVertically(direction);
    }

    private static class AttachListener
    implements View.OnAttachStateChangeListener {
        WeakReference<ConsecutiveViewPager2> reference;
        View view;

        public AttachListener(ConsecutiveViewPager2 parent, View view) {
            this.reference = new WeakReference<ConsecutiveViewPager2>(parent);
            this.view = view;
        }

        public void onViewAttachedToWindow(View v) {
            if (this.reference.get() != null) {
                ((ConsecutiveViewPager2)this.reference.get()).scrollChildContent(this.view);
            }
        }

        public void onViewDetachedFromWindow(View v) {
        }
    }
}

