/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.entity.PhotoDirectory;
import java.util.ArrayList;
import java.util.List;

public class PopupDirectoryListAdapter
extends BaseAdapter {
    private Context context;
    private List<PhotoDirectory> directories = new ArrayList<PhotoDirectory>();
    private LayoutInflater mLayoutInflater;

    public PopupDirectoryListAdapter(Context context, List<PhotoDirectory> directories) {
        this.context = context;
        this.directories = directories;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.directories.size();
    }

    public PhotoDirectory getItem(int position) {
        return this.directories.get(position);
    }

    public long getItemId(int position) {
        return this.directories.get(position).hashCode();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = this.mLayoutInflater.inflate(R.layout.util_item_directory, parent, false);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.bindData(this.directories.get(position));
        return convertView;
    }

    private class ViewHolder {
        public ImageView ivCover;
        public TextView tvName;
        public TextView tvCount;

        public ViewHolder(View rootView) {
            this.ivCover = (ImageView)rootView.findViewById(R.id.iv_dir_cover);
            this.tvName = (TextView)rootView.findViewById(R.id.tv_dir_name);
            this.tvCount = (TextView)rootView.findViewById(R.id.tv_dir_count);
        }

        public void bindData(PhotoDirectory directory) {
            if (PopupDirectoryListAdapter.this.context instanceof Activity && ((Activity)PopupDirectoryListAdapter.this.context).isFinishing()) {
                return;
            }
            Glide.with((Context)PopupDirectoryListAdapter.this.context).load(directory.getCoverPath()).thumbnail(0.1f).into(this.ivCover);
            this.tvName.setText((CharSequence)directory.getName());
            this.tvCount.setText((CharSequence)PopupDirectoryListAdapter.this.context.getString(R.string.y_photopicker_image_count, new Object[]{directory.getPhotos().size()}));
        }
    }
}

