/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.fragment.ImagePagerFragment;
import java.io.File;
import java.util.ArrayList;

public class PhotoPagerActivity
extends AppCompatActivity {
    private ImagePagerFragment pagerFragment;
    private static final String FOLDER_NAME = "y_photopicker";
    public static final String EXTRA_CURRENT_ITEM = "current_item";
    public static final String EXTRA_PHOTOS = "photos";
    private ActionBar actionBar;
    private TextView tv_count;
    private ImageView iv_back_btn;
    private int mSaveEditPostion = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.util_activity_photo_pager);
        int currentItem = this.getIntent().getIntExtra(EXTRA_CURRENT_ITEM, 0);
        ArrayList paths = this.getIntent().getStringArrayListExtra(EXTRA_PHOTOS);
        this.tv_count = (TextView)this.findViewById(R.id.tv_count);
        this.iv_back_btn = (ImageView)this.findViewById(R.id.iv_back_btn);
        this.iv_back_btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPagerActivity.this.onBackPressed();
            }
        });
        this.pagerFragment = (ImagePagerFragment)this.getSupportFragmentManager().findFragmentById(R.id.photoPagerFragment);
        this.pagerFragment.setPhotos(paths, currentItem);
        Toolbar mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(mToolbar);
        this.actionBar = this.getSupportActionBar();
        this.actionBar.setDisplayHomeAsUpEnabled(true);
        this.updateActionBarTitle();
        if (Build.VERSION.SDK_INT >= 21) {
            this.actionBar.setElevation(25.0f);
        }
        this.pagerFragment.getViewPager().addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PhotoPagerActivity.this.updateActionBarTitle();
            }

            public void onPageSelected(int i) {
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_preview, menu2);
        return true;
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putExtra("SELECTED_PHOTOS", this.pagerFragment.getPaths());
        this.setResult(-1, intent);
        this.finish();
        super.onBackPressed();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.delete) {
            final int index = this.pagerFragment.getCurrentItem();
            final String deletedPath = this.pagerFragment.getPaths().get(index);
            Snackbar snackbar = Snackbar.make((View)this.pagerFragment.getView(), (int)R.string.y_photopicker_deleted_a_photo, (int)0);
            if (this.pagerFragment.getPaths().size() <= 1) {
                new AlertDialog.Builder((Context)this).setTitle(R.string.y_photopicker_confirm_to_delete).setPositiveButton(R.string.y_photopicker_yes, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                        PhotoPagerActivity.this.setResult(-1);
                        PhotoPagerActivity.this.finish();
                    }
                }).setNegativeButton(R.string.y_photopicker_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                }).show();
            } else {
                snackbar.show();
                this.pagerFragment.getPaths().remove(index);
                this.pagerFragment.getViewPager().getAdapter().notifyDataSetChanged();
            }
            snackbar.setAction(R.string.y_photopicker_undo, new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoPagerActivity.this.pagerFragment.getPaths().size() > 0) {
                        PhotoPagerActivity.this.pagerFragment.getPaths().add(index, deletedPath);
                    } else {
                        PhotoPagerActivity.this.pagerFragment.getPaths().add(deletedPath);
                    }
                    PhotoPagerActivity.this.pagerFragment.getViewPager().getAdapter().notifyDataSetChanged();
                    PhotoPagerActivity.this.pagerFragment.getViewPager().setCurrentItem(index, true);
                }
            });
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void updateActionBarTitle() {
        this.tv_count.setText((CharSequence)("" + (this.pagerFragment.getViewPager().getCurrentItem() + 1) + "/" + this.pagerFragment.getPaths().size()));
    }

    private File createFolders() {
        File baseDir = Build.VERSION.SDK_INT < 8 ? Environment.getExternalStorageDirectory() : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        if (baseDir == null) {
            return Environment.getExternalStorageDirectory();
        }
        File aviaryFolder = new File(baseDir, FOLDER_NAME);
        if (aviaryFolder.exists()) {
            return aviaryFolder;
        }
        if (aviaryFolder.mkdirs()) {
            return aviaryFolder;
        }
        return Environment.getExternalStorageDirectory();
    }

    public static String getFileNameByUri(Context context, Uri uri) {
        String fileName = "unknown";
        Uri filePathUri = uri;
        if (uri.getScheme().toString().compareTo("content") == 0) {
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                filePathUri = Uri.parse((String)cursor.getString(column_index));
                fileName = filePathUri.getLastPathSegment().toString();
            }
        } else {
            fileName = uri.getScheme().compareTo("file") == 0 ? filePathUri.getLastPathSegment().toString() : fileName + "_" + filePathUri.getLastPathSegment();
        }
        return fileName;
    }
}

