/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch;

import com.github.dnault.xmlpatch.ErrorCondition;
import com.github.dnault.xmlpatch.PatchException;
import com.github.dnault.xmlpatch.internal.XmlHelper;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Attribute;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Comment;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Content;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Document;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Element;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.IllegalAddException;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.IllegalNameException;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.JDOMException;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Namespace;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Parent;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.ProcessingInstruction;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Text;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.output.Format;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.output.XMLOutputter;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.xpath.XPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Patcher {
    private static boolean lenient = true;
    private static boolean trimMultilineText = true;

    public static void patch(InputStream target, InputStream diff, OutputStream result) throws IOException {
        try {
            Document targetDoc = XmlHelper.parse(target);
            Document diffDoc = XmlHelper.parse(diff);
            Element diffRoot = diffDoc.getRootElement();
            for (Element o : diffRoot.getChildren()) {
                Patcher.patch(targetDoc, o);
            }
            XMLOutputter outputter = new XMLOutputter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            outputter.setFormat(format);
            outputter.output(targetDoc, result);
        }
        catch (JDOMException e) {
            throw new PatchException(ErrorCondition.INVALID_DIFF_FORMAT, (Throwable)e);
        }
    }

    private static void patch(Document target, Element patch) throws JDOMException {
        String operation;
        switch (operation = patch.getName()) {
            case "add": {
                Patcher.add(target, patch);
                break;
            }
            case "replace": {
                Patcher.replace(target, patch);
                break;
            }
            case "remove": {
                Patcher.remove(target, patch);
                break;
            }
            default: {
                throw new RuntimeException("unknown operation: " + operation);
            }
        }
    }

    private static void throwIfNotSingleNodeOfType(List<Content> content, Class expectedClass) {
        if (content.size() != 1 || !content.get(0).getClass().equals(expectedClass)) {
            throw new PatchException(ErrorCondition.INVALID_NODE_TYPES, "expected replacement to be a single content node of type " + expectedClass.getSimpleName());
        }
    }

    private static void replace(Document target, Element patch) throws JDOMException {
        for (Object node : Patcher.selectNodes(target, patch)) {
            Patcher.doReplace(patch, node);
        }
    }

    public static void main(String[] args) throws Exception {
        Document doc = XmlHelper.parse(new ByteArrayInputStream("<replace/>".getBytes("UTF-8")));
        Element patch = doc.getRootElement();
        Document d = new Document();
        Element e = new Element("foo").setAttribute("message", "goodbye").setText("asdasda");
        d.addContent(e);
        Patcher.doReplace(patch, e.getContent(0));
        System.out.println("[" + e.getText() + "]");
    }

    private static String getTextMaybeTrim(Element patch) {
        String value = patch.getText();
        String override = patch.getAttributeValue("trim");
        if (override != null) {
            if (override.equals("true")) {
                return value.trim();
            }
            if (override.equals("false")) {
                return value;
            }
            throw new RuntimeException("expected 'trim' attribute to be 'true' or 'false' but found " + override);
        }
        return trimMultilineText && Patcher.isMultiline(value) ? value.trim() : value;
    }

    private static void doReplace(Element patch, Object node) throws JDOMException {
        if (node instanceof Attribute) {
            for (Content o : patch.getContent()) {
                if (o instanceof Text) continue;
                throw new PatchException(ErrorCondition.INVALID_NODE_TYPES, "attribute value replacement must be text");
            }
            ((Attribute)node).setValue(Patcher.getTextMaybeTrim(patch));
            return;
        }
        if (node instanceof Element || node instanceof Comment || node instanceof ProcessingInstruction) {
            List<Content> replacement = patch.cloneContent();
            if (lenient) {
                Iterator<Content> i = replacement.iterator();
                while (i.hasNext()) {
                    if (!Patcher.isWhitespace(i.next())) continue;
                    i.remove();
                }
            }
            Patcher.throwIfNotSingleNodeOfType(replacement, node.getClass());
            Content replaceMe = (Content)node;
            Parent p = replaceMe.getParent();
            int index = XmlHelper.indexOf(p, replaceMe);
            replaceMe.detach();
            if (p instanceof Element) {
                Patcher.canonicalizeNamespaces((Element)p, replacement);
                ((Element)p).addContent(index, replacement);
            } else if (p instanceof Document) {
                if (!(node instanceof Element)) {
                    throw new PatchException(ErrorCondition.INVALID_XML_PROLOG_OPERATION, "can't replace prolog nodes");
                }
                ((Document)p).setRootElement((Element)replacement.get(0));
            } else {
                throw new RuntimeException("expected Parent to be either Document or Element but found " + p.getClass());
            }
            return;
        }
        if (node instanceof Text) {
            List<Content> replacement = patch.cloneContent();
            if (!replacement.isEmpty()) {
                Patcher.throwIfNotSingleNodeOfType(replacement, Text.class);
            }
            Content replaceMe = (Content)node;
            Element p = replaceMe.getParentElement();
            int index = XmlHelper.indexOf(p, replaceMe);
            replaceMe.detach();
            String replacementText = Patcher.getTextMaybeTrim(patch);
            if (replacementText.length() > 0) {
                p.addContent(index, new Text(replacementText));
            }
            return;
        }
        if (node instanceof Namespace) {
            throw new UnsupportedOperationException("removing namespace declarations is not yet implemented");
        }
        throw new PatchException(ErrorCondition.INVALID_PATCH_DIRECTIVE, "target node '" + node + "' was not an Attribute, Element, Comment, Text, Processing Instruction, or Namespace");
    }

    private static boolean isMultiline(String replacement) {
        return replacement.contains("\n") || replacement.contains("\r");
    }

    private static boolean isWhitespace(Content node) {
        return node instanceof Text && node.getValue().trim().length() == 0;
    }

    private static void add(Document target, Element patch) throws JDOMException {
        for (Object node : Patcher.selectNodes(target, patch)) {
            Patcher.doAdd(patch, node);
        }
    }

    private static void doAdd(Element patch, Object nodeObject) throws JDOMException {
        block13: {
            String position = patch.getAttributeValue("pos");
            String type = patch.getAttributeValue("type");
            Content node = (Content)nodeObject;
            if (type != null) {
                if (type.startsWith("@")) {
                    Patcher.addAttribute(patch, type.substring(1), Patcher.asElement(node));
                    return;
                }
                if (type.startsWith("namespace::")) {
                    Patcher.addNamespaceDeclaration(patch, type.substring(11), Patcher.asElement(node));
                    return;
                }
            }
            if (("before".equals(position) || "after".equals(position)) && node.getParentElement() == null) {
                for (Content o : patch.getContent()) {
                    if (o instanceof Comment || o instanceof ProcessingInstruction) continue;
                    throw new PatchException(ErrorCondition.INVALID_ROOT_ELEMENT_OPERATION);
                }
            }
            List<Content> newContent = patch.cloneContent();
            try {
                Parent p;
                Element e;
                if (position == null) {
                    e = Patcher.asElement(node);
                    Patcher.canonicalizeNamespaces(e, newContent);
                    e.getContent().addAll(newContent);
                    break block13;
                }
                if ("prepend".equals(position)) {
                    e = Patcher.asElement(node);
                    Patcher.canonicalizeNamespaces(e, newContent);
                    e.getContent().addAll(0, newContent);
                    break block13;
                }
                if ("before".equals(position)) {
                    p = node.getParent();
                    if (p instanceof Element) {
                        Patcher.canonicalizeNamespaces((Element)p, newContent);
                    }
                    int nodeIndex = XmlHelper.indexOf(p, node);
                    p.getContent().addAll(nodeIndex, newContent);
                    break block13;
                }
                if ("after".equals(position)) {
                    p = node.getParent();
                    if (p instanceof Element) {
                        Patcher.canonicalizeNamespaces((Element)p, newContent);
                    }
                    int nodeIndex = XmlHelper.indexOf(p, node);
                    p.getContent().addAll(nodeIndex + 1, newContent);
                    break block13;
                }
                throw new PatchException(ErrorCondition.INVALID_DIFF_FORMAT, "unrecognized position '" + position + "' for add; expected one of " + Arrays.toString(new String[]{"before", "after", "prepend"}));
            }
            catch (IllegalAddException e) {
                throw new PatchException(ErrorCondition.INVALID_PATCH_DIRECTIVE, (Throwable)e);
            }
        }
    }

    private static void addNamespaceDeclaration(Element patch, String prefix, Element target) {
        Namespace ns = Patcher.createNamespace(prefix, Patcher.getTextMaybeTrim(patch));
        target.addNamespaceDeclaration(ns);
    }

    private static Namespace createNamespace(String prefix, String uri) {
        try {
            return Namespace.getNamespace(prefix, uri);
        }
        catch (IllegalNameException e) {
            throw new PatchException(ErrorCondition.INVALID_NAMESPACE_URI, e.getMessage());
        }
    }

    private static void addAttribute(Element patch, String name, Element target) {
        String prefix = null;
        if (name.contains(":")) {
            String[] prefixAndName = name.split(":");
            prefix = prefixAndName[0];
            name = prefixAndName[1];
        }
        String value = Patcher.getTextMaybeTrim(patch);
        Attribute a = new Attribute(name, value);
        if (prefix != null) {
            Namespace ns = patch.getNamespace(prefix);
            if (ns == null) {
                throw new PatchException(ErrorCondition.INVALID_NAMESPACE_PREFIX, "could not resolve namespace prefix '" + prefix + "' in the context of the diff document");
            }
            a.setNamespace(ns);
        }
        Patcher.canonicalizeNamespace(a, XmlHelper.getInScopeNamespaceDeclarations(target));
        target.setAttribute(a);
    }

    private static void canonicalizeNamespaces(Element scope, List<Content> content) {
        Map<String, String> prefixToUri = XmlHelper.getInScopeNamespaceDeclarations(scope);
        for (Content c : content) {
            if (!(c instanceof Element)) continue;
            Patcher.canonicalizeNamespace((Element)c, prefixToUri);
        }
    }

    private static void canonicalizeNamespace(Attribute a, Map<String, String> prefixToUri) {
        for (Map.Entry<String, String> entry : prefixToUri.entrySet()) {
            if (!a.getNamespaceURI().equals(entry.getValue()) || entry.getKey().equals("")) continue;
            a.setNamespace(Namespace.getNamespace(entry.getKey(), entry.getValue()));
            break;
        }
    }

    private static void canonicalizeNamespace(Element e, Map<String, String> prefixToUri) {
        Namespace ns = e.getNamespace();
        for (Map.Entry<String, String> entry : prefixToUri.entrySet()) {
            if (!ns.getURI().equals(entry.getValue())) continue;
            e.setNamespace(Namespace.getNamespace(entry.getKey(), entry.getValue()));
            break;
        }
        for (Object object : e.getAttributes()) {
            Patcher.canonicalizeNamespace((Attribute)object, prefixToUri);
        }
        for (Object object : e.getChildren()) {
            Patcher.canonicalizeNamespace((Element)object, prefixToUri);
        }
    }

    private static Element asElement(Content node) {
        try {
            return (Element)node;
        }
        catch (ClassCastException e) {
            throw new PatchException(ErrorCondition.INVALID_PATCH_DIRECTIVE, "selected node is not an element");
        }
    }

    private static List<Object> selectNodes(Document target, Element patch) throws JDOMException {
        boolean isMultiSelect = false;
        String selector = patch.getAttributeValue("sel");
        if (selector == null) {
            selector = patch.getAttributeValue("msel");
            isMultiSelect = true;
        }
        XPath xpath = XPath.newInstance(selector);
        Patcher.bindNamespacePrefixes(xpath, patch);
        List<Object> content = xpath.selectNodes(target);
        if (content.isEmpty()) {
            throw new PatchException(ErrorCondition.UNLOCATED_NODE, "no matches for selector \"" + selector + "\"");
        }
        if (!isMultiSelect && content.size() > 1) {
            throw new PatchException(ErrorCondition.UNLOCATED_NODE, "more that one match for selector \"" + selector + "\" -- if you want to select multiple nodes, use the 'msel' attribute instead of 'sel'.");
        }
        return content;
    }

    private static void bindNamespacePrefixes(XPath xpath, Element patch) {
        ArrayList<Element> chain = new ArrayList<Element>();
        for (Element e = patch; e != null; e = e.getParentElement()) {
            chain.add(e);
        }
        Collections.reverse(chain);
        for (Element e : chain) {
            for (Namespace o : e.getAdditionalNamespaces()) {
                xpath.addNamespace(o);
            }
        }
    }

    private static void remove(Document target, Element patch) throws JDOMException {
        for (Object node : Patcher.selectNodes(target, patch)) {
            Patcher.doRemove(patch, node);
        }
    }

    private static void doRemove(Element patch, Object node) throws JDOMException {
        if (node instanceof Element || node instanceof Comment || node instanceof ProcessingInstruction) {
            String ws = patch.getAttributeValue("ws");
            boolean before = "both".equals(ws) || "before".equals(ws);
            boolean after = "both".equals(ws) || "after".equals(ws);
            Content c = (Content)node;
            Element e = c.getParentElement();
            if (e == null) {
                throw new PatchException(ErrorCondition.INVALID_ROOT_ELEMENT_OPERATION, "can't remove root element");
            }
            int index = e.indexOf(c);
            ArrayList<Content> nodesToDetach = new ArrayList<Content>();
            nodesToDetach.add(c);
            if (before) {
                nodesToDetach.add(Patcher.getWhitespace(e, index - 1));
            }
            if (after) {
                nodesToDetach.add(Patcher.getWhitespace(e, index + 1));
            }
            for (Content detachMe : nodesToDetach) {
                detachMe.detach();
            }
            return;
        }
        if (patch.getAttribute("ws") != null) {
            throw new PatchException(ErrorCondition.INVALID_PATCH_DIRECTIVE, "The 'ws' attribute is not allowed when removing Attribute, Text or Namespace nodes.");
        }
        if (node instanceof Attribute) {
            Attribute a = (Attribute)node;
            a.getParent().removeAttribute(a);
            return;
        }
        if (node instanceof Text) {
            ((Content)node).detach();
            return;
        }
        if (node instanceof Namespace) {
            throw new UnsupportedOperationException("removing namespace declarations is not yet implemented");
        }
    }

    private static Text getWhitespace(Element parent, int i) {
        try {
            Content c = parent.getContent(i);
            if (Patcher.isWhitespace(c)) {
                return (Text)c;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new PatchException(ErrorCondition.INVALID_WHITESPACE_DIRECTIVE, "sibling is not a whitespace node");
    }
}

