/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;

public abstract class ThreeTenBackPortConverters {
    private static final boolean THREE_TEN_BACK_PORT_IS_PRESENT = ClassUtils.isPresent((String)"org.threeten.bp.LocalDateTime", (ClassLoader)ThreeTenBackPortConverters.class.getClassLoader());

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!THREE_TEN_BACK_PORT_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(DateToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToDateConverter.INSTANCE);
        converters.add(DateToInstantConverter.INSTANCE);
        converters.add(InstantToDateConverter.INSTANCE);
        return converters;
    }

    public static boolean supports(Class<?> type) {
        if (!THREE_TEN_BACK_PORT_IS_PRESENT) {
            return false;
        }
        return Arrays.asList(LocalDateTime.class, LocalDate.class, LocalTime.class, Instant.class).contains(type);
    }

    public static enum InstantToDateConverter implements Converter<Instant, Date>
    {
        INSTANCE;


        public Date convert(Instant source) {
            return source == null ? null : DateTimeUtils.toDate((Instant)source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToInstantConverter implements Converter<Date, Instant>
    {
        INSTANCE;


        public Instant convert(Date source) {
            return source == null ? null : DateTimeUtils.toInstant((Date)source);
        }
    }

    public static enum LocalTimeToDateConverter implements Converter<LocalTime, Date>
    {
        INSTANCE;


        public Date convert(LocalTime source) {
            return source == null ? null : DateTimeUtils.toDate((Instant)source.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalTimeConverter implements Converter<Date, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)source.getTime()), (ZoneId)ZoneId.systemDefault()).toLocalTime();
        }
    }

    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        public Date convert(LocalDate source) {
            return source == null ? null : DateTimeUtils.toDate((Instant)source.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)source.getTime()), (ZoneId)ZoneId.systemDefault()).toLocalDate();
        }
    }

    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        public Date convert(LocalDateTime source) {
            return source == null ? null : DateTimeUtils.toDate((Instant)source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)source), (ZoneId)ZoneId.systemDefault());
        }
    }
}

