/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.WindowSpecificationFinalStep;
import org.jooq.WindowSpecificationOrderByStep;
import org.jooq.WindowSpecificationPartitionByStep;
import org.jooq.WindowSpecificationRowsAndStep;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SortFieldList;

class WindowSpecificationImpl
extends AbstractQueryPart
implements WindowSpecificationPartitionByStep,
WindowSpecificationRowsAndStep {
    private static final long serialVersionUID = 2996016924769376361L;
    private final QueryPartList<Field<?>> partitionBy = new QueryPartList();
    private final SortFieldList orderBy = new SortFieldList();
    private Integer rowsStart;
    private Integer rowsEnd;
    private boolean partitionByOne;

    WindowSpecificationImpl() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        String glue = "";
        if (!(this.partitionBy.isEmpty() || this.partitionByOne && Arrays.asList(SQLDialect.CUBRID).contains((Object)ctx.configuration().dialect()))) {
            ctx.sql(glue).keyword("partition by").sql(' ').visit(this.partitionBy);
            glue = " ";
        }
        if (!this.orderBy.isEmpty()) {
            ctx.sql(glue).keyword("order by").sql(' ').visit(this.orderBy);
            glue = " ";
        }
        if (this.rowsStart != null) {
            ctx.sql(glue);
            ctx.keyword("rows").sql(' ');
            if (this.rowsEnd != null) {
                ctx.keyword("between").sql(' ');
                this.toSQLRows(ctx, this.rowsStart);
                ctx.sql(' ').keyword("and").sql(' ');
                this.toSQLRows(ctx, this.rowsEnd);
            } else {
                this.toSQLRows(ctx, this.rowsStart);
            }
            glue = " ";
        }
    }

    private final void toSQLRows(Context<?> ctx, Integer rows) {
        if (rows == Integer.MIN_VALUE) {
            ctx.keyword("unbounded preceding");
        } else if (rows == Integer.MAX_VALUE) {
            ctx.keyword("unbounded following");
        } else if (rows < 0) {
            ctx.sql(-rows.intValue());
            ctx.sql(' ').keyword("preceding");
        } else if (rows > 0) {
            ctx.sql(rows);
            ctx.sql(' ').keyword("following");
        } else {
            ctx.keyword("current row");
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Field<?> ... fields) {
        return this.partitionBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Collection<? extends Field<?>> fields) {
        this.partitionBy.addAll((Collection<Field<?>>)fields);
        return this;
    }

    @Override
    public final WindowSpecificationOrderByStep partitionByOne() {
        this.partitionByOne = true;
        this.partitionBy.add(DSL.one());
        return null;
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(Field<?> ... fields) {
        this.orderBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(SortField<?> ... fields) {
        return this.orderBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(Collection<? extends SortField<?>> fields) {
        this.orderBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsUnboundedPreceding() {
        this.rowsStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsPreceding(int number) {
        this.rowsStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsCurrentRow() {
        this.rowsStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsUnboundedFollowing() {
        this.rowsStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsFollowing(int number) {
        this.rowsStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedPreceding() {
        this.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenPreceding(int number) {
        this.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenCurrentRow() {
        this.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedFollowing() {
        this.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenFollowing(int number) {
        this.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andUnboundedPreceding() {
        this.rowsEnd = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andPreceding(int number) {
        this.rowsEnd = -number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andCurrentRow() {
        this.rowsEnd = 0;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andUnboundedFollowing() {
        this.rowsEnd = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andFollowing(int number) {
        this.rowsEnd = number;
        return this;
    }
}

