/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.CommonTableExpression;
import org.jooq.Context;
import org.jooq.DerivedColumnList;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.WindowDefinition;
import org.jooq.WindowSpecification;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DerivedColumnListImpl;
import org.jooq.impl.WindowDefinitionImpl;
import org.jooq.tools.StringUtils;

class NameImpl
extends AbstractQueryPart
implements Name {
    private static final long serialVersionUID = 8562325639223483938L;
    private String[] qualifiedName;

    NameImpl(String[] qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.qualify()) {
            String separator = "";
            for (String name : this.qualifiedName) {
                if (StringUtils.isEmpty(name)) continue;
                ctx.sql(separator).literal(name);
                separator = ".";
            }
        } else {
            ctx.literal(this.qualifiedName[this.qualifiedName.length - 1]);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final String[] getName() {
        return this.qualifiedName;
    }

    @Override
    public final WindowDefinition as(WindowSpecification window) {
        return new WindowDefinitionImpl(this, window);
    }

    @Override
    public final <R extends Record> CommonTableExpression<R> as(Select<R> select) {
        return this.fields(new String[0]).as(select);
    }

    @Override
    public final DerivedColumnList fields(String ... fieldNames) {
        if (this.qualifiedName.length != 1) {
            throw new IllegalStateException("Cannot create a DerivedColumnList from a qualified name : " + Arrays.asList(this.qualifiedName));
        }
        return new DerivedColumnListImpl(this.qualifiedName[0], fieldNames);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getName());
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof NameImpl) {
            return Arrays.equals(this.getName(), ((NameImpl)that).getName());
        }
        return super.equals(that);
    }
}

