/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.List;
import org.jooq.Attachable;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;

abstract class AbstractStore
implements AttachableInternal {
    private static final long serialVersionUID = -2989496800221194411L;
    private Configuration configuration;

    AbstractStore() {
        this(null);
    }

    AbstractStore(Configuration configuration) {
        this.configuration = configuration;
    }

    abstract List<Attachable> getAttachables();

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
        List<Attachable> attachables = this.getAttachables();
        int size = attachables.size();
        for (int i = 0; i < size; ++i) {
            Attachable attachable = attachables.get(i);
            if (attachable == null) continue;
            attachable.attach(c);
        }
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    protected final DSLContext create() {
        return DSL.using(this.configuration());
    }

    abstract int size();

    abstract Object getValue(int var1);

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size(); ++i) {
            Object obj = this.getValue(i);
            hashCode = obj == null ? 31 * hashCode : (obj.getClass().isArray() ? 31 * hashCode : 31 * hashCode + obj.hashCode());
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractStore) {
            AbstractStore that = (AbstractStore)obj;
            if (this.size() == that.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    Object thisValue = this.getValue(i);
                    Object thatValue = that.getValue(i);
                    if (thisValue == null && thatValue == null) continue;
                    if (thisValue == null || thatValue == null) {
                        return false;
                    }
                    if (thisValue.getClass().isArray() && thatValue.getClass().isArray()) {
                        if (thisValue.getClass() == byte[].class && thatValue.getClass() == byte[].class) {
                            if (Arrays.equals((byte[])thisValue, (byte[])thatValue)) continue;
                            return false;
                        }
                        if (!thisValue.getClass().getComponentType().isPrimitive() && !thatValue.getClass().getComponentType().isPrimitive()) {
                            if (Arrays.equals((Object[])thisValue, (Object[])thatValue)) continue;
                            return false;
                        }
                        return false;
                    }
                    if (thisValue.equals(thatValue)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

