/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.validation.constraints.impl;

import blue.hive.validation.constraints.BHiveAllowFileSize;
import blue.hive.validation.constraints.impl.BHiveConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.web.multipart.MultipartFile;

public class BHiveAllowFileSizeForMultipartFile
extends BHiveConstraintValidator<BHiveAllowFileSize, MultipartFile> {
    protected long allowSize = 0L;

    @Override
    public void initialize(BHiveAllowFileSize constraintAnnotation) {
        this.allowSize = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(MultipartFile value, ConstraintValidatorContext context) {
        boolean allowed;
        if (value == null || value.isEmpty()) {
            return true;
        }
        long filesize = value.getSize();
        boolean bl = allowed = filesize <= this.allowSize;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isValid({}) allowSize:{} => allowed: {}", new Object[]{filesize, this.allowSize, allowed});
        }
        return allowed;
    }
}

