/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.exception.BHiveRuntimeException;
import blue.hive.jackson.BHiveObjectMapper;
import blue.hive.spring.context.ApplicationContextHolder;
import blue.hive.spring.validation.BHiveFieldError;
import blue.hive.spring.validation.BHiveObjectError;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class BHiveUtil {
    private static final Logger logger = LoggerFactory.getLogger(BHiveUtil.class);
    private static List<String> NOT_USER_METHODS = Arrays.asList("getStackTrace", "getCurrentMethodName", "getStackTraceMethodName");

    public static List<String> getActiveProfiles() {
        ApplicationContext applicationContext = ApplicationContextHolder.getApplicationContext();
        Environment environment = applicationContext.getEnvironment();
        ArrayList activeProfiles = Lists.newArrayList((Object[])environment.getActiveProfiles());
        if (CollectionUtils.isEmpty((Collection)activeProfiles)) {
            activeProfiles = Lists.newArrayList((Object[])environment.getDefaultProfiles());
        }
        return activeProfiles;
    }

    public static String getActiveServerProfile() {
        List<String> activeProfiles = BHiveUtil.getActiveProfiles();
        if (activeProfiles != null && activeProfiles.size() > 0) {
            for (String activeProfile : activeProfiles) {
                if ("local".equals(activeProfile)) {
                    return "local";
                }
                if ("dev".equals(activeProfile)) {
                    return "dev";
                }
                if ("real".equals(activeProfile)) {
                    return "real";
                }
                if ("aws".equals(activeProfile)) {
                    return "aws";
                }
                if (!"test".equals(activeProfile)) continue;
                return "test";
            }
        }
        logger.warn("getActiveProfile FAILED");
        return null;
    }

    public static boolean isLocalProfile() {
        return "local".equals(BHiveUtil.getActiveServerProfile());
    }

    public static boolean isDevProfile() {
        return "dev".equals(BHiveUtil.getActiveServerProfile());
    }

    public static boolean isRealProfile() {
        return "real".equals(BHiveUtil.getActiveServerProfile());
    }

    public static boolean isAwsProfile() {
        return "aws".equals(BHiveUtil.getActiveServerProfile());
    }

    public static boolean isTestProfile() {
        return "test".equals(BHiveUtil.getActiveServerProfile());
    }

    public static String getCurrentMethodName() {
        return BHiveUtil.getStackTraceMethodName(0);
    }

    public static String getStackTraceMethodName(int upperDepth) {
        String methodName;
        StackTraceElement[] steList = Thread.currentThread().getStackTrace();
        int length = steList.length;
        int startIndex = 0;
        for (int i = 0; i < length && NOT_USER_METHODS.contains(methodName = steList[i].getMethodName()); ++i) {
            ++startIndex;
        }
        return steList[startIndex + upperDepth].getMethodName();
    }

    public static String toJson(Object object) {
        return BHiveUtil.toJson(object, null);
    }

    public static String toJson(Object object, Class<?> serializationView) {
        String json;
        BHiveObjectMapper mapper = new BHiveObjectMapper();
        try {
            json = serializationView != null ? mapper.writerWithView(serializationView).writeValueAsString(object) : mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new BHiveRuntimeException("Failed to write as json", e);
        }
        return json.replace("/", "\\/");
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        BHiveObjectMapper mapper = new BHiveObjectMapper();
        try {
            Object value = mapper.readValue(json, valueType);
            return (T)value;
        }
        catch (Exception e) {
            throw new BHiveRuntimeException("Failed to read from json", e);
        }
    }

    public static String getMessageOfException(Throwable ex, boolean includeExceptionClassSimpleName, boolean includeCauseMessage) {
        Throwable innerEx;
        String message = (includeExceptionClassSimpleName ? ex.getClass().getSimpleName() + ": " : "") + ex.getMessage();
        if (includeCauseMessage && (innerEx = ex.getCause()) != null) {
            return message + " - " + BHiveUtil.getMessageOfException(innerEx, includeExceptionClassSimpleName, includeCauseMessage);
        }
        return message;
    }

    public static <T extends Exception> T findInnerException(Throwable ex, Class<? extends Throwable> requiredType) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return null;
        }
        return BHiveUtil.findInnerException(cause, requiredType);
    }

    public static Boolean hasInnerException(Throwable ex, Class<? extends Throwable> requiredType) {
        return BHiveUtil.findInnerException(ex, requiredType) != null;
    }

    public static String buildErrorMessage(Errors errors, MessageSource messageSource, String seperator) {
        StringBuilder sb = new StringBuilder();
        List globalErrors = errors.getGlobalErrors();
        for (ObjectError objectError : globalErrors) {
            BHiveObjectError ableObjectError = new BHiveObjectError(objectError);
            sb.append(ableObjectError.getMessage() + seperator);
        }
        List fieldErrors = errors.getFieldErrors();
        for (FieldError fieldError : fieldErrors) {
            BHiveFieldError ableFieldError = new BHiveFieldError(fieldError, messageSource);
            sb.append(ableFieldError.getMessage() + seperator);
        }
        return sb.toString();
    }
}

