/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.view;

import blue.hive.annotation.ExcelColumn;
import blue.hive.exception.BHiveRuntimeException;
import blue.hive.spring.web.view.BHiveExcelMergeMode;
import blue.hive.util.BHiveVOUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.util.StringUtils;
import org.supercsv.io.ICsvBeanWriter;

public class BHiveExcelCommand {
    protected static final Logger logger = LoggerFactory.getLogger(BHiveExcelCommand.class);
    public static final String MODEL_KEY = "bHiveExcelCommand";
    public static final String EXTENSTION = ".xls";
    public static final String EXTENSION_CSV = ".csv";
    private static double AUTO_SIZE_HEADERCOLUMN_MULTIFIER = 1.2;
    private static double AUTO_SIZE_COLUMN_MULTIFIER = 1.3;
    protected String messagePrefix = "com.col.";
    protected MessageSource messageSource;
    protected String filename = "";
    protected String title = "";
    protected String sheetName = "data sheet";
    protected List dataList = new ArrayList();
    protected Class<?> metadataClass;
    protected BHiveExcelMergeMode mergeMode = BHiveExcelMergeMode.NONE;
    protected Map<String, ExcelColumn> anntationMap = new HashMap<String, ExcelColumn>();
    protected Map<String, Integer> columnOrderMap = new HashMap<String, Integer>();
    protected boolean hasGroupHeaderMap = false;
    protected Map<String, String> groupHeaderMap = new HashMap<String, String>();
    protected Map<String, String> headerMap = new HashMap<String, String>();
    protected Map<String, Short> columnAlignMap = new HashMap<String, Short>();
    protected Map<String, Map<String, String>> fieldCodeMapList = new HashMap<String, Map<String, String>>();
    protected DateTime now = new DateTime();
    protected HSSFWorkbook workbook;
    protected ICsvBeanWriter csvWriter;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public void setFilename(String filename) {
        if (StringUtils.isEmpty((Object)filename)) {
            filename = "datalist";
        }
        this.filename = filename = FilenameUtils.removeExtension((String)filename);
    }

    public BHiveExcelCommand(List dataList, Class<?> metadataClass, MessageSource messageSource) {
        this.dataList = dataList;
        this.metadataClass = metadataClass;
        this.messageSource = messageSource;
    }

    public void addCodeMap(String field, List codeDTList, String valueProp, String nameProp) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, String> fieldCodeMap = new HashMap<String, String>();
        for (Object codeDT : codeDTList) {
            String value = BeanUtils.getProperty(codeDT, (String)valueProp);
            String name = BeanUtils.getProperty(codeDT, (String)nameProp);
            fieldCodeMap.put(value, name);
        }
        this.fieldCodeMapList.put(field, fieldCodeMap);
    }

    public void addCodeMap(String field, Map<String, String> fieldCodeMap) {
        this.fieldCodeMapList.put(field, fieldCodeMap);
    }

    protected HSSFCellStyle createCustomCellStyle(short bgColor, HorizontalAlignment align, VerticalAlignment valign, HSSFFont font) {
        HSSFCellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(bgColor);
        cellStyle.setAlignment(align);
        cellStyle.setVerticalAlignment(valign);
        if (font != null) {
            cellStyle.setFont(font);
        }
        return cellStyle;
    }

    protected HSSFCellStyle createCustomCellStyle(short bgColor, HorizontalAlignment align, VerticalAlignment valign, short fontHeightInPoints, short fontColor, boolean boldWeight, byte underline) {
        HSSFFont font = this.createFont(fontHeightInPoints, fontColor, boldWeight, null, underline);
        return this.createCustomCellStyle(bgColor, align, valign, font);
    }

    protected HSSFCellStyle createCustomCellStyle(short bgColor, HorizontalAlignment align, VerticalAlignment valign) {
        return this.createCustomCellStyle(bgColor, align, valign, null);
    }

    private HSSFFont createFont(short fontHeightInPoints, short fontColor, boolean boldWeight, String fontName, byte underline) {
        HSSFFont font = this.workbook.createFont();
        font.setFontHeightInPoints(fontHeightInPoints);
        font.setColor(fontColor);
        font.setBold(boldWeight);
        if (!StringUtils.isEmpty((Object)fontName)) {
            font.setFontName(fontName);
        } else {
            font.setFontName("\ub9d1\uc740 \uace0\ub515");
        }
        font.setUnderline(underline);
        return font;
    }

    private void setBorderStyleToCellStyle(HSSFCellStyle cellStyle, short borderColor, BorderStyle borderStyle) {
        cellStyle.setLeftBorderColor(borderColor);
        cellStyle.setRightBorderColor(borderColor);
        cellStyle.setTopBorderColor(borderColor);
        cellStyle.setBottomBorderColor(borderColor);
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setBorderBottom(borderStyle);
    }

    protected HSSFCellStyle createTitleCellStyle() {
        return this.createTitleCellStyle((short)12, false);
    }

    protected HSSFCellStyle createTitleCellStyle(short fontHeightInPoints, short fontColor, byte underline, boolean setBorder) {
        HSSFFont font = this.createFont(fontHeightInPoints, fontColor, true, null, underline);
        HSSFCellStyle cellStyle = this.createCustomCellStyle((short)9, HorizontalAlignment.CENTER, VerticalAlignment.CENTER, font);
        if (setBorder) {
            this.setBorderStyleToCellStyle(cellStyle, (short)23, BorderStyle.THIN);
            cellStyle.setWrapText(true);
        }
        return cellStyle;
    }

    protected HSSFCellStyle createTitleCellStyle(short fontHeightInPoints, boolean setBorder) {
        return this.createTitleCellStyle(fontHeightInPoints, (short)8, (byte)0, setBorder);
    }

    protected HSSFCellStyle createSubTitleCellStyle() {
        return this.createCustomCellStyle((short)9, HorizontalAlignment.RIGHT, VerticalAlignment.CENTER, (short)10, (short)23, false, (byte)0);
    }

    protected HSSFCellStyle createHeaderCellStyle() {
        HSSFCellStyle headerStyle = this.createCustomCellStyle((short)22, HorizontalAlignment.CENTER, VerticalAlignment.CENTER, (short)10, (short)8, true, (byte)0);
        this.setBorderStyleToCellStyle(headerStyle, (short)23, BorderStyle.THIN);
        headerStyle.setWrapText(true);
        return headerStyle;
    }

    protected HSSFCellStyle createDataCellStyle(HorizontalAlignment align) {
        HSSFCellStyle dataCellStyle = this.createCustomCellStyle((short)9, align, VerticalAlignment.TOP);
        this.setBorderStyleToCellStyle(dataCellStyle, (short)23, BorderStyle.THIN);
        dataCellStyle.setWrapText(true);
        return dataCellStyle;
    }

    protected static void renderCustomCellValue(HSSFRow excelRow, int cellnum, String cellValue, HSSFCellStyle cellStyle) {
        BHiveExcelCommand.renderCustomCellValue(excelRow, cellnum, cellValue, cellStyle, 1, 1);
    }

    protected static void renderCustomCellValue(HSSFRow excelRow, int cellnum, String cellValue, HSSFCellStyle cellStyle, int colSpan, int rowSpan) {
        HSSFCell excelCell = excelRow.createCell(cellnum);
        excelCell.setCellValue(cellValue);
        if (cellStyle != null) {
            excelCell.setCellStyle(cellStyle);
            for (int r = 0; r < rowSpan; ++r) {
                boolean isRowCreated = false;
                HSSFRow rowTemp = excelRow.getSheet().getRow(excelRow.getRowNum() + r);
                if (rowTemp == null) {
                    isRowCreated = true;
                    rowTemp = excelRow.getSheet().createRow(excelRow.getRowNum() + r);
                }
                for (int c = 0; c < colSpan; ++c) {
                    HSSFCell cellTemp = null;
                    if (isRowCreated) {
                        cellTemp = rowTemp.createCell(cellnum + c);
                    } else {
                        cellTemp = rowTemp.getCell(cellnum + c);
                        if (cellTemp == null) {
                            cellTemp = rowTemp.createCell(cellnum + c);
                        }
                    }
                    cellTemp.setCellStyle(cellStyle);
                }
            }
        }
        if (rowSpan > 1 && colSpan > 1) {
            BHiveExcelCommand.mergeRange(excelRow.getSheet(), excelRow.getRowNum(), cellnum, rowSpan, colSpan);
        } else if (colSpan > 1) {
            BHiveExcelCommand.mergeHorizontal(excelRow.getSheet(), excelRow.getRowNum(), cellnum, colSpan);
        } else if (rowSpan > 1) {
            BHiveExcelCommand.mergeVertical(excelRow.getSheet(), excelRow.getRowNum(), cellnum, rowSpan);
        }
    }

    public void buildExcelDocument(HSSFWorkbook workbook, HttpServletRequest request, HttpServletResponse response) {
        this.workbook = workbook;
        this.request = request;
        this.response = response;
        try {
            this.prepareMetadata();
            HSSFSheet excelSheet = workbook.createSheet(this.sheetName);
            int rownum = 0;
            rownum = this.renderTitle(excelSheet, rownum);
            int dataRownumStarted = rownum = this.renderExcelHeader(excelSheet, rownum);
            rownum = this.renderExcelRows(excelSheet, rownum);
            this.postRenderSheet(excelSheet, dataRownumStarted, rownum);
        }
        catch (Exception e) {
            this.checkDataItemTypeWithMetadataClass();
            throw new BHiveRuntimeException("Failed to create excel.", e);
        }
    }

    protected void checkDataItemTypeWithMetadataClass() {
        Class<?> dataItemType;
        if (this.dataList.size() > 0 && !this.metadataClass.isAssignableFrom(dataItemType = this.dataList.get(0).getClass())) {
            logger.warn("[CAUTION] Given metadataClass is not assignable from item's class of given list.");
            logger.warn(" - metadataClass: {}", this.metadataClass);
            logger.warn(" - dataItemType: {}", dataItemType);
        }
    }

    protected void prepareMetadata() throws IntrospectionException {
        if (this.columnOrderMap.size() == 0) {
            Map<String, Integer> orderMap = BHiveVOUtil.getExcelColumnOrderMap(this.metadataClass);
            this.columnOrderMap = orderMap;
        }
        if (this.groupHeaderMap.size() == 0) {
            Map<String, String> groupHeaderMap = BHiveVOUtil.getExcelColumnGroupNameMap(this.metadataClass, this.messageSource, this.messagePrefix, LocaleContextHolder.getLocale());
            this.groupHeaderMap = groupHeaderMap;
            for (Map.Entry<String, String> key : this.groupHeaderMap.entrySet()) {
                String value = key.getValue();
                if (StringUtils.isEmpty((Object)value)) continue;
                this.hasGroupHeaderMap = true;
                break;
            }
        }
        if (this.headerMap.size() == 0) {
            Map<String, String> headerMap = BHiveVOUtil.getExcelColumnNameMap(this.metadataClass, this.messageSource, this.messagePrefix, LocaleContextHolder.getLocale());
            this.headerMap = headerMap;
        }
        if (this.anntationMap.size() == 0) {
            Map<String, ExcelColumn> anntationMap = BHiveVOUtil.getExcelColumnAnnotationMap(this.metadataClass);
            this.anntationMap = anntationMap;
        }
    }

    protected int renderTitle(HSSFSheet excelSheet, int rownum) {
        if (StringUtils.isEmpty((Object)this.title)) {
            return rownum;
        }
        HSSFRow excelRow = excelSheet.createRow(rownum);
        HSSFCell excelCell = excelRow.createCell(0);
        excelCell.setCellValue(this.title);
        HSSFCellStyle titleStyle = this.createTitleCellStyle();
        excelCell.setCellStyle(titleStyle);
        this.mergeHorizontalByColumnCount(excelSheet, rownum);
        ++rownum;
        rownum = this.renderCustomTitle(excelSheet, rownum);
        return rownum;
    }

    protected int renderCustomTitle(HSSFSheet excelSheet, int rownum) {
        return rownum;
    }

    protected int renderSubtitle(HSSFSheet excelSheet, int rownum) {
        User me = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object principal = authentication.getPrincipal();
        if (principal instanceof User) {
            me = (User)principal;
        }
        String subtitle = "";
        subtitle = me != null ? String.format("\uc5d1\uc140\uc0dd\uc131\uc790: %s, \uc0dd\uc131\uc77c\uc2dc: %s", me.getUsername(), this.now.toString("yyyy-MM-dd HH:mm:ss")) : String.format("\uc0dd\uc131\uc77c\uc2dc: %s", this.now.toString("yyyy-MM-dd HH:mm:ss"));
        HSSFRow excelRow = excelSheet.createRow(rownum);
        HSSFCell excelCell = excelRow.createCell(0);
        excelCell.setCellValue(subtitle);
        HSSFCellStyle subTitleStyle = this.createSubTitleCellStyle();
        excelCell.setCellStyle(subTitleStyle);
        this.mergeHorizontalByColumnCount(excelSheet, rownum);
        ++rownum;
        rownum = this.renderCustomSubTitle(excelSheet, rownum);
        return rownum;
    }

    protected int renderCustomSubTitle(HSSFSheet excelSheet, int rownum) {
        return rownum;
    }

    protected int renderExcelHeader(HSSFSheet excelSheet, int rownum) {
        HSSFCellStyle headerStyle = this.createHeaderCellStyle();
        HSSFRow excelHeaderRow1 = excelSheet.createRow(rownum++);
        HSSFRow excelHeaderRow2 = this.hasGroupHeaderMap ? excelSheet.createRow(rownum++) : excelHeaderRow1;
        double headerMaxLine1 = 1.0;
        double headerMaxLine2 = 1.0;
        double headerMaxLine12 = 1.0;
        int cellnum = 0;
        for (String field : this.columnOrderMap.keySet()) {
            HSSFCell excelHeaderCell1 = excelHeaderRow1.createCell(cellnum);
            HSSFCell excelHeaderCell2 = this.hasGroupHeaderMap ? excelHeaderRow2.createCell(cellnum) : excelHeaderCell1;
            String headerValue1 = this.groupHeaderMap.get(field);
            String headerValue2 = this.headerMap.get(field);
            if (!this.hasGroupHeaderMap) {
                excelHeaderCell2.setCellValue(headerValue2);
                excelHeaderCell2.setCellStyle(headerStyle);
            } else {
                boolean hasGroupHeaderCellValue;
                boolean bl = hasGroupHeaderCellValue = !StringUtils.isEmpty((Object)headerValue1);
                if (!hasGroupHeaderCellValue) {
                    excelHeaderCell1.setCellValue(headerValue2.replace("(", "\r\n("));
                    excelHeaderCell1.setCellStyle(headerStyle);
                    excelHeaderCell2.setCellStyle(headerStyle);
                    headerMaxLine12 = Math.max((double)headerValue2.split("\n").length, headerMaxLine12);
                } else {
                    excelHeaderCell1.setCellValue(headerValue1);
                    excelHeaderCell1.setCellStyle(headerStyle);
                    excelHeaderCell2.setCellValue(headerValue2);
                    excelHeaderCell2.setCellStyle(headerStyle);
                    headerMaxLine1 = Math.max((double)headerValue1.split("\n").length, headerMaxLine1);
                    headerMaxLine2 = Math.max((double)headerValue2.split("\n").length, headerMaxLine2);
                }
                excelSheet.autoSizeColumn(cellnum);
                excelSheet.setColumnWidth(cellnum, (int)((double)excelSheet.getColumnWidth(cellnum) * AUTO_SIZE_HEADERCOLUMN_MULTIFIER));
                if (!hasGroupHeaderCellValue) {
                    excelSheet.addMergedRegion(new CellRangeAddress(excelHeaderRow1.getRowNum(), excelHeaderRow2.getRowNum(), cellnum, cellnum));
                }
            }
            ++cellnum;
        }
        if (this.hasGroupHeaderMap) {
            BHiveExcelCommand.mergeHorizontalCellHasEqualValue(excelSheet, excelHeaderRow1.getRowNum(), 0, this.columnOrderMap.size());
            for (int cellIdx = 0; cellIdx < this.columnOrderMap.keySet().size(); ++cellIdx) {
                excelSheet.autoSizeColumn(cellIdx);
                excelSheet.setColumnWidth(cellIdx, (int)((double)excelSheet.getColumnWidth(cellIdx) * AUTO_SIZE_HEADERCOLUMN_MULTIFIER));
            }
        }
        if (headerMaxLine12 > headerMaxLine1 + headerMaxLine2) {
            double headerMaxLineAdd = (headerMaxLine12 - (headerMaxLine1 + headerMaxLine2)) / 2.0;
            headerMaxLine1 += headerMaxLineAdd;
            headerMaxLine2 += headerMaxLineAdd;
        }
        excelHeaderRow1.setHeightInPoints((float)((double)excelSheet.getDefaultRowHeightInPoints() * headerMaxLine1));
        excelHeaderRow2.setHeightInPoints((float)((double)excelSheet.getDefaultRowHeightInPoints() * headerMaxLine2));
        return rownum;
    }

    protected int renderExcelRows(HSSFSheet excelSheet, int rownum) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<ExcelColumn.ExcelAlign, HSSFCellStyle> cellStyleMap = new HashMap<ExcelColumn.ExcelAlign, HSSFCellStyle>();
        HSSFCellStyle cellStyleLeft = this.createDataCellStyle(HorizontalAlignment.LEFT);
        HSSFCellStyle cellStyleCenter = this.createDataCellStyle(HorizontalAlignment.CENTER);
        HSSFCellStyle cellStyleRight = this.createDataCellStyle(HorizontalAlignment.RIGHT);
        HSSFCellStyle cellStyleDefaultFallback = cellStyleLeft;
        cellStyleMap.put(ExcelColumn.ExcelAlign.Left, cellStyleLeft);
        cellStyleMap.put(ExcelColumn.ExcelAlign.Center, cellStyleCenter);
        cellStyleMap.put(ExcelColumn.ExcelAlign.Right, cellStyleRight);
        cellStyleMap.put(ExcelColumn.ExcelAlign.DefaultByType, null);
        int cellnum = 0;
        for (Object dt : this.dataList) {
            HSSFRow excelRow = excelSheet.createRow(rownum++);
            cellnum = 0;
            for (String columnName : this.columnOrderMap.keySet()) {
                ExcelColumn annotation = this.anntationMap.get(columnName);
                String fieldValue = BeanUtils.getProperty(dt, (String)columnName);
                PropertyDescriptor propDesc = org.springframework.beans.BeanUtils.getPropertyDescriptor(dt.getClass(), (String)columnName);
                if (propDesc == null) continue;
                Class<Object> fieldType = propDesc.getPropertyType();
                if (fieldType.isAssignableFrom(DateTime.class)) {
                    if (fieldValue != null) {
                        DateTime date = new DateTime((Object)fieldValue);
                        fieldValue = date.toString(annotation.dateTimeFormat());
                    }
                } else if (this.fieldCodeMapList.containsKey(columnName)) {
                    Map<String, String> codeMap = this.fieldCodeMapList.get(columnName);
                    logger.trace("####[EXCEL] codeMap[" + columnName + " = " + fieldValue + "] => " + codeMap.toString());
                    if (codeMap.containsKey(fieldValue)) {
                        fieldValue = codeMap.get(fieldValue);
                    }
                }
                HSSFCell cell = excelRow.createCell(cellnum++);
                cell.setCellValue(fieldValue);
                HSSFCellStyle dataCellStyle = null;
                dataCellStyle = (HSSFCellStyle)cellStyleMap.get((Object)annotation.align());
                if (dataCellStyle == null) {
                    dataCellStyle = fieldType.isAssignableFrom(Long.class) || fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Short.class) || fieldType.isAssignableFrom(Double.class) || fieldType.isAssignableFrom(Float.class) ? cellStyleRight : cellStyleDefaultFallback;
                }
                cell.setCellStyle(dataCellStyle);
            }
        }
        return rownum;
    }

    protected void postRenderSheet(HSSFSheet excelSheet, int dataRownumStarted, int rownum) throws UnsupportedEncodingException {
        this.applyColumnWidth(excelSheet);
        this.applyDataCellMergeMode(excelSheet, dataRownumStarted, rownum);
        this.applyColumnHidden(excelSheet);
        this.setResponseHeader();
    }

    protected void applyColumnWidth(HSSFSheet excelSheet) {
        int cellnum = 0;
        for (String field : this.columnOrderMap.keySet()) {
            ExcelColumn annotation = this.anntationMap.get(field);
            logger.trace("####[EXCEL] postRenderSheet => applyColumnWidth {} width: {}", (Object)field, (Object)annotation.width());
            if (annotation.width() <= 0) {
                int oldWidthByHeader = excelSheet.getColumnWidth(cellnum);
                excelSheet.autoSizeColumn(cellnum);
                excelSheet.setColumnWidth(cellnum, (int)((double)excelSheet.getColumnWidth(cellnum) * AUTO_SIZE_COLUMN_MULTIFIER));
                if (oldWidthByHeader > excelSheet.getColumnWidth(cellnum)) {
                    excelSheet.setColumnWidth(cellnum, oldWidthByHeader);
                }
                logger.trace("####[EXCEL] postRenderSheet => applyColumnWidth {} autoSizeColumn({})", (Object)field, (Object)cellnum);
            } else {
                excelSheet.setColumnWidth(cellnum, annotation.width() * 256);
            }
            ++cellnum;
        }
    }

    protected void applyDataCellMergeMode(HSSFSheet excelSheet, int dataRownumStarted, int rownum) {
        switch (this.mergeMode) {
            case MERGE_VERTICAL: {
                this.mergeVerticalAtAllColumn(excelSheet, dataRownumStarted, rownum);
                break;
            }
            case MERGE_VERTICAL_HIERARCHY: {
                this.mergeVerticalHierarchyAtAllColumn(excelSheet, dataRownumStarted, rownum);
                break;
            }
        }
    }

    protected void applyColumnHidden(HSSFSheet excelSheet) {
        int cellnum = 0;
        for (String field : this.columnOrderMap.keySet()) {
            ExcelColumn annotation = this.anntationMap.get(field);
            logger.trace("####[EXCEL] postRenderSheet => applyColumnHidden {} hidden: {}", (Object)field, (Object)annotation.hidden());
            if (annotation.hidden()) {
                excelSheet.setColumnHidden(cellnum, true);
            }
            ++cellnum;
        }
    }

    protected void setResponseHeader() throws UnsupportedEncodingException {
        String attachmentFilename = FilenameUtils.removeExtension((String)this.filename) + "_" + this.now.toString("yyyyMMdd_HHmmss") + EXTENSTION;
        this.setAttachementFilenameHeader(attachmentFilename);
        this.response.setHeader("Content-Transfer-Encoding", "binary");
        this.response.setHeader("Set-Cookie", "fileDownload=true; path=/");
    }

    private void setAttachementFilenameHeader(String attachmentFilename) throws UnsupportedEncodingException {
        String user_agent = this.request.getHeader("user-agent");
        boolean isInternetExplorer = user_agent.indexOf("MSIE") > -1 || user_agent.indexOf("Trident") > -1;
        logger.trace("####[EXCEL/CSV] user_agent:" + user_agent);
        logger.trace("####[EXCEL/CSV] isInternetExplorer:" + isInternetExplorer);
        if (isInternetExplorer) {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + URLEncoder.encode(attachmentFilename, "utf-8") + "\";");
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + MimeUtility.encodeWord((String)attachmentFilename, (String)"utf-8", (String)"Q") + "\";");
        }
    }

    protected static void mergeHorizontal(HSSFSheet excelSheet, int rownum, int cellnum, int colSpan) {
        if (colSpan > 0) {
            excelSheet.addMergedRegion(new CellRangeAddress(rownum, rownum, cellnum, cellnum + colSpan - 1));
        }
    }

    protected static void mergeVertical(HSSFSheet excelSheet, int rownum, int cellnum, int rowSpan) {
        if (rowSpan > 0) {
            excelSheet.addMergedRegion(new CellRangeAddress(rownum, rownum + rowSpan - 1, cellnum, cellnum));
        }
    }

    protected static void mergeRange(HSSFSheet excelSheet, int rownum, int cellnum, int rowSpan, int colSpan) {
        if (rowSpan > 0 && colSpan > 0) {
            excelSheet.addMergedRegion(new CellRangeAddress(rownum, rownum + rowSpan - 1, cellnum, cellnum + colSpan - 1));
        }
    }

    protected void mergeHorizontalByColumnCount(HSSFSheet excelSheet, int atRownum) {
        int columnCount = this.columnOrderMap.size();
        BHiveExcelCommand.mergeHorizontal(excelSheet, atRownum, 0, columnCount);
    }

    protected void mergeVerticalAtAllColumn(HSSFSheet excelSheet, int dataRownumStarted, int dataRownumMax) {
        int columnCount = this.columnOrderMap.size();
        for (int cellnum = 0; cellnum < this.columnOrderMap.size(); ++cellnum) {
            BHiveExcelCommand.mergeVerticalCellHasEqualValue(excelSheet, cellnum, dataRownumStarted, dataRownumMax, false, columnCount - 1);
        }
    }

    protected void mergeVerticalHierarchyAtAllColumn(HSSFSheet excelSheet, int dataRownumStarted, int dataRownumMax) {
        int columnCount = this.columnOrderMap.size();
        if (columnCount > 0) {
            BHiveExcelCommand.mergeVerticalCellHasEqualValue(excelSheet, 0, dataRownumStarted, dataRownumMax, true, columnCount - 1);
        }
    }

    protected static void mergeVerticalCellHasEqualValue(HSSFSheet excelSheet, int cellnum, int dataRownumStarted, int dataRownumMax, boolean hierarchy, int cellnumMax) {
        logger.trace("mergeVerticalCell - cellnum: {}, dataRownumStarted: {}, dataRownumMax: {}, hierarchy: {}, cellnumMax: {}", new Object[]{cellnum, dataRownumStarted, dataRownumMax, hierarchy, cellnumMax});
        if (dataRownumStarted >= dataRownumMax) {
            return;
        }
        if (hierarchy && cellnum >= cellnumMax) {
            return;
        }
        HSSFRow beginRow = null;
        HSSFCell beginCell = null;
        HSSFRow currentRow = null;
        HSSFCell currentCell = null;
        int rowSpan = 1;
        for (int rownum = dataRownumStarted; rownum < dataRownumMax; ++rownum) {
            boolean isRemainRow;
            if (beginRow == null) {
                beginRow = excelSheet.getRow(rownum);
                beginCell = beginRow.getCell(cellnum);
                continue;
            }
            currentRow = excelSheet.getRow(rownum);
            currentCell = currentRow.getCell(cellnum);
            boolean isEqual = beginCell.toString().equals(currentCell.toString());
            boolean bl = isRemainRow = rownum < dataRownumMax - 1;
            if (isEqual) {
                ++rowSpan;
            }
            if (!(isEqual && isRemainRow || rowSpan <= 1)) {
                excelSheet.addMergedRegion(new CellRangeAddress(beginRow.getRowNum(), beginRow.getRowNum() + rowSpan - 1, cellnum, cellnum));
                if (hierarchy && cellnum < cellnumMax - 1) {
                    BHiveExcelCommand.mergeVerticalCellHasEqualValue(excelSheet, cellnum + 1, beginRow.getRowNum(), beginRow.getRowNum() + rowSpan, hierarchy, cellnumMax);
                }
            }
            if (isEqual) continue;
            rowSpan = 1;
            beginRow = currentRow;
            beginCell = currentCell;
        }
    }

    protected static void mergeHorizontalCellHasEqualValue(HSSFSheet excelSheet, int rownum, int cellnumStart, int cellnumEnd) {
        logger.trace("mergeHorizontalCell - rownum: {}, cellnumStart: {}, cellnumEnd: {}", new Object[]{rownum, cellnumStart, cellnumEnd});
        if (cellnumStart >= cellnumEnd) {
            return;
        }
        HSSFRow row = excelSheet.getRow(rownum);
        HSSFCell beginCell = null;
        HSSFCell currentCell = null;
        int cellSpan = 1;
        for (int cellnum = cellnumStart; cellnum < cellnumEnd; ++cellnum) {
            logger.trace(" cellnum:{}", (Object)cellnum);
            if (beginCell == null) {
                beginCell = row.getCell(cellnum);
                continue;
            }
            currentCell = row.getCell(cellnum);
            boolean isEqual = beginCell.toString().equals(currentCell.toString());
            boolean isRemainCell = cellnum < cellnumEnd - 1;
            logger.trace(" -> cellnum:{}, isEqual: {}, isRemainCell: {}, cellnumEnd: {}", new Object[]{cellnum, isEqual, isRemainCell});
            if (isEqual) {
                ++cellSpan;
            }
            if (!(isEqual && isRemainCell || cellSpan <= 1)) {
                excelSheet.addMergedRegion(new CellRangeAddress(rownum, rownum, beginCell.getColumnIndex(), beginCell.getColumnIndex() + cellSpan - 1));
                logger.trace(" ==> addMergedRegion => firstRow: {}, lastRow: {}, firstCol: {}, lastCol: {}", new Object[]{rownum, rownum, cellnum, cellnum + cellSpan - 1});
            }
            if (isEqual) continue;
            cellSpan = 1;
            beginCell = currentCell;
        }
    }

    public void buildCsvDocument(Map<String, Object> model, ICsvBeanWriter csvWriter, HttpServletRequest request, HttpServletResponse response) {
        this.csvWriter = csvWriter;
        this.request = request;
        this.response = response;
        try {
            this.prepareMetadata();
            this.setResponseCSVHeader();
            this.renderCsvHeader(model);
            this.renderCsvRows(model);
        }
        catch (Exception e) {
            this.checkDataItemTypeWithMetadataClass();
            throw new BHiveRuntimeException("Failed to create excel.", e);
        }
    }

    private void renderCsvHeader(Map<String, Object> model) throws IOException {
        if (!StringUtils.isEmpty((Object)this.title)) {
            logger.trace("####[CSV] writeComment");
            this.csvWriter.writeComment(this.title);
            logger.trace("####[CSV] writeComment ok");
        }
        ArrayList<String> headers = new ArrayList<String>();
        for (String field : this.columnOrderMap.keySet()) {
            String headerValue1 = this.groupHeaderMap.get(field);
            String headerValue2 = this.headerMap.get(field);
            if (!StringUtils.isEmpty((Object)headerValue1)) {
                headerValue2 = headerValue1 + " " + headerValue2;
            }
            headers.add(headerValue2);
        }
        this.csvWriter.writeHeader(headers.toArray(new String[0]));
        logger.trace("####[CSV] writeHeader ok");
    }

    private void renderCsvRows(Map<String, Object> model) throws IOException {
        String[] columns = this.columnOrderMap.keySet().toArray(new String[0]);
        for (Object dt : this.dataList) {
            this.csvWriter.write(dt, columns);
        }
        logger.trace("####[CSV] writeRows ok");
    }

    protected void setResponseCSVHeader() throws IOException {
        String attachmentFilename = FilenameUtils.removeExtension((String)this.filename) + "_" + this.now.toString("yyyyMMdd_HHmmss") + EXTENSION_CSV;
        this.setAttachementFilenameHeader(attachmentFilename);
        this.response.setHeader("Content-Transfer-Encoding", "binary");
        this.response.setHeader("Set-Cookie", "fileDownload=true; path=/");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public BHiveExcelMergeMode getMergeMode() {
        return this.mergeMode;
    }

    public void setMergeMode(BHiveExcelMergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }
}

