/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.client;

import blue.hive.crypto.AES256Crypto;
import blue.hive.spring.client.API_TYPE;
import blue.hive.spring.client.BHiveLoggingClientHttpRequestInterceptor;
import blue.hive.spring.client.BHiveRestTemplate;
import blue.hive.spring.http.converter.BHiveMapHttpMessageConverter;
import blue.hive.spring.http.converter.BHiveSecuredHttpMessageConverter;
import blue.hive.spring.http.converter.BHiveTeeHttpMessageConverter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

public class BHiveRestTemplateBuilder {
    static Logger logger = LoggerFactory.getLogger(BHiveRestTemplateBuilder.class);

    public static BHiveRestTemplate buildFormApiTemplate() {
        BHiveRestTemplate restTemplate = new BHiveRestTemplate();
        List<HttpMessageConverter<?>> messageConverters = BHiveRestTemplateBuilder.getHttpMessageConverters(API_TYPE.REQUEST_FORM);
        restTemplate.setMessageConverters(messageConverters);
        List interceptors = restTemplate.getInterceptors();
        interceptors.add(new BHiveLoggingClientHttpRequestInterceptor());
        restTemplate.setInterceptors(interceptors);
        SimpleClientHttpRequestFactory requestFactoryInner = new SimpleClientHttpRequestFactory();
        String proxySet = System.getProperty("proxySet");
        logger.debug("BHiveRestTemplateBuilder - proxySet.{}", (Object)proxySet);
        if ("true".equals(proxySet)) {
            String proxyHost = System.getProperty("proxyHost");
            String proxyPort = System.getProperty("proxyPort");
            logger.debug("BHiveRestTemplateBuilder - proxyHost:{}, proxyPort:{}", (Object)proxyHost, (Object)proxyPort);
            if (!StringUtils.isEmpty((CharSequence)proxyHost) && !StringUtils.isEmpty((CharSequence)proxyPort)) {
                logger.debug("BHiveRestTemplateBuilder - Apply Proxy. {}:{}", (Object)proxyHost, (Object)proxyPort);
                int proxyPortInt = Integer.parseInt(proxyPort);
                SimpleClientHttpRequestFactory requestFactoryInnerTyped = requestFactoryInner;
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPortInt);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                requestFactoryInnerTyped.setProxy(proxy);
            }
        }
        BufferingClientHttpRequestFactory requestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactoryInner);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    public static BHiveRestTemplate buildRestApiTemplate() {
        BHiveRestTemplate restTemplate = new BHiveRestTemplate();
        List<HttpMessageConverter<?>> messageConverters = BHiveRestTemplateBuilder.getHttpMessageConverters(API_TYPE.REQUEST_BODY_JSON);
        restTemplate.setMessageConverters(messageConverters);
        List interceptors = restTemplate.getInterceptors();
        interceptors.add(new BHiveLoggingClientHttpRequestInterceptor());
        restTemplate.setInterceptors(interceptors);
        SimpleClientHttpRequestFactory requestFactoryInner = new SimpleClientHttpRequestFactory();
        String proxySet = System.getProperty("proxySet");
        logger.debug("BHiveRestTemplateBuilder - proxySet.{}", (Object)proxySet);
        if ("true".equals(proxySet)) {
            String proxyHost = System.getProperty("proxyHost");
            String proxyPort = System.getProperty("proxyPort");
            logger.debug("BHiveRestTemplateBuilder - proxyHost:{}, proxyPort:{}", (Object)proxyHost, (Object)proxyPort);
            if (!StringUtils.isEmpty((CharSequence)proxyHost) && !StringUtils.isEmpty((CharSequence)proxyPort)) {
                logger.debug("BHiveRestTemplateBuilder - Apply Proxy. {}:{}", (Object)proxyHost, (Object)proxyPort);
                int proxyPortInt = Integer.parseInt(proxyPort);
                SimpleClientHttpRequestFactory requestFactoryInnerTyped = requestFactoryInner;
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPortInt);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                requestFactoryInnerTyped.setProxy(proxy);
            }
        }
        BufferingClientHttpRequestFactory requestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactoryInner);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    public static BHiveRestTemplate buildSecureRestApiTemplate(String secretKey) {
        BHiveRestTemplate restTemplate = BHiveRestTemplateBuilder.buildRestTemplate(API_TYPE.REQUEST_BODY_SECURED_JSON, secretKey);
        return restTemplate;
    }

    private static BHiveRestTemplate buildRestTemplate(API_TYPE apiType, String secretKey) {
        BHiveRestTemplate restTemplate = new BHiveRestTemplate();
        List<HttpMessageConverter<?>> messageConverters = BHiveRestTemplateBuilder.getHttpMessageConverters(apiType, secretKey);
        restTemplate.setMessageConverters(messageConverters);
        List interceptors = restTemplate.getInterceptors();
        interceptors.add(new BHiveLoggingClientHttpRequestInterceptor());
        restTemplate.setInterceptors(interceptors);
        SimpleClientHttpRequestFactory requestFactoryInner = new SimpleClientHttpRequestFactory();
        String proxySet = System.getProperty("proxySet");
        logger.debug("BHiveRestTemplateBuilder - proxySet.{}", (Object)proxySet);
        if ("true".equals(proxySet)) {
            String proxyHost = System.getProperty("proxyHost");
            String proxyPort = System.getProperty("proxyPort");
            logger.debug("BHiveRestTemplateBuilder - proxyHost:{}, proxyPort:{}", (Object)proxyHost, (Object)proxyPort);
            if (!StringUtils.isEmpty((CharSequence)proxyHost) && !StringUtils.isEmpty((CharSequence)proxyPort)) {
                logger.debug("BHiveRestTemplateBuilder - Apply Proxy. {}:{}", (Object)proxyHost, (Object)proxyPort);
                int proxyPortInt = Integer.parseInt(proxyPort);
                SimpleClientHttpRequestFactory requestFactoryInnerTyped = requestFactoryInner;
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPortInt);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                requestFactoryInnerTyped.setProxy(proxy);
            }
        }
        BufferingClientHttpRequestFactory requestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactoryInner);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    private static List<HttpMessageConverter<?>> getHttpMessageConverters(API_TYPE apiType) {
        ArrayList messageConverters = new ArrayList();
        if (apiType.equals((Object)API_TYPE.REQUEST_BODY_JSON)) {
            messageConverters.add(new BHiveTeeHttpMessageConverter(BHiveRestTemplateBuilder.getNonSecuredJsonConverter()));
        } else if (apiType.equals((Object)API_TYPE.REQUEST_FORM)) {
            messageConverters.add(new BHiveTeeHttpMessageConverter(new AllEncompassingFormHttpMessageConverter()));
            messageConverters.add(new BHiveTeeHttpMessageConverter(new BHiveMapHttpMessageConverter()));
            messageConverters.add(new BHiveTeeHttpMessageConverter(new StringHttpMessageConverter()));
            messageConverters.add(new BHiveTeeHttpMessageConverter(BHiveRestTemplateBuilder.getNonSecuredJsonConverter()));
        }
        return messageConverters;
    }

    private static List<HttpMessageConverter<?>> getHttpMessageConverters(API_TYPE apiType, String secretKey) {
        ArrayList messageConverters = new ArrayList();
        if (apiType.equals((Object)API_TYPE.REQUEST_BODY_SECURED_JSON)) {
            HttpMessageConverter<?> converter = BHiveRestTemplateBuilder.getSecuredJsonConverter(secretKey);
            messageConverters.add(converter);
        }
        return messageConverters;
    }

    private static HttpMessageConverter<?> getSecuredJsonConverter(String secretKey) {
        MappingJackson2HttpMessageConverter httpConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(new MediaType("application", "secured+json", Charset.forName("UTF-8")));
        httpConverter.setSupportedMediaTypes(mediaTypes);
        AES256Crypto crypto = new AES256Crypto(secretKey);
        BHiveSecuredHttpMessageConverter converter = new BHiveSecuredHttpMessageConverter(crypto, httpConverter);
        return converter;
    }

    private static MappingJackson2HttpMessageConverter getNonSecuredJsonConverter() {
        MappingJackson2HttpMessageConverter httpConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(new MediaType("application", "json", Charset.forName("UTF-8")));
        mediaTypes.add(new MediaType("application", "*+json", Charset.forName("UTF-8")));
        httpConverter.setSupportedMediaTypes(mediaTypes);
        return httpConverter;
    }
}

