/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.servlet.filter.wrap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BHiveTeeServletOutputStream
extends ServletOutputStream {
    static final Logger logger = LoggerFactory.getLogger(BHiveTeeServletOutputStream.class);
    final ServletOutputStream underlyingStream;
    final ByteArrayOutputStream baosCopy;

    BHiveTeeServletOutputStream(ServletResponse httpServletResponse) throws IOException {
        logger.trace("TeeServletOutputStream.constructor() called");
        this.underlyingStream = httpServletResponse.getOutputStream();
        this.baosCopy = new ByteArrayOutputStream();
    }

    byte[] getOutputStreamAsByteArray() {
        return this.baosCopy.toByteArray();
    }

    public void write(int val) throws IOException {
        if (this.underlyingStream != null) {
            this.underlyingStream.write(val);
            this.baosCopy.write(val);
        }
    }

    public void write(byte[] byteArray) throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int offset, int length) throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        logger.trace("WRITE TeeServletOutputStream.write(byte[], int, int) called. offset:{}, length:{}, byteArray: {}", new Object[]{offset, length, StringUtils.trimTrailingWhitespace((String)new String(byteArray, offset, length, "UTF-8"))});
        this.underlyingStream.write(byteArray, offset, length);
        this.baosCopy.write(byteArray, offset, length);
    }

    public void close() throws IOException {
        logger.trace("CLOSE TeeServletOutputStream.close() called");
    }

    public void flush() throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        logger.trace("FLUSH TeeServletOutputStream.flush() called");
        this.underlyingStream.flush();
        this.baosCopy.flush();
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

