/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.jackson;

import blue.hive.jackson.datatype.joda.BHiveLocalDateTimeDeserialiser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.tiles.request.ApplicationContext;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class BHiveObjectMapper
extends ObjectMapper
implements Externalizable {
    private static final long serialVersionUID = 9103711369247336228L;
    protected static final Logger logger = LoggerFactory.getLogger(BHiveObjectMapper.class);
    private ClassLoader moduleClassLoader = this.getClass().getClassLoader();
    private static String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public BHiveObjectMapper() {
        this(null, DEFAULT_DATETIME_FORMAT);
    }

    public BHiveObjectMapper(ApplicationContext applicationContext) {
        this(applicationContext, DEFAULT_DATETIME_FORMAT);
    }

    public BHiveObjectMapper(String simpleDateTimeFormat) {
        this(null, simpleDateTimeFormat);
    }

    public BHiveObjectMapper(ApplicationContext applicationContext, String simpleDateTimeFormat) {
        this.registerWellKnownModulesIfAvailable(this);
        this.disable(SerializationFeature.INDENT_OUTPUT);
        this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.setTimeZone(TimeZone.getDefault());
        if (simpleDateTimeFormat != null) {
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            SimpleDateFormat dateFormat = new SimpleDateFormat(simpleDateTimeFormat);
            this.setDateFormat(dateFormat);
        }
        this.registerCustomModules();
    }

    private void registerCustomModules() {
        SimpleModule module = new SimpleModule("bhive HTML XSS Serializer");
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new BHiveLocalDateTimeDeserialiser());
        this.registerModule((Module)module);
    }

    private void registerWellKnownModulesIfAvailable(ObjectMapper mapper) {
        if (ClassUtils.isPresent((String)"java.time.LocalDate", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class jsr310Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jsr310.JSR310Module", (ClassLoader)this.moduleClassLoader);
                mapper.registerModule((Module)BeanUtils.instantiateClass((Class)jsr310Module));
            }
            catch (ClassNotFoundException jsr310Module) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class jodaModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)this.moduleClassLoader);
                mapper.registerModule((Module)BeanUtils.instantiateClass((Class)jodaModule));
            }
            catch (ClassNotFoundException jodaModule) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class hibernate4Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module", (ClassLoader)this.moduleClassLoader);
                mapper.registerModule((Module)BeanUtils.instantiateClass((Class)hibernate4Module));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

