/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.querydsl;

import com.mysema.query.types.Predicate;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QuerydslPredicateArgumentResolver
implements HandlerMethodArgumentResolver {
    private final QuerydslBindingsFactory bindingsFactory;
    private final QuerydslPredicateBuilder predicateBuilder;

    public QuerydslPredicateArgumentResolver(QuerydslBindingsFactory factory, ConversionService conversionService) {
        this.bindingsFactory = factory;
        this.predicateBuilder = new QuerydslPredicateBuilder((ConversionService)(conversionService == null ? new DefaultConversionService() : conversionService), factory.getEntityPathResolver());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (Predicate.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        if (parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            throw new IllegalArgumentException(String.format("Parameter at position %s must be of type Predicate but was %s.", parameter.getParameterIndex(), parameter.getParameterType()));
        }
        return false;
    }

    public Predicate resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        for (Map.Entry entry : webRequest.getParameterMap().entrySet()) {
            parameters.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        TypeInformation<?> domainType = QuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getActualType();
        Class<? extends QuerydslBinderCustomizer> customizer = annotation == null ? null : annotation.bindings();
        QuerydslBindings bindings = this.bindingsFactory.createBindingsFor(customizer, domainType);
        return this.predicateBuilder.getPredicate(domainType, (MultiValueMap<String, String>)parameters, bindings);
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        if (annotation != null && !Object.class.equals(annotation.root())) {
            return ClassTypeInformation.from(annotation.root());
        }
        return QuerydslPredicateArgumentResolver.detectDomainType(ClassTypeInformation.fromReturnTypeOf(parameter.getMethod()));
    }

    private static TypeInformation<?> detectDomainType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation<?> actualType = source.getActualType();
        if (source != actualType) {
            return QuerydslPredicateArgumentResolver.detectDomainType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return QuerydslPredicateArgumentResolver.detectDomainType(source.getComponentType());
    }
}

