/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util.anyframe;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class StringUtil {
    private static final char[] ALPHAS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'X', 'Y', 'V', 'W', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'x', 'y', 'v', 'w', 'z'};
    public static final String DEFAULT_EMPTY_STRING = "";
    private static final Random GENERATOR = new Random(System.currentTimeMillis());
    private static final int ONE_BYTE = 127;
    private static final int THREE_BYTE = 65535;
    private static final int TWO_BYTE = 2047;

    private StringUtil() {
        throw new AssertionError();
    }

    public static String addSpace(String str, int size) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str == null) {
            if (size == 0) {
                return null;
            }
        } else {
            stringBuffer.append(str);
        }
        for (int j = 0; j < size; ++j) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public static String fillString(String str, char padChar, int ciphers) {
        int originalStrLength = str.length();
        if (ciphers < originalStrLength) {
            return null;
        }
        int difference = ciphers - originalStrLength;
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < difference; ++i) {
            strBuf.append(padChar);
        }
        strBuf.append(str);
        return strBuf.toString();
    }

    public static String[] addStringToArray(String[] strings, String str) {
        String[] newArray = new String[strings.length + 1];
        System.arraycopy(strings, 0, newArray, 0, strings.length);
        newArray[strings.length] = str;
        return newArray;
    }

    public static String applyInitialLaw(String str) {
        String[] fstPtnP = new String[]{"\ub77c", "\ub85c", "\ub7c9", "\ub9ac", "\ub9bc", "\ub791", "\ub958", "\ub8b0", "\ub780"};
        String[] fstPtnN = new String[]{"\ub098", "\ub178", "\uc591", "\uc774", "\uc784", "\ub0ad", "\uc720", "\ub1cc", "\ub09c"};
        String[] sndPtnP = new String[]{"\ub840", "\ub96d", "\ub780", "\ub960", "\ub798", "\ub85c", "\ub7c9", "\ub77d", "\ub77c", "\ub2d8", "\ub9bc", "\ub828", "\ub144", "\ub2c8", "\ub9ac", "\ub95c", "\ub791", "\ub8f0", "\ub9b0", "\ub78c", "\ub155", "\ub839", "\ub871", "\ub8e1", "\ub8cc", "\ub9bd", "\ub85d", "\ub958", "\ub82c", "\ub989", "\ub140", "\ub824", "\ub1e8", "\ub274", "\ub834", "\ub150", "\ub2c9", "\ub825", "\ub8e8", "\ub974", "\ub860", "\ub8b0"};
        String[] sndPtnN = new String[]{"\uc608", "\uc735", "\ub09c", "\uc728", "\ub0b4", "\ub178", "\uc591", "\ub099", "\ub098", "\uc784", "\uc784", "\uc5f0", "\uc5f0", "\uc774", "\uc774", "\uc724", "\ub0ad", "\uc6b8", "\uc778", "\ub0a8", "\uc601", "\uc601", "\ub18d", "\uc6a9", "\uc694", "\uc785", "\ub179", "\uc720", "\uc5f4", "\ub2a5", "\uc5ec", "\uc5ec", "\uc694", "\ub274", "\uc5fc", "\uc5fc", "\uc775", "\uc5ed", "\ub204", "\ub290", "\ub17c", "\ub1cc"};
        String outStr = DEFAULT_EMPTY_STRING;
        String[] inStrAry = null;
        str = str.trim();
        int inStrSize = str.length();
        char[] chStrAry = str.toCharArray();
        if (inStrSize > 0) {
            int i;
            inStrAry = new String[inStrSize];
            for (i = 0; i < inStrSize; ++i) {
                inStrAry[i] = String.valueOf(chStrAry[i]);
            }
            for (i = 0; i < fstPtnP.length; ++i) {
                if (inStrAry[0].compareTo(fstPtnP[i]) == 0) {
                    inStrAry[0] = fstPtnN[i];
                }
                outStr = inStrAry[0];
            }
        }
        StringBuffer sb = new StringBuffer();
        if (inStrSize > 1) {
            inStrAry = new String[inStrSize];
            for (int i = 1; i < inStrSize; ++i) {
                boolean isExsit = false;
                inStrAry[i] = String.valueOf(chStrAry[i]);
                for (int j = 0; j < sndPtnP.length; ++j) {
                    if (inStrAry[i].compareTo(sndPtnP[j]) != 0 || isExsit) continue;
                    sb.append(sndPtnN[j]);
                    isExsit = true;
                }
                if (isExsit) continue;
                sb.append(inStrAry[i]);
            }
            outStr = outStr + sb.toString();
        }
        return outStr;
    }

    @Deprecated
    public static String arrayToCommaDelimitedString(Object[] array) {
        return StringUtil.arrayToDelimitedString(array, ",");
    }

    public static String arrayToDelimitedString(Object[] objects) {
        return StringUtil.arrayToDelimitedString(objects, ",");
    }

    public static String arrayToDelimitedString(Object[] objects, String delimiter) {
        if (objects == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(objects[i]);
        }
        return sb.toString();
    }

    @Deprecated
    public static String collectionToCommaDelimitedString(Collection<String> collection) {
        return StringUtil.collectionToDelimitedString(collection, ",");
    }

    public static String collectionToDelimitedString(Collection<String> strings) {
        return StringUtil.collectionToDelimitedString(strings, ",");
    }

    public static String collectionToDelimitedString(Collection<String> strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = strings.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i++ > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static Set<String> commaDelimitedStringToSet(String str) {
        HashSet<String> set = new HashSet<String>();
        String[] tokens = StringUtil.tokenizeToStringArray(str);
        if (tokens == null) {
            return null;
        }
        for (int i = 0; i < tokens.length; ++i) {
            set.add(tokens[i]);
        }
        return set;
    }

    @Deprecated
    public static String[] commaDelimitedStringToStringArray(String str) {
        return StringUtil.delimitedStringToStringArray(str, ",");
    }

    public static String asteriskToSpace(String str) {
        String target = DEFAULT_EMPTY_STRING;
        target = str.replaceAll("\\*\\*", " ");
        target = target.replaceAll("\\*", " ");
        return target;
    }

    public static String swapFirstLetterCase(String str) {
        if (Character.isLowerCase(str.substring(0, 1).toCharArray()[0])) {
            return StringUtil.changeFirstCharacterCase(true, str);
        }
        return StringUtil.changeFirstCharacterCase(false, str);
    }

    private static String changeFirstCharacterCase(boolean capitalize, String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static int compareTo(String sourceStr, String targetStr) {
        if (sourceStr == null || targetStr == null) {
            return -1;
        }
        return sourceStr.compareTo(targetStr);
    }

    public static int compareToIgnoreCase(String sourceStr, String targetStr) {
        if (sourceStr == null || targetStr == null) {
            return -1;
        }
        return sourceStr.compareToIgnoreCase(targetStr);
    }

    @Deprecated
    public static boolean containsInvalidChars(String str, char[] invalidChars) {
        if (str == null || invalidChars == null) {
            return false;
        }
        return StringUtil.containsAnyChar(str, invalidChars);
    }

    public static boolean containsAny(String str, char[] chars) {
        if (str == null || chars == null) {
            return false;
        }
        return StringUtil.containsAnyChar(str, chars);
    }

    private static boolean containsAnyChar(String str, char[] chars) {
        int strSize = str.length();
        int validSize = chars.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (chars[j] != ch) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean containsInvalidChars(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        return StringUtil.containsInvalidChars(str, invalidChars.toCharArray());
    }

    public static boolean containsAny(String str, String chars) {
        if (str == null || chars == null) {
            return false;
        }
        return StringUtil.containsAnyChar(str, chars.toCharArray());
    }

    @Deprecated
    public static boolean containsMaxSequence(String str, String maxSeqNumber) {
        int occurence = 1;
        int max = NumberUtils.toInt((String)maxSeqNumber);
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz - 1; ++i) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                if (++occurence != max) continue;
                return true;
            }
            occurence = 1;
        }
        return false;
    }

    public static boolean containsMaxOccurences(String str, String maxSeqNumber) {
        int occurence = 1;
        int max = NumberUtils.toInt((String)maxSeqNumber);
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz - 1; ++i) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                if (++occurence != max) continue;
                return true;
            }
            occurence = 1;
        }
        return false;
    }

    public static String convertToCamelCase(String str) {
        return StringUtil.convertToCamelCase(str, '_');
    }

    public static String convertToCamelCase(String str, char delimiter) {
        StringBuilder result = new StringBuilder();
        boolean nextUpper = false;
        String allLower = str.toLowerCase();
        for (int i = 0; i < allLower.length(); ++i) {
            char currentChar = allLower.charAt(i);
            if (currentChar == delimiter) {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                currentChar = Character.toUpperCase(currentChar);
                nextUpper = false;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static String convertToUnderScore(String str) {
        String result = DEFAULT_EMPTY_STRING;
        for (int i = 0; i < str.length(); ++i) {
            char currentChar = str.charAt(i);
            if (i > 0 && Character.isUpperCase(currentChar)) {
                result = result.concat("_");
            }
            result = result.concat(Character.toString(currentChar).toLowerCase());
        }
        return result;
    }

    @Deprecated
    public static int countPattern(String str, String pattern) {
        if (str == null || pattern == null || DEFAULT_EMPTY_STRING.equals(pattern)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        int index = 0;
        while ((index = str.indexOf(pattern, pos)) != -1) {
            ++count;
            pos = index + pattern.length();
        }
        return count;
    }

    public static String decode(String source, String target, String result, String base) {
        if (source.trim().equals(target)) {
            return result;
        }
        return base;
    }

    @Deprecated
    public static String deleteChars(String str, String chars) {
        if (str == null || chars == null) {
            return str;
        }
        String value = str;
        for (int i = 0; i < chars.length(); ++i) {
            value = StringUtil.removeChar(value, chars.charAt(i));
        }
        return value;
    }

    @Deprecated
    public static String deletePattern(String str, String pattern) {
        return StringUtil.replacePattern(str, pattern, DEFAULT_EMPTY_STRING);
    }

    @Deprecated
    public static String[] delimitedStringToStringArray(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int pos = 0;
        int index = 0;
        while ((index = str.indexOf(delimiter, pos)) != -1) {
            tokens.add(str.substring(pos, index));
            pos = index + delimiter.length();
        }
        if (pos <= str.length()) {
            tokens.add(str.substring(pos));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static int getByteLength(char ch) {
        char charCode = ch;
        if (charCode <= '\u007f') {
            return 1;
        }
        if (charCode <= '\u07ff') {
            return 2;
        }
        if (charCode <= '\uffff') {
            return 3;
        }
        return 4;
    }

    public static int getByteLength(String str) {
        if (str == null) {
            return -1;
        }
        int size = 0;
        for (int i = 0; i < str.length(); ++i) {
            size += StringUtil.getByteLength(str.charAt(i));
        }
        return size;
    }

    @Deprecated
    public static int getContainsCount(String str, char[] chars) {
        if (str == null || chars == null) {
            return -1;
        }
        int strSize = str.length();
        int validSize = chars.length;
        int check = 0;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (chars[j] != ch) continue;
                ++check;
            }
        }
        return check;
    }

    public static int countMatches(String str, char[] chars) {
        return StringUtil.countMatches(str, new String(chars));
    }

    @Deprecated
    public static int getContainsCount(String str, String sub) {
        return StringUtils.countOccurrencesOf((String)str, (String)sub);
    }

    public static int countMatches(String str, String sub) {
        return StringUtils.countOccurrencesOf((String)str, (String)sub);
    }

    @Deprecated
    public static int getContainsCountIgnoreCase(String str, char[] chars) {
        char[] lowerChar = new char[chars.length];
        for (int j = 0; j < chars.length; ++j) {
            String res = String.valueOf(chars[j]).toLowerCase();
            lowerChar[j] = res.charAt(0);
        }
        return StringUtil.getContainsCount(str.toLowerCase(), lowerChar);
    }

    public static int countMatchesIgnoreCase(String str, char[] chars) {
        char[] lowerChar = new char[chars.length];
        for (int j = 0; j < chars.length; ++j) {
            String res = String.valueOf(chars[j]).toLowerCase();
            lowerChar[j] = res.charAt(0);
        }
        return StringUtil.countMatches(str.toLowerCase(), lowerChar);
    }

    @Deprecated
    public static int getContainsCountIgnoreCase(String str, String sub) {
        return StringUtils.countOccurrencesOf((String)str.toLowerCase(), (String)sub.toLowerCase());
    }

    public static int countMatchesIgnoreCase(String str, String sub) {
        return StringUtils.countOccurrencesOf((String)str.toLowerCase(), (String)sub.toLowerCase());
    }

    @Deprecated
    public static String getCutString(String str, int length) {
        String result = DEFAULT_EMPTY_STRING;
        if (str != null) {
            result = StringUtil.getLength(str) > length ? str.substring(0, length) : str;
        }
        return result;
    }

    public static String getLastString(String str, String token) {
        StringTokenizer tokenizer = new StringTokenizer(str, token);
        String lastStr = DEFAULT_EMPTY_STRING;
        while (tokenizer.hasMoreTokens()) {
            lastStr = tokenizer.nextToken();
        }
        return lastStr;
    }

    public static int getLength(String str) {
        if (str == null) {
            return -1;
        }
        return str.length();
    }

    public static String getRandomString(int size) {
        return StringUtil.randomAlphabetic(size);
    }

    public static String getRandomString(int minSize, int maxSize) {
        Random generator = new Random(System.currentTimeMillis());
        int randomLength = generator.nextInt(maxSize - minSize) + minSize;
        return StringUtil.randomAlphabetic(randomLength);
    }

    public static String getRandomString(int size, char startChar, char endChar) {
        int startInt = startChar;
        int endInt = endChar;
        int gap = endInt - startInt;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            int chInt;
            while (!Character.toString((char)(chInt = GENERATOR.nextInt(gap + 1) + startInt)).matches("^[a-zA-Z]$")) {
            }
            buf.append((char)chInt);
        }
        return buf.toString();
    }

    public static String getRandomStringByCharset(int size, String charset) throws UnsupportedEncodingException {
        String randomStr = StringUtil.getRandomString(size);
        return StringUtil.convertStringCharset(randomStr, charset);
    }

    public static String getRandomStringByKorean(int size) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            buf.append((char)(GENERATOR.nextInt(11172) + 44032));
        }
        return buf.toString();
    }

    @Deprecated
    public static String[] getStringArray(String str, String strToken) {
        if (str.indexOf(strToken) != -1) {
            StringTokenizer st = new StringTokenizer(str, strToken);
            String[] stringArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                stringArray[i] = st.nextToken();
                ++i;
            }
            return stringArray;
        }
        return new String[]{str};
    }

    public static List<String> getTokens(String str) {
        return StringUtil.getTokens(str, ",");
    }

    public static List<String> getTokens(String str, String delimeter) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delimeter);
            while (st.hasMoreTokens()) {
                String en = st.nextToken().trim();
                tokens.add(en);
            }
        }
        return tokens;
    }

    public static boolean hasLength(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean hasText(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String hexToString(String str) {
        String inStr = str;
        char[] inChar = inStr.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inChar.length; i += 4) {
            String hex = str.substring(i, i + 4);
            sb.append((char)Integer.parseInt(hex, 16));
        }
        return sb.toString();
    }

    public static int indexOf(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.indexOf(search);
    }

    public static int indexOfIgnoreCase(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.toLowerCase().indexOf(search.toLowerCase());
    }

    @Deprecated
    public static String integer2string(int integer) {
        return DEFAULT_EMPTY_STRING + integer;
    }

    @Deprecated
    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isAlphaNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isDigit(String str) {
        if (str == null) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyTrimmed(String str) {
        if (str == null) {
            return true;
        }
        return StringUtil.isEmpty(str.trim());
    }

    public static boolean isHangul(char achar) {
        String unicodeBlock = Character.UnicodeBlock.of(achar).toString();
        return "HANGUL_JAMO".equals(unicodeBlock) || "HANGUL_SYLLABLES".equals(unicodeBlock) || "HANGUL_COMPATIBILITY_JAMO".equals(unicodeBlock);
    }

    public static boolean isHangul(String str, boolean checkForAll) {
        char[] chars = str.toCharArray();
        if (!checkForAll) {
            for (int i = 0; i < chars.length; ++i) {
                if (!StringUtil.isHangul(chars[i])) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isHangul(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigit(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    @Deprecated
    public static boolean isNotNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isSpaceOnly(String str) {
        if (str == null) {
            return false;
        }
        return StringUtil.isEmptyTrimmed(str);
    }

    public static boolean isWhiteSpaceOnly(String str) {
        if (str == null) {
            return false;
        }
        return StringUtil.isEmptyTrimmed(str);
    }

    public static String left(String str, int size) {
        if (str == null) {
            return null;
        }
        if (size <= 0 || str.length() <= size) {
            return str;
        }
        return str.substring(0, size);
    }

    public static String leftPad(String str, int size) {
        return StringUtil.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        return StringUtil.padString(str, size, String.valueOf(padChar), true);
    }

    public static String leftPad(String str, int size, String padStr) {
        return StringUtil.padString(str, size, padStr, true);
    }

    public static String leftTrim(String str) {
        return StringUtils.trimLeadingWhitespace((String)str);
    }

    public static String newLineToSpace(String str) {
        return str.replace("\r\n", " ");
    }

    @Deprecated
    public static String null2str(String org) {
        return StringUtil.null2str(org, DEFAULT_EMPTY_STRING);
    }

    public static String nullToString(String org) {
        return StringUtil.nullToString(org, DEFAULT_EMPTY_STRING);
    }

    @Deprecated
    public static String null2str(String org, String converted) {
        if (StringUtil.isEmptyTrimmed(org)) {
            return converted;
        }
        return org.trim();
    }

    public static String nullToString(String str, String defaultStr) {
        if (StringUtil.isEmptyTrimmed(str)) {
            return defaultStr;
        }
        return str.trim();
    }

    public static String nullToEmpty(String str) {
        if (StringUtil.isEmpty(str)) {
            return DEFAULT_EMPTY_STRING;
        }
        return str;
    }

    @Deprecated
    public static String numberFormat(double d, String format) {
        DecimalFormat decimalformat = new DecimalFormat(format);
        return decimalformat.format(d);
    }

    @Deprecated
    public static String numberFormat(float f, String format) {
        DecimalFormat decimalformat = new DecimalFormat(format);
        return decimalformat.format(f);
    }

    @Deprecated
    public static String numberFormat(int i, String format) {
        DecimalFormat decimalformat = new DecimalFormat(format);
        return decimalformat.format(i);
    }

    @Deprecated
    public static String numberFormat(long l, String format) {
        DecimalFormat decimalformat = new DecimalFormat(format);
        return decimalformat.format(l);
    }

    @Deprecated
    public static String numberFormat(short s, String format) {
        DecimalFormat decimalformat = new DecimalFormat(format);
        return decimalformat.format(s);
    }

    @Deprecated
    public static Object nvl(Object inputObject, Object defaultObject) {
        return inputObject != null ? inputObject : defaultObject;
    }

    public static Object nullToObject(Object obj, Object defaultObj) {
        return obj != null ? obj : defaultObj;
    }

    @Deprecated
    public static String nvl(String inputString, String defaultString) {
        return (String)StringUtil.nvl((Object)inputString, (Object)defaultString);
    }

    @Deprecated
    public static String padding(int size, char padChar) {
        if (size < 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            buffer.insert(i, padChar);
        }
        return buffer.toString();
    }

    public static String repeat(int size, char ch) {
        return StringUtil.leftPad(DEFAULT_EMPTY_STRING, size, ch);
    }

    private static String padString(String str, int size, String padStr, boolean isLeft) {
        if (str == null) {
            return null;
        }
        int originalStrLength = str.length();
        if (size < originalStrLength) {
            return str;
        }
        int difference = size - originalStrLength;
        StringBuilder sb = new StringBuilder();
        if (difference > 0) {
            if (padStr == null || DEFAULT_EMPTY_STRING.equals(padStr)) {
                padStr = " ";
            }
            block0: do {
                for (int j = 0; j < padStr.length(); ++j) {
                    sb.append(padStr.charAt(j));
                    if (str.length() + sb.toString().length() >= size) continue block0;
                }
            } while (difference > sb.toString().length());
            str = isLeft ? sb.toString() + str : str + sb.toString();
        }
        return str;
    }

    public static String pathClean(String path) {
        if (path == null) {
            return null;
        }
        String p = StringUtil.replacePattern(path, "\\", "/");
        String[] pArray = StringUtil.tokenizeToStringArray(p, "/");
        LinkedList<String> pList = new LinkedList<String>();
        int tops = 0;
        for (int i = pArray.length - 1; i >= 0; --i) {
            if (".".equals(pArray[i])) continue;
            if ("..".equals(pArray[i])) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pList.add(0, pArray[i]);
        }
        return StringUtil.collectionToDelimitedString(pList, "/");
    }

    public static boolean pathEquals(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        return StringUtil.pathClean(path1).equals(StringUtil.pathClean(path2));
    }

    private static String randomAlphabetic(int size) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            buf.append(ALPHAS[GENERATOR.nextInt(52)]);
        }
        return buf.toString();
    }

    @Deprecated
    public static String removeAll(String str, String charsToDelete) {
        return StringUtils.deleteAny((String)str, (String)charsToDelete);
    }

    @Deprecated
    public static String removeChar(String str, char remove) {
        return StringUtil.replacePattern(str, String.valueOf(remove), DEFAULT_EMPTY_STRING);
    }

    @Deprecated
    public static String removeCharAll(String str) {
        char[] targetCharacters = new char[]{'/', '-', ':', ',', '.', '%'};
        return StringUtil.removeCharAll(str, targetCharacters);
    }

    @Deprecated
    public static String removeCharAll(String str, char[] remove) {
        String value = str;
        for (int i = 0; i < remove.length; ++i) {
            value = StringUtil.removeChar(value, remove[i]);
        }
        return value;
    }

    public static String deleteAny(String str, String charsToDelete) {
        return StringUtils.deleteAny((String)str, (String)charsToDelete);
    }

    public static String deleteAny(String str, char[] charsToDelete) {
        return StringUtil.deleteAny(str, new String(charsToDelete));
    }

    public static String deleteAny(String str, char charToDelete) {
        return StringUtil.deleteAny(str, String.valueOf(charToDelete));
    }

    public static String deleteMatches(String str, String subStr) {
        return StringUtils.delete((String)str, (String)subStr);
    }

    public static String deleteFirstMatches(String str, String deletedStr) {
        int startIndex = str.indexOf(deletedStr);
        if (startIndex != -1) {
            int endIndex = deletedStr.length() + startIndex;
            return str.substring(0, startIndex) + str.substring(endIndex);
        }
        return str;
    }

    public static String removeWhitespace(String str) {
        return StringUtils.trimAllWhitespace((String)str);
    }

    @Deprecated
    public static String replace(String str, String replacedStr, String replacement) {
        String newStr = str;
        if (str.indexOf(replacedStr) != -1) {
            String s1 = str.substring(0, str.indexOf(replacedStr));
            String s2 = str.substring(str.indexOf(replacedStr) + 1);
            newStr = s1 + replacement + s2;
        }
        return newStr;
    }

    public static String replaceAll(String str, String regex, String replacement) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String src, String regex, String replacement) {
        if (src == null) {
            return null;
        }
        return src.replaceFirst(regex, replacement);
    }

    public static String replaceLast(String str, String regex, String replacement) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        if (!matcher.find()) {
            return str;
        }
        int lastMatchStart = 0;
        do {
            lastMatchStart = matcher.start();
        } while (matcher.find());
        matcher.find(lastMatchStart);
        StringBuffer sb = new StringBuffer(str.length());
        matcher.appendReplacement(sb, replacement);
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    public static String replacePattern(String str, String replacedStr, String replacement) {
        if (str == null) {
            return null;
        }
        if (replacedStr == null || replacement == null) {
            return str;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = str.indexOf(replacedStr);
        int patLen = replacedStr.length();
        while (index >= 0) {
            sbuf.append(str.substring(pos, index));
            sbuf.append(replacement);
            pos = index + patLen;
            index = str.indexOf(replacedStr, pos);
        }
        sbuf.append(str.substring(pos));
        return sbuf.toString();
    }

    @Deprecated
    public static String replaceHtmlEscape(String str) {
        return HtmlUtils.htmlEscape((String)str);
    }

    public static String htmlEscape(String input) {
        return HtmlUtils.htmlEscape((String)input);
    }

    @Deprecated
    public static String removeEscapeChar(String str) {
        return HtmlUtils.htmlUnescape((String)str);
    }

    public static String htmlUnescape(String input) {
        return HtmlUtils.htmlUnescape((String)input);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String right(String str, int size) {
        if (str == null) {
            return null;
        }
        if (size <= 0 || str.length() <= size) {
            return str;
        }
        return str.substring(str.length() - size);
    }

    public static String rightPad(String str, int size) {
        return StringUtil.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        return StringUtil.padString(str, size, String.valueOf(padChar), false);
    }

    public static String rightPad(String str, int size, String padStr) {
        return StringUtil.padString(str, size, padStr, false);
    }

    public static String rightTrim(String str) {
        return StringUtils.trimTrailingWhitespace((String)str);
    }

    @Deprecated
    public static String[] split(String str, char separator) {
        StringBuffer tempStringBuffer = new StringBuffer();
        tempStringBuffer.append(separator);
        return StringUtil.tokenizeToStringArray(str, tempStringBuffer.toString(), false, false);
    }

    @Deprecated
    public static String splitHead(String str, int size) {
        if (str == null) {
            return DEFAULT_EMPTY_STRING;
        }
        if (str.length() > size) {
            str = str.substring(0, size);
        }
        return str;
    }

    @Deprecated
    public static String splitHeadWithEllipsis(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len <= 0 || str.length() <= len) {
            return str;
        }
        return str.substring(0, len) + "...";
    }

    public static String abbreviateFromLeft(String str, int size) {
        if (str == null) {
            return null;
        }
        if (size <= 0 || str.length() <= size) {
            return str;
        }
        return str.substring(0, size) + "...";
    }

    @Deprecated
    public static String splitTail(String str, int size) {
        if (str == null) {
            return DEFAULT_EMPTY_STRING;
        }
        if (str.length() > size) {
            str = str.substring(str.length() - size);
        }
        return str;
    }

    @Deprecated
    public static String splitTailWithEllipsis(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len <= 0 || str.length() <= len) {
            return str;
        }
        return "..." + str.substring(str.length() - len);
    }

    public static String abbreviateFromRight(String str, int size) {
        if (str == null) {
            return null;
        }
        if (size <= 0 || str.length() <= size) {
            return str;
        }
        return "..." + str.substring(str.length() - size);
    }

    @Deprecated
    public static int string2integer(String str) {
        int ret = Integer.parseInt(str.trim());
        return ret;
    }

    @Deprecated
    public static BigDecimal stringToBigDecimal(String str) {
        if (DEFAULT_EMPTY_STRING.equals(StringUtil.rightTrim(str))) {
            return new BigDecimal(0);
        }
        return new BigDecimal(str);
    }

    @Deprecated
    public static BigDecimal stringToBigDecimal(String str, int pos, int len) {
        if (DEFAULT_EMPTY_STRING.equals(StringUtil.rightTrim(str))) {
            return new BigDecimal(0);
        }
        if (str.length() < pos + len) {
            return StringUtil.stringToBigDecimal(StringUtil.leftPad(str, pos + len, "0"));
        }
        return StringUtil.stringToBigDecimal(str.substring(pos, pos + len));
    }

    public static String stringToHex(String str) {
        String inStr = str;
        char[] inChar = inStr.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inChar.length; ++i) {
            String hex = Integer.toHexString(inChar[i]);
            if (hex.length() == 2) {
                hex = "00" + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    @Deprecated
    public static int stringToNumn(String str) {
        if (DEFAULT_EMPTY_STRING.equals(StringUtil.rightTrim(str))) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    @Deprecated
    public static int stringToNumn(String str, int pos, int len) {
        if (DEFAULT_EMPTY_STRING.equals(StringUtil.rightTrim(str))) {
            return 0;
        }
        if (str.length() < pos + len) {
            return StringUtil.stringToNumn(StringUtil.leftPad(str, pos + len, "0"));
        }
        return StringUtil.stringToNumn(str.substring(pos, pos + len));
    }

    public static String toBusinessNoPattern(String str) {
        if (str == null) {
            return DEFAULT_EMPTY_STRING;
        }
        if (str.length() != 10 || !NumberUtils.isDigits((String)str)) {
            return DEFAULT_EMPTY_STRING;
        }
        return String.format("%s-%s-%s", str.substring(0, 3), str.substring(3, 5), str.substring(5, 10));
    }

    public static String[] tokenizeToStringArray(String str) {
        return StringUtil.tokenizeToStringArray(str, ",", false, false);
    }

    public static String[] tokenizeToStringArray(String str, char delimeter) {
        return StringUtil.tokenizeToStringArray(str, String.valueOf(delimeter), false, false);
    }

    public static String[] tokenizeToStringArray(String str, String delimiter) {
        return StringUtil.tokenizeToStringArray(str, delimiter, false, false);
    }

    public static String[] tokenizeToStringArray(String str, String delimeter, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        if (delimeter == null) {
            return new String[]{str};
        }
        StringTokenizer st = new StringTokenizer(str, delimeter);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() == 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    @Deprecated
    public static String toLowercase(String str) {
        return StringUtil.changeFirstCharacterCase(false, str);
    }

    public static String toLowerCaseFirstLetter(String str) {
        return StringUtil.changeFirstCharacterCase(false, str);
    }

    public static String toSocialSecuNoPattern(String str) {
        if (str == null) {
            return DEFAULT_EMPTY_STRING;
        }
        if (str.length() != 13 || !NumberUtils.isDigits((String)str)) {
            return DEFAULT_EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(str.substring(0, 6));
        buffer.append('-');
        buffer.append(str.substring(6));
        return buffer.toString();
    }

    public static String toTelephoneNumberFormat(String str) {
        String tempNumber;
        int endNumberDigit = 4;
        int minNumberDigit = 7;
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        String origin = str.trim();
        int originLength = origin.length();
        if (!NumberUtils.isDigits((String)origin)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < originLength; ++i) {
                if (!Character.isDigit(origin.charAt(i))) continue;
                sb.append(origin.charAt(i));
            }
            tempNumber = sb.toString();
        } else {
            tempNumber = origin;
        }
        int numberLength = tempNumber.length();
        if (numberLength < minNumberDigit) {
            return tempNumber;
        }
        String firstNumber = DEFAULT_EMPTY_STRING;
        String secondNumber = DEFAULT_EMPTY_STRING;
        String thirdNumber = DEFAULT_EMPTY_STRING;
        if (tempNumber.charAt(0) == '0') {
            if (tempNumber.charAt(1) == '2') {
                firstNumber = tempNumber.substring(0, 2);
                secondNumber = tempNumber.substring(2, numberLength - endNumberDigit);
                thirdNumber = tempNumber.substring(numberLength - endNumberDigit, numberLength);
            } else {
                firstNumber = tempNumber.substring(0, 3);
                secondNumber = tempNumber.substring(3, numberLength - endNumberDigit);
                thirdNumber = tempNumber.substring(numberLength - endNumberDigit, numberLength);
            }
            return firstNumber + "-" + secondNumber + "-" + thirdNumber;
        }
        firstNumber = tempNumber.substring(0, numberLength - endNumberDigit);
        secondNumber = tempNumber.substring(numberLength - endNumberDigit, numberLength);
        return firstNumber + "-" + secondNumber;
    }

    @Deprecated
    public static String toUpperCase(String str) {
        return StringUtil.changeFirstCharacterCase(true, str);
    }

    public static String toUpperCaseFirstLetter(String str) {
        return StringUtil.changeFirstCharacterCase(true, str);
    }

    public static String toZipCodePattern(String str) {
        if (str == null) {
            return DEFAULT_EMPTY_STRING;
        }
        if (str.length() != 6 || !NumberUtils.isDigits((String)str)) {
            return DEFAULT_EMPTY_STRING;
        }
        return String.format("%s-%s", str.substring(0, 3), str.substring(3, 6));
    }

    @Deprecated
    public static String trim(String origString, String trimString) {
        int startPosit = origString.indexOf(trimString);
        if (startPosit != -1) {
            int endPosit = trimString.length() + startPosit;
            return origString.substring(0, startPosit) + origString.substring(endPosit);
        }
        return origString;
    }

    public static boolean trimEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        if (str2 == null) {
            return false;
        }
        String trimBaseStr = str1.trim();
        String trimTargetStr = str2.trim();
        return trimBaseStr.equals(trimTargetStr);
    }

    public static String unqualify(String str) {
        return StringUtil.unqualify(str, '.');
    }

    public static String unqualify(String str, char delimiter) {
        return str.substring(str.lastIndexOf(delimiter) + 1);
    }

    public static String convertStringCharset(String str, String charset) throws UnsupportedEncodingException {
        return new String(str.getBytes(charset), "UTF-8");
    }

    @Deprecated
    public static boolean isNumeric(String str) {
        return NumberUtils.isNumber((String)str);
    }

    @Deprecated
    public static boolean isFormattedString(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        return str.matches(regex);
    }

    public static boolean isRegexPatternMatch(String str, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isPatternMatching(String str, String pattern) {
        if (pattern.indexOf(42) >= 0) {
            pattern = pattern.replaceAll("\\*", ".*");
        }
        pattern = "^" + pattern + "$";
        return Pattern.matches(pattern, str);
    }

    private static String regexMetaCharEscape(String orgPattern) {
        return orgPattern.replaceAll("([\\[\\\\\\^\\$\\.\\|\\?\\*\\+\\(\\)])", "\\\\$1");
    }

    public static boolean isUserFormat(String str, String pattern) {
        String metaChange = StringUtil.regexMetaCharEscape(pattern);
        String regexChange = metaChange.replaceAll("#", "\\\\d").replaceAll("S", "[a-zA-Z]");
        return str.matches(regexChange);
    }

    public static boolean isPatternInclude(String str, String param) {
        if (param.indexOf("s") >= 0) {
            return StringUtil.isRegexPatternMatch(str, ".*[~!@\\#$%<>^&*\\()\\-=+_\\'].*");
        }
        if (param.indexOf("k") >= 0) {
            return StringUtil.isRegexPatternMatch(str, ".*[\u3131-\u314e|\u314f-\u3163|\uac00-\ud7a3].*");
        }
        if (param.indexOf("e") >= 0) {
            return StringUtil.isRegexPatternMatch(str, ".*[a-zA-Z].*");
        }
        if (param.indexOf("n") >= 0) {
            return StringUtil.isRegexPatternMatch(str, ".*\\d.*");
        }
        return true;
    }

    public static boolean isRegexPatternInclude(String str, String pattern) {
        return StringUtil.isRegexPatternMatch(str, ".*" + pattern + ".*");
    }
}

