/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.web.rest.jsonview;

import blue.hive.spring.web.rest.BHiveView;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Sort;

public class BHiveSort
extends Sort {
    private static final long serialVersionUID = -4227395649734560065L;

    public BHiveSort(List<Sort.Order> orders) {
        super(orders);
    }

    public static BHiveSort buildFrom(Sort sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            orders.add(new AbleOrder(order.getDirection(), order.getProperty(), order.getNullHandling()));
        }
        return new BHiveSort(orders);
    }

    public static class AbleOrder
    extends Sort.Order {
        private static final long serialVersionUID = -4235892487869747963L;

        public AbleOrder(String property) {
            super(property);
        }

        public AbleOrder(Sort.Direction direction, String property) {
            super(direction, property);
        }

        public AbleOrder(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
            super(direction, property, nullHandlingHint);
        }

        @JsonView(value={BHiveView.BaseView.class})
        public Sort.Direction getDirection() {
            return super.getDirection();
        }

        @JsonView(value={BHiveView.BaseView.class})
        public String getProperty() {
            return super.getProperty();
        }

        @JsonView(value={BHiveView.BaseView.class})
        public boolean isAscending() {
            return super.isAscending();
        }

        @JsonView(value={BHiveView.BaseView.class})
        public boolean isIgnoreCase() {
            return super.isIgnoreCase();
        }

        @JsonView(value={BHiveView.BaseView.class})
        public Sort.NullHandling getNullHandling() {
            return super.getNullHandling();
        }
    }
}

