/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http.converter;

import blue.hive.spring.http.BHiveTeeHttpInputMessage;
import blue.hive.spring.http.BHiveTeeHttpOutputMessage;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class BHiveTeeHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    HttpMessageConverter<T> httpConverter = null;

    public BHiveTeeHttpMessageConverter(HttpMessageConverter<T> httpConverter) {
        this.httpConverter = httpConverter;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.httpConverter.canRead(clazz, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.httpConverter.canWrite(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.httpConverter.getSupportedMediaTypes();
    }

    public T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        BHiveTeeHttpInputMessage teeHttpInputMessage = new BHiveTeeHttpInputMessage(inputMessage);
        Object result = this.httpConverter.read(clazz, (HttpInputMessage)teeHttpInputMessage);
        this.logger.debug("\r\n  >>>> READ: {}", (Object)teeHttpInputMessage.getTeeInputString());
        return (T)result;
    }

    public void write(T t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BHiveTeeHttpOutputMessage teeHttpOutputMessage = new BHiveTeeHttpOutputMessage(outputMessage);
        this.httpConverter.write(t, contentType, (HttpOutputMessage)teeHttpOutputMessage);
        this.logger.debug("\r\n  >>>> WRITE: {}", (Object)teeHttpOutputMessage.getTeeOutputString());
    }
}

