/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.servlet.filter;

import blue.hive.servlet.filter.wrap.BHiveTeeHttpServletResponse;
import blue.hive.util.BHiveHostingUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.CommonsRequestLoggingFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class BHiveCommonsRequestLoggingFilter
extends CommonsRequestLoggingFilter {
    private String antPatterns = "";
    private List<String> patterns = new ArrayList<String>();
    private String beforeMessagePrefix = "Before request [";
    private String beforeMessageSuffix = "]";
    private String afterMessagePrefix = "After request [";
    private String afterMessageSuffix = "]";
    private boolean includeResponsePayload = false;

    public String getAntPatterns() {
        return this.antPatterns;
    }

    public void setAntPatterns(String antPatterns) {
        this.antPatterns = antPatterns;
    }

    public void setBeforeMessagePrefix(String beforeMessagePrefix) {
        super.setBeforeMessagePrefix(beforeMessagePrefix);
        this.beforeMessagePrefix = beforeMessagePrefix;
    }

    public void setBeforeMessageSuffix(String beforeMessageSuffix) {
        super.setBeforeMessageSuffix(beforeMessageSuffix);
        this.beforeMessageSuffix = beforeMessageSuffix;
    }

    public void setAfterMessagePrefix(String afterMessagePrefix) {
        super.setAfterMessagePrefix(afterMessagePrefix);
        this.afterMessagePrefix = afterMessagePrefix;
    }

    public void setAfterMessageSuffix(String afterMessageSuffix) {
        super.setAfterMessageSuffix(afterMessageSuffix);
        this.afterMessageSuffix = afterMessageSuffix;
    }

    public boolean isIncludeResponsePayload() {
        return this.includeResponsePayload;
    }

    public void setIncludeResponsePayload(boolean includeResponsePayload) {
        this.includeResponsePayload = includeResponsePayload;
    }

    public BHiveCommonsRequestLoggingFilter() {
        this.setIncludeClientInfo(true);
        this.setIncludeQueryString(true);
        this.setIncludePayload(true);
        this.setMaxPayloadLength(1024);
        this.setIncludeResponsePayload(true);
        this.setBeforeMessagePrefix("\r\n##########################################################\r\n#### START: ");
        this.setBeforeMessageSuffix("");
        this.setAfterMessagePrefix("\r\n#### END: ");
        this.setAfterMessageSuffix("\r\n##########################################################");
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.antPatterns = this.getFilterConfig().getInitParameter("antPatterns");
        if (!StringUtils.isEmpty((Object)this.antPatterns)) {
            String[] tokens;
            for (String pattern : tokens = StringUtils.tokenizeToStringArray((String)this.antPatterns, (String)",")) {
                this.patterns.add(pattern);
            }
        }
        this.logger.debug((Object)("###### AbleCommonsRequestLoggingFilter - patterns: " + this.patterns));
    }

    protected boolean shouldLog(HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            if (this.patterns.size() > 0) {
                String servletPath = request.getServletPath();
                AntPathMatcher antPathMatcher = new AntPathMatcher();
                for (String pattern : this.patterns) {
                    boolean isMatch = antPathMatcher.match(pattern, servletPath);
                    if (!isMatch) continue;
                    return true;
                }
            }
            String path = request.getServletPath();
            return !(path = path.toLowerCase()).endsWith(".js") && !path.endsWith(".css") && !path.endsWith(".png") && !path.endsWith(".jpg") && !path.endsWith(".gif") && !path.endsWith(".map");
        }
        return false;
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        this.logger.debug((Object)message);
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        this.logger.debug((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean shouldLog;
        boolean isFirstRequest = !this.isAsyncDispatch(request);
        HttpServletRequest requestToUse = request;
        if (this.isIncludePayload() && isFirstRequest && !(request instanceof ContentCachingRequestWrapper)) {
            requestToUse = new ContentCachingRequestWrapper(request);
        }
        Object responseToUse = response;
        if (this.isIncludeResponsePayload() && isFirstRequest && !(response instanceof BHiveTeeHttpServletResponse)) {
            responseToUse = new BHiveTeeHttpServletResponse(response);
        }
        if ((shouldLog = this.shouldLog(requestToUse)) && isFirstRequest) {
            this.beforeRequest(requestToUse, this.getBeforeMessage(requestToUse));
        }
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        }
        finally {
            if (shouldLog && !this.isAsyncStarted(requestToUse)) {
                this.afterRequest(requestToUse, this.getAfterMessage(requestToUse, (HttpServletResponse)responseToUse));
            }
        }
    }

    private String getBeforeMessage(HttpServletRequest request) throws IOException {
        return this.createMessage(request, null, this.beforeMessagePrefix, this.beforeMessageSuffix);
    }

    private String getAfterMessage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.createMessage(request, response, this.afterMessagePrefix, this.afterMessageSuffix);
    }

    protected String createMessage(HttpServletRequest request, HttpServletResponse response, String prefix, String suffix) throws IOException {
        Object wrapper;
        byte[] buf;
        StringBuilder msg = new StringBuilder();
        msg.append(prefix);
        msg.append("uri: ").append(request.getRequestURI());
        if (this.isIncludeQueryString() && !StringUtils.isEmpty((Object)request.getQueryString())) {
            msg.append('?').append(request.getQueryString());
        }
        if (this.isIncludeClientInfo()) {
            String user;
            HttpSession session;
            String client = BHiveHostingUtil.getClientIP(request);
            if (StringUtils.hasLength((String)client)) {
                msg.append("\r\n#### - client: ").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                msg.append("\r\n#### - session: ").append(session.getId());
            }
            if ((user = request.getRemoteUser()) != null) {
                msg.append("\r\n#### - user: ").append(user);
            }
        }
        if (this.isIncludePayload() && request instanceof ContentCachingRequestWrapper && (buf = (wrapper = (ContentCachingRequestWrapper)request).getContentAsByteArray()).length > 0) {
            String payload;
            int length = Math.min(buf.length, this.getMaxPayloadLength());
            try {
                payload = new String(buf, 0, length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                payload = "[unknown]";
            }
            msg.append("\r\n#### - payload: ").append(StringUtils.trimWhitespace((String)payload));
        }
        if (this.isIncludeResponsePayload() && response != null && response instanceof BHiveTeeHttpServletResponse) {
            wrapper = (BHiveTeeHttpServletResponse)response;
            ((BHiveTeeHttpServletResponse)((Object)wrapper)).finish();
            String contentType = wrapper.getContentType();
            if (contentType != null) {
                byte[] buf2;
                msg.append("\r\n#### - responsecontenttype: ").append(contentType);
                if (contentType.contains("json") && (buf2 = ((BHiveTeeHttpServletResponse)((Object)wrapper)).getOutputBuffer()) != null && buf2.length > 0) {
                    String payload;
                    int length = Math.min(buf2.length, this.getMaxPayloadLength());
                    try {
                        payload = new String(buf2, 0, length, wrapper.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        payload = "[unknown]";
                    }
                    msg.append("\r\n#### - responsepayload: ").append(StringUtils.trimWhitespace((String)payload));
                }
            }
        }
        msg.append(suffix);
        return msg.toString();
    }
}

