/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.mybatis.typehandler;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class JodaLocalDateTimeTypeHandler
extends BaseTypeHandler<LocalDateTime> {
    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timeStamp = rs.getTimestamp(columnName);
        if (timeStamp == null) {
            return null;
        }
        return new LocalDateTime((Object)timeStamp);
    }

    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timeStamp = rs.getTimestamp(columnIndex);
        if (timeStamp == null) {
            return null;
        }
        return new LocalDateTime((Object)timeStamp);
    }

    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timeStamp = cs.getTimestamp(columnIndex);
        if (timeStamp == null) {
            return null;
        }
        return new LocalDateTime((Object)timeStamp);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setTimestamp(i, null);
        } else {
            DateTime dateTime = parameter.toDateTime(DateTimeZone.UTC);
            switch (jdbcType) {
                case DATE: {
                    ps.setDate(i, new Date(dateTime.getMillis()));
                    break;
                }
                default: {
                    ps.setTimestamp(i, new Timestamp(dateTime.getMillis()));
                }
            }
        }
    }
}

