/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.mybatis.typehandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanYNTypeHandler
extends BaseTypeHandler<Boolean> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private Boolean parseBoolean(String value) throws SQLException {
        Boolean result = "Y".equalsIgnoreCase(value) || "T".equalsIgnoreCase(value) ? Boolean.valueOf(true) : ("N".equalsIgnoreCase(value) || "F".equalsIgnoreCase(value) ? Boolean.valueOf(false) : null);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("\"" + value + "\" -> " + result);
        }
        return result;
    }

    private String convertToString(Boolean value) {
        String result;
        String string = result = value != null && value == true ? "Y" : "N";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(value + " -> \"" + result + "\"");
        }
        return result;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Boolean parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, this.convertToString(parameter));
    }

    public Boolean getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseBoolean(rs.getString(columnName));
    }

    public Boolean getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseBoolean(rs.getString(columnIndex));
    }

    public Boolean getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseBoolean(cs.getString(columnIndex));
    }
}

